/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.hadoop;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.configuration2.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.olap.job.IndexRemoveJob;
import org.janusgraph.graphdb.olap.job.IndexRepairJob;
import org.janusgraph.graphdb.olap.job.IndexUpdateJob;
import org.janusgraph.hadoop.HadoopStoreManager;
import org.janusgraph.hadoop.config.JanusGraphHadoopConfiguration;
import org.janusgraph.hadoop.config.ModifiableHadoopConfiguration;
import org.janusgraph.hadoop.scan.HadoopScanMapper;
import org.janusgraph.hadoop.scan.HadoopScanRunner;
import org.janusgraph.hadoop.scan.HadoopVertexScanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceIndexManagement {
    private static final Logger log = LoggerFactory.getLogger(MapReduceIndexManagement.class);
    private final StandardJanusGraph graph;
    private static final EnumSet<SchemaAction> SUPPORTED_ACTIONS = EnumSet.of(SchemaAction.REINDEX, SchemaAction.REMOVE_INDEX);
    private static final String SUPPORTED_ACTIONS_STRING = Joiner.on((String)", ").join(SUPPORTED_ACTIONS);

    public MapReduceIndexManagement(JanusGraph g) {
        this.graph = (StandardJanusGraph)g;
    }

    public JanusGraphManagement.IndexJobFuture updateIndex(Index index, SchemaAction updateAction) throws BackendException {
        return this.updateIndex(index, updateAction, new org.apache.hadoop.conf.Configuration());
    }

    public JanusGraphManagement.IndexJobFuture updateIndex(Index index, SchemaAction updateAction, org.apache.hadoop.conf.Configuration hadoopConf) throws BackendException {
        String readCF;
        Class mapperClass;
        Class<IndexRepairJob> indexJobClass;
        Preconditions.checkNotNull((Object)index, (String)"Index parameter must not be null", (Object)index);
        Preconditions.checkNotNull((Object)updateAction, (String)"%s parameter must not be null", (Object)SchemaAction.class.getSimpleName());
        Preconditions.checkArgument((boolean)SUPPORTED_ACTIONS.contains(updateAction), (String)"Only these %s parameters are supported: %s (was given %s)", (Object)SchemaAction.class.getSimpleName(), (Object)SUPPORTED_ACTIONS_STRING, (Object)updateAction);
        Preconditions.checkArgument((RelationTypeIndex.class.isAssignableFrom(index.getClass()) || JanusGraphIndex.class.isAssignableFrom(index.getClass()) ? 1 : 0) != 0, (String)"Index %s has class %s: must be a %s or %s (or subtype)", index.getClass(), (Object)RelationTypeIndex.class.getSimpleName(), (Object)JanusGraphIndex.class.getSimpleName());
        ModifiableHadoopConfiguration janusGraphMapReduceConfiguration = ModifiableHadoopConfiguration.of(JanusGraphHadoopConfiguration.MAPRED_NS, hadoopConf);
        if (updateAction.equals((Object)SchemaAction.REINDEX)) {
            indexJobClass = IndexRepairJob.class;
            mapperClass = HadoopVertexScanMapper.class;
        } else if (updateAction.equals((Object)SchemaAction.REMOVE_INDEX)) {
            indexJobClass = IndexRemoveJob.class;
            mapperClass = HadoopScanMapper.class;
        } else {
            throw new IllegalStateException("Unrecognized " + SchemaAction.class.getSimpleName() + ": " + updateAction);
        }
        if (RelationTypeIndex.class.isAssignableFrom(index.getClass())) {
            readCF = "edgestore";
        } else {
            JanusGraphIndex graphIndex = (JanusGraphIndex)index;
            if (graphIndex.isMixedIndex() && !updateAction.equals((Object)SchemaAction.REINDEX)) {
                throw new UnsupportedOperationException("External mixed indexes must be removed in the indexing system directly.");
            }
            Preconditions.checkState((boolean)JanusGraphIndex.class.isAssignableFrom(index.getClass()));
            readCF = updateAction.equals((Object)SchemaAction.REMOVE_INDEX) ? "graphindex" : "edgestore";
        }
        janusGraphMapReduceConfiguration.set(JanusGraphHadoopConfiguration.COLUMN_FAMILY_NAME, readCF, new String[0]);
        HadoopStoreManager storeManager = (HadoopStoreManager)this.graph.getBackend().getStoreManager().getHadoopManager();
        if (storeManager == null) {
            throw new IllegalArgumentException("Store manager class " + this.graph.getBackend().getStoreManagerClass() + "is not supported");
        }
        Class<? extends InputFormat> inputFormat = storeManager.getInputFormat(hadoopConf);
        String indexName = index.name();
        RelationType relationType = RelationTypeIndex.class.isAssignableFrom(index.getClass()) ? ((RelationTypeIndex)index).getType() : null;
        String relationTypeName = relationType == null ? "" : relationType.name();
        Preconditions.checkNotNull((Object)indexName);
        janusGraphMapReduceConfiguration.set(JanusGraphHadoopConfiguration.SCAN_JOB_CLASS, indexJobClass.getName(), new String[0]);
        MapReduceIndexManagement.copyIndexJobKeys(hadoopConf, indexName, relationTypeName);
        janusGraphMapReduceConfiguration.set(JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_ROOT, GraphDatabaseConfiguration.class.getName() + "#JOB_NS", new String[0]);
        Configuration localConfiguration = this.graph.getConfiguration().getConfigurationAtOpen();
        localConfiguration.clearProperty("gremlin.graph");
        MapReduceIndexManagement.copyInputKeys(hadoopConf, localConfiguration);
        String jobName = HadoopScanMapper.class.getSimpleName() + "[" + indexJobClass.getSimpleName() + "]";
        try {
            return new CompletedJobFuture(HadoopScanRunner.runJob(hadoopConf, inputFormat, jobName, mapperClass));
        }
        catch (Exception e) {
            return new FailedJobFuture(e);
        }
    }

    private static void copyInputKeys(org.apache.hadoop.conf.Configuration hadoopConf, Configuration source) {
        Iterator keyIter = source.getKeys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String k = ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.GRAPH_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + key;
            Object vObject = source.getProperty(key);
            String v = vObject instanceof Collection ? Joiner.on((String)",").join((Iterable)((Collection)vObject)) : vObject.toString();
            hadoopConf.set(k, v);
            log.debug("[inputkeys] Set {}={}", (Object)k, (Object)v);
        }
    }

    private static void copyIndexJobKeys(org.apache.hadoop.conf.Configuration hadoopConf, String indexName, String relationType) {
        hadoopConf.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + ConfigElement.getPath((ConfigElement)IndexUpdateJob.INDEX_NAME, (String[])new String[0]), indexName);
        hadoopConf.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + ConfigElement.getPath((ConfigElement)IndexUpdateJob.INDEX_RELATION_TYPE, (String[])new String[0]), relationType);
        hadoopConf.set(ConfigElement.getPath((ConfigElement)JanusGraphHadoopConfiguration.SCAN_JOB_CONFIG_KEYS, (boolean)true, (String[])new String[0]) + "." + ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.JOB_START_TIME, (String[])new String[0]), String.valueOf(System.currentTimeMillis()));
    }

    private static class FailedJobFuture
    implements JanusGraphManagement.IndexJobFuture {
        private final Throwable cause;

        public FailedJobFuture(Throwable cause) {
            this.cause = cause;
        }

        public ScanMetrics getIntermediateResult() throws ExecutionException {
            throw new ExecutionException(this.cause);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public ScanMetrics get() throws InterruptedException, ExecutionException {
            throw new ExecutionException(this.cause);
        }

        public ScanMetrics get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new ExecutionException(this.cause);
        }
    }

    private static class CompletedJobFuture
    implements JanusGraphManagement.IndexJobFuture {
        private final ScanMetrics completedJobMetrics;

        private CompletedJobFuture(ScanMetrics completedJobMetrics) {
            this.completedJobMetrics = completedJobMetrics;
        }

        public ScanMetrics getIntermediateResult() {
            return this.completedJobMetrics;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return true;
        }

        public ScanMetrics get() throws InterruptedException, ExecutionException {
            return this.completedJobMetrics;
        }

        public ScanMetrics get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.completedJobMetrics;
        }
    }
}

