/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.graphdb.tinkerpop.JanusGraphPSerializer;
import org.janusgraph.graphdb.tinkerpop.io.JanusGraphP;
import org.janusgraph.graphdb.tinkerpop.io.binary.GraphBinaryType;
import org.janusgraph.graphdb.tinkerpop.io.binary.JanusGraphTypeSerializer;

public class JanusGraphPBinarySerializer
extends JanusGraphTypeSerializer<JanusGraphP> {
    public JanusGraphPBinarySerializer() {
        super(GraphBinaryType.JanusGraphP);
    }

    @Override
    public JanusGraphP readNonNullableValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        String predicateName = (String)context.readValue(buffer, String.class, false);
        Object value = context.read(buffer);
        return JanusGraphPSerializer.createPredicateWithValue(predicateName, value);
    }

    @Override
    protected void writeNonNullableValue(JanusGraphP value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        String predicateName = value.getBiPredicate().toString();
        context.writeValue((Object)predicateName, buffer, false);
        Object arg = value.getValue();
        context.write(arg, buffer);
    }
}

