/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary;

import java.io.IOException;
import org.apache.commons.lang3.SerializationException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;
import org.janusgraph.graphdb.tinkerpop.io.binary.GraphBinaryType;

public abstract class JanusGraphTypeSerializer<T>
implements CustomTypeSerializer<T> {
    private GraphBinaryType type;

    protected JanusGraphTypeSerializer(GraphBinaryType type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.type.getTypeName();
    }

    public DataType getDataType() {
        return DataType.CUSTOM;
    }

    public T read(Buffer buffer, GraphBinaryReader context) throws IOException {
        int customTypeInfo = buffer.readInt();
        if (customTypeInfo != this.type.getTypeId()) {
            throw new SerializationException("Custom type info {" + customTypeInfo + "} doesn't match expect type info {" + this.type.getTypeId() + "}");
        }
        return this.readValue(buffer, context, true);
    }

    public T readValue(Buffer buffer, GraphBinaryReader context, boolean nullable) throws IOException {
        byte valueFlag;
        if (nullable && ((valueFlag = buffer.readByte()) & 1) == 1) {
            return null;
        }
        return this.readNonNullableValue(buffer, context);
    }

    public abstract T readNonNullableValue(Buffer var1, GraphBinaryReader var2) throws IOException;

    public void write(T value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeInt(this.type.getTypeId());
        this.writeValue(value, buffer, context, true);
    }

    public void writeValue(T value, Buffer buffer, GraphBinaryWriter context, boolean nullable) throws IOException {
        if (value == null) {
            if (!nullable) {
                throw new SerializationException("Unexpected null value when nullable is false");
            }
            context.writeValueFlagNull(buffer);
            return;
        }
        if (nullable) {
            context.writeValueFlagNone(buffer);
        }
        this.writeNonNullableValue(value, buffer, context);
    }

    protected abstract void writeNonNullableValue(T var1, Buffer var2, GraphBinaryWriter var3) throws IOException;
}

