/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.pkgtest;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.janusgraph.pkgtest.JanusGraphAssemblyBaseIT;
import org.janusgraph.util.system.IOUtils;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphOfTheGodsCompatIT
extends JanusGraphAssemblyBaseIT {
    private static final Logger log = LoggerFactory.getLogger(GraphOfTheGodsCompatIT.class);
    private static final String BDB_ES = "bdb-es";

    @Override
    protected String getGraphName() {
        return "graph-of-the-gods";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenAndQueryCompatibleDatabaseFiles() throws Exception {
        String compatManifest = Joiner.on((String)File.separator).join((Object)"target", (Object)"test-classes", new Object[]{"compat.csv"});
        BufferedReader compatReader = null;
        int lineNumber = 0;
        int tested = 0;
        try {
            String l;
            log.info("Opening compat manifest: {}", (Object)compatManifest);
            compatReader = new BufferedReader(new FileReader(compatManifest));
            while (null != (l = compatReader.readLine())) {
                ++lineNumber;
                String[] tokens = l.split(",");
                if (3 != tokens.length) {
                    log.warn("Ignoring line {} (splitting on commas yielded {} tokens instead of the expected {}): {}", new Object[]{lineNumber, tokens.length, 3, l});
                    continue;
                }
                String version = tokens[0].trim();
                String config = tokens[1].trim();
                String archiveUrl = tokens[2].trim();
                if (version.isEmpty()) {
                    log.warn("Ignoring line {} due to empty version field", (Object)lineNumber);
                    continue;
                }
                if (config.isEmpty()) {
                    log.warn("Ignoring line {} due to empty config field", (Object)lineNumber);
                    continue;
                }
                if (archiveUrl.isEmpty()) {
                    log.warn("Ignoring line {} due to empty archiveurl field", (Object)lineNumber);
                    continue;
                }
                if (!config.equals(BDB_ES)) {
                    log.warn("Ignoring line {} with unknown config string {} (only {} is supported)", new Object[]{lineNumber, config, BDB_ES});
                }
                this.downloadAndTest(archiveUrl);
                ++tested;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(compatReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)compatReader);
        log.info("Read compat manifest with {} lines ({} tested, {} ignored)", new Object[]{lineNumber, tested, lineNumber - tested});
    }

    private void downloadAndTest(String archiveUrl) throws IOException, InterruptedException {
        FileUtils.deleteQuietly((File)new File(ZIPFILE_EXTRACTED));
        this.unzip(BUILD_DIR, ZIPFILE_PATH);
        this.downloadFile(archiveUrl, "old_db.zip", new File(ZIPFILE_EXTRACTED));
        this.unzip(ZIPFILE_EXTRACTED, "old_db.zip");
        this.testGotGQueries("conf/janusgraph-berkeleyje-es.properties");
    }

    private void downloadFile(String url, String toLocalPath, File workingDir) throws IOException, InterruptedException {
        this.command(workingDir, "curl", "--output", toLocalPath, url);
    }

    private void testGotGQueries(String config) throws IOException, InterruptedException {
        String idxDir = new File(ZIPFILE_EXTRACTED + File.separator + "db" + File.separator + "es").getAbsolutePath();
        this.parseTemplateAndRunExpect("compat-test.expect.vm", (Map<String, String>)ImmutableMap.of((Object)"graphConfig", (Object)config, (Object)"graphToString", (Object)"berk", (Object)"indexDirectory", (Object)idxDir));
    }
}

