/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import io.vavr.collection.Seq;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyUnloggedFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public class CQLSimpleMutateManyUnloggedFunction
extends AbstractCQLMutateManyUnloggedFunction {
    public CQLSimpleMutateManyUnloggedFunction(int batchSize, CqlSession session, Map<String, CQLKeyColumnValueStore> openStores, TimestampProvider times, boolean assignTimestamp, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction) {
        super(times, assignTimestamp, session, openStores, batchSize, sleepAfterWriteFunction);
    }

    @Override
    protected Optional<Throwable> mutate(DistributedStoreManager.MaskedTimestamp commitTime, Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) {
        LinkedList resultList = new LinkedList();
        mutations.forEach((tableName, tableMutations) -> {
            CQLKeyColumnValueStore columnValueStore = this.getColumnValueStore((String)tableName);
            tableMutations.forEach((key, keyMutations) -> this.toGroupedBatchableStatementsSequenceIterator(commitTime, (KCVMutation)keyMutations, columnValueStore, (StaticBuffer)key).forEach(group -> {
                CompletableFuture<AsyncResultSet> completableFuture = this.execAsyncUnlogged((Seq<BatchableStatement<BoundStatement>>)group, txh);
                resultList.add(completableFuture);
            }));
        });
        for (CompletableFuture resultPart : resultList) {
            try {
                resultPart.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }
}

