/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql.function.mutate;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import io.vavr.collection.Iterator;
import io.vavr.collection.Seq;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.cql.function.ConsumerWithBackendException;
import org.janusgraph.diskstorage.cql.function.mutate.AbstractCQLMutateManyFunction;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;

public abstract class AbstractCQLMutateManyUnloggedFunction
extends AbstractCQLMutateManyFunction
implements CQLMutateManyFunction {
    private final CqlSession session;
    private final int batchSize;

    protected AbstractCQLMutateManyUnloggedFunction(TimestampProvider times, boolean assignTimestamp, CqlSession session, Map<String, CQLKeyColumnValueStore> openStores, int batchSize, ConsumerWithBackendException<DistributedStoreManager.MaskedTimestamp> sleepAfterWriteFunction) {
        super(sleepAfterWriteFunction, assignTimestamp, times, openStores);
        this.session = session;
        this.batchSize = batchSize;
    }

    @Override
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        DistributedStoreManager.MaskedTimestamp commitTime = (DistributedStoreManager.MaskedTimestamp)this.createMaskedTimestampFunction.apply(txh);
        Optional<Throwable> errorAfterExecution = this.mutate(commitTime, mutations, txh);
        if (errorAfterExecution.isPresent()) {
            throw CQLKeyColumnValueStore.EXCEPTION_MAPPER.apply(errorAfterExecution.get());
        }
        this.sleepAfterWriteFunction.accept(commitTime);
    }

    protected CompletableFuture<AsyncResultSet> execAsyncUnlogged(Seq<BatchableStatement<BoundStatement>> group, StoreTransaction txh) {
        return this.session.executeAsync(BatchStatement.newInstance((BatchType)DefaultBatchType.UNLOGGED).addAll(group).setConsistencyLevel(CQLTransaction.getTransaction(txh).getWriteConsistencyLevel())).toCompletableFuture();
    }

    protected Iterator<Seq<BatchableStatement<BoundStatement>>> toGroupedBatchableStatementsSequenceIterator(DistributedStoreManager.MaskedTimestamp commitTime, KCVMutation keyMutations, CQLKeyColumnValueStore columnValueStore, StaticBuffer key) {
        Iterator<BatchableStatement<BoundStatement>> deletions = this.deletionsFunction.getBatchableStatementsForColumnOperation(commitTime, keyMutations, columnValueStore, key);
        Iterator<BatchableStatement<BoundStatement>> additions = this.additionsFunction.getBatchableStatementsForColumnOperation(commitTime, keyMutations, columnValueStore, key);
        return Iterator.concat((Iterable[])new Iterable[]{deletions, additions}).grouped(this.batchSize);
    }

    protected abstract Optional<Throwable> mutate(DistributedStoreManager.MaskedTimestamp var1, Map<String, Map<StaticBuffer, KCVMutation>> var2, StoreTransaction var3);
}

