/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.codahale.metrics.MetricSet;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import io.vavr.API;
import io.vavr.Tuple;
import io.vavr.collection.Array;
import io.vavr.collection.Iterator;
import io.vavr.concurrent.Future;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.diskstorage.cql.CQLTransaction;
import org.janusgraph.diskstorage.cql.builder.CQLMutateManyFunctionBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLMutateManyFunctionWrapper;
import org.janusgraph.diskstorage.cql.builder.CQLProgrammaticConfigurationLoaderBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLSessionBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLStoreFeaturesBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLStoreFeaturesWrapper;
import org.janusgraph.diskstorage.cql.function.mutate.CQLMutateManyFunction;
import org.janusgraph.diskstorage.keycolumnvalue.KCVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.hadoop.CqlHadoopStoreManager;
import org.janusgraph.util.datastructures.ExceptionWrapper;
import org.janusgraph.util.stats.MetricManager;
import org.janusgraph.util.system.ExecuteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQLStoreManager
extends DistributedStoreManager
implements KeyColumnValueStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQLStoreManager.class);
    public static final String CONSISTENCY_LOCAL_QUORUM = "LOCAL_QUORUM";
    public static final String CONSISTENCY_QUORUM = "QUORUM";
    private static final int DEFAULT_PORT = 9042;
    protected static final CQLSessionBuilder DEFAULT_CQL_SESSION_BUILDER = new CQLSessionBuilder();
    protected static final CQLProgrammaticConfigurationLoaderBuilder DEFAULT_PROGRAMMATIC_CONFIGURATION_LOADER_BUILDER = new CQLProgrammaticConfigurationLoaderBuilder();
    protected static final CQLMutateManyFunctionBuilder DEFAULT_MUTATE_MANY_FUNCTION_BUILDER = new CQLMutateManyFunctionBuilder();
    protected static final CQLStoreFeaturesBuilder DEFAULT_STORE_FEATURES_BUILDER = new CQLStoreFeaturesBuilder();
    private final String keyspace;
    final ExecutorService executorService;
    private final long threadPoolShutdownMaxWaitTime;
    private final CQLMutateManyFunction executeManyFunction;
    private CqlSession session;
    private final StoreFeatures storeFeatures;
    private final Map<String, CQLKeyColumnValueStore> openStores;
    private final DistributedStoreManager.Deployment deployment;

    public CQLStoreManager(Configuration configuration) throws BackendException {
        this(configuration, DEFAULT_MUTATE_MANY_FUNCTION_BUILDER, DEFAULT_STORE_FEATURES_BUILDER, DEFAULT_CQL_SESSION_BUILDER, DEFAULT_PROGRAMMATIC_CONFIGURATION_LOADER_BUILDER);
    }

    public CQLStoreManager(Configuration configuration, CQLMutateManyFunctionBuilder mutateManyFunctionBuilder, CQLStoreFeaturesBuilder storeFeaturesBuilder, CQLSessionBuilder sessionBuilder, CQLProgrammaticConfigurationLoaderBuilder baseConfigurationLoaderBuilder) throws BackendException {
        super(configuration, 9042);
        this.keyspace = CQLStoreManager.determineKeyspaceName(configuration);
        this.openStores = new ConcurrentHashMap<String, CQLKeyColumnValueStore>();
        this.session = sessionBuilder.build(this.getStorageConfig(), this.hostnames, this.port, this.connectionTimeoutMS, baseConfigurationLoaderBuilder);
        try {
            this.threadPoolShutdownMaxWaitTime = (Long)configuration.get(CQLConfigOptions.EXECUTOR_SERVICE_MAX_SHUTDOWN_WAIT_TIME, new String[0]);
            this.initializeJmxMetrics();
            this.initializeKeyspace();
            CQLMutateManyFunctionWrapper mutateManyFunctionWrapper = mutateManyFunctionBuilder.build(this.session, configuration, this.times, this.assignTimestamp, this.openStores, arg_0 -> ((CQLStoreManager)this).sleepAfterWrite(arg_0));
            this.executorService = mutateManyFunctionWrapper.getExecutorService();
            this.executeManyFunction = mutateManyFunctionWrapper.getMutateManyFunction();
            CQLStoreFeaturesWrapper storeFeaturesWrapper = storeFeaturesBuilder.build(this.session, configuration, this.hostnames);
            this.deployment = storeFeaturesWrapper.getDeployment();
            this.storeFeatures = storeFeaturesWrapper.getStoreFeatures();
        }
        catch (Throwable throwable) {
            this.close();
            throw new PermanentBackendException("Couldn't initialize CQLStoreManager", throwable);
        }
    }

    private void initializeJmxMetrics() {
        Configuration configuration = this.getStorageConfig();
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.METRICS_JMX_ENABLED, new String[0])).booleanValue() && ((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue() && this.session.getMetrics().isPresent()) {
            MetricManager.INSTANCE.getRegistry().registerAll((MetricSet)((Metrics)this.session.getMetrics().get()).getRegistry());
        }
    }

    private void clearJmxMetrics() {
        Configuration configuration = this.getStorageConfig();
        if (((Boolean)configuration.get(GraphDatabaseConfiguration.METRICS_JMX_ENABLED, new String[0])).booleanValue() && ((Boolean)configuration.get(GraphDatabaseConfiguration.BASIC_METRICS, new String[0])).booleanValue() && this.session.getMetrics().isPresent()) {
            ((Metrics)this.session.getMetrics().get()).getRegistry().getNames().forEach(metricName -> MetricManager.INSTANCE.getRegistry().remove(metricName));
        }
    }

    void initializeKeyspace() {
        if (this.session.getMetadata().getKeyspace(this.keyspace).isPresent()) {
            return;
        }
        Configuration configuration = this.getStorageConfig();
        HashMap replication = ((io.vavr.collection.HashMap)API.Match((Object)configuration.get(CQLConfigOptions.REPLICATION_STRATEGY, new String[0])).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)"SimpleStrategy"), strategy -> io.vavr.collection.HashMap.of((Object)"class", (Object)strategy, (Object)"replication_factor", (Object)configuration.get(CQLConfigOptions.REPLICATION_FACTOR, new String[0]))), API.Case((API.Match.Pattern0)API.$((Object)"NetworkTopologyStrategy"), strategy -> io.vavr.collection.HashMap.of((Object)"class", (Object)strategy).merge(Array.of((Object[])((Object[])configuration.get(CQLConfigOptions.REPLICATION_OPTIONS, new String[0]))).grouped(2).toMap(array -> Tuple.of((Object)array.get(0), (Object)Integer.parseInt((String)array.get(1))))))})).toJavaMap();
        this.session.execute((Statement)((CreateKeyspace)SchemaBuilder.createKeyspace((String)this.keyspace).ifNotExists().withReplicationOptions((Map)replication)).build());
    }

    Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    CqlSession getSession() {
        return this.session;
    }

    String getKeyspaceName() {
        return this.keyspace;
    }

    @VisibleForTesting
    Map<String, String> getCompressionOptions(String name) throws BackendException {
        TableMetadata tableMetadata = this.getTableMetadata(name);
        Object compressionOptions = tableMetadata.getOptions().get(CqlIdentifier.fromCql((String)"compression"));
        return (Map)compressionOptions;
    }

    @VisibleForTesting
    Integer getGcGraceSeconds(String name) throws BackendException {
        TableMetadata tableMetadata = this.getTableMetadata(name);
        Object gcGraceSeconds = tableMetadata.getOptions().get(CqlIdentifier.fromCql((String)"gc_grace_seconds"));
        return (Integer)gcGraceSeconds;
    }

    @VisibleForTesting
    String getSpeculativeRetry(String name) throws BackendException {
        TableMetadata tableMetadata = this.getTableMetadata(name);
        Object res = tableMetadata.getOptions().get(CqlIdentifier.fromCql((String)"speculative_retry"));
        return (String)res;
    }

    @VisibleForTesting
    TableMetadata getTableMetadata(String name) throws BackendException {
        KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.keyspace).orElseThrow(() -> new PermanentBackendException(String.format("Unknown keyspace '%s'", this.keyspace)));
        return (TableMetadata)keyspaceMetadata.getTable(name).orElseThrow(() -> new PermanentBackendException(String.format("Unknown table '%s'", name)));
    }

    public void close() throws BackendException {
        try {
            ExceptionWrapper exceptionWrapper = new ExceptionWrapper();
            ExecuteUtil.executeWithCatching(this::clearJmxMetrics, (ExceptionWrapper)exceptionWrapper);
            ExecuteUtil.executeWithCatching(() -> ((CqlSession)this.session).close(), (ExceptionWrapper)exceptionWrapper);
            ExecuteUtil.throwIfException((ExceptionWrapper)exceptionWrapper);
        }
        finally {
            ExecuteUtil.gracefulExecutorServiceShutdown((ExecutorService)this.executorService, (long)this.threadPoolShutdownMaxWaitTime);
        }
    }

    public String getName() {
        return String.format("%s.%s", ((Object)((Object)this)).getClass().getSimpleName(), this.keyspace);
    }

    public DistributedStoreManager.Deployment getDeployment() {
        return this.deployment;
    }

    public StoreFeatures getFeatures() {
        return this.storeFeatures;
    }

    public KeyColumnValueStore openDatabase(String name, StoreMetaData.Container metaData) throws BackendException {
        return this.openStores.computeIfAbsent(name, n -> new CQLKeyColumnValueStore(this, (String)n, this.getStorageConfig(), () -> this.openStores.remove(n)));
    }

    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new CQLTransaction(config);
    }

    public void clearStorage() throws BackendException {
        if (((Boolean)this.storageConfig.get(GraphDatabaseConfiguration.DROP_ON_CLEAR, new String[0])).booleanValue()) {
            this.session.execute((Statement)SchemaBuilder.dropKeyspace((String)this.keyspace).build());
        } else if (this.exists()) {
            Future result = Future.sequence((Iterable)Iterator.ofAll(((KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.keyspace).get()).getTables().values()).map(table -> Future.fromJavaFuture(this.session.executeAsync((Statement)QueryBuilder.truncate((String)this.keyspace, (String)table.getName().toString()).build()).toCompletableFuture())));
            result.await();
        } else {
            LOGGER.info("Keyspace {} does not exist in the cluster", (Object)this.keyspace);
        }
    }

    public boolean exists() throws BackendException {
        return this.session.getMetadata().getKeyspace(this.keyspace).isPresent();
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        throw new UnsupportedOperationException();
    }

    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        this.executeManyFunction.mutateMany(mutations, txh);
    }

    public static String determineKeyspaceName(Configuration config) {
        return !config.has(CQLConfigOptions.KEYSPACE, new String[0]) && config.has(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) ? (String)config.get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]) : (String)config.get(CQLConfigOptions.KEYSPACE, new String[0]);
    }

    public Object getHadoopManager() {
        return new CqlHadoopStoreManager(this.session);
    }
}

