/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class TestLoggerUtils {
    private static final Constructor<ch.qos.logback.classic.Logger> LOGBACK_CONSTRUCTOR;
    private static final LoggerContext LOGBACK_CONTEXT;
    private static final ch.qos.logback.classic.Logger ROOT_LOGGER;
    private static final Level DEFAULT_LOGGING_LEVEL;

    public static ch.qos.logback.classic.Logger createLogbackLogger(Class<?> clazz, Level loggingLevel) {
        try {
            ch.qos.logback.classic.Logger logger = LOGBACK_CONSTRUCTOR.newInstance(clazz.getName(), ROOT_LOGGER, LOGBACK_CONTEXT);
            logger.setLevel(loggingLevel);
            return logger;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void processWithLoggerReplacement(Consumer<ch.qos.logback.classic.Logger> processWithLoggerReplacementFunction, Class<?> classWhereToReplaceLogger) {
        TestLoggerUtils.processWithLoggerReplacement(processWithLoggerReplacementFunction, classWhereToReplaceLogger, DEFAULT_LOGGING_LEVEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processWithLoggerReplacement(Consumer<ch.qos.logback.classic.Logger> processWithLoggerReplacementFunction, Class<?> classWhereToReplaceLogger, Level loggingLevel) {
        Field loggerField = TestLoggerUtils.getModifiableLoggerField(classWhereToReplaceLogger);
        Logger originalLogger = TestLoggerUtils.getLoggerFromField(loggerField);
        try {
            ch.qos.logback.classic.Logger loggerToUseInFunction = TestLoggerUtils.createLogbackLogger(classWhereToReplaceLogger, loggingLevel);
            TestLoggerUtils.replaceLoggerField(loggerField, (Logger)loggerToUseInFunction);
            processWithLoggerReplacementFunction.accept(loggerToUseInFunction);
            loggerToUseInFunction.detachAndStopAllAppenders();
        }
        finally {
            TestLoggerUtils.replaceLoggerField(loggerField, originalLogger);
        }
    }

    public static Field getModifiableLoggerField(Class<?> clazz) {
        Field loggerField = Arrays.stream(clazz.getDeclaredFields()).filter(field -> Logger.class.isAssignableFrom(field.getType())).findFirst().orElseThrow(() -> new IllegalStateException("No logger found in class " + clazz.getName()));
        try {
            loggerField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(loggerField, loggerField.getModifiers() & 0xFFFFFFEF);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return loggerField;
    }

    public static Logger getLoggerFromField(Field loggerField) {
        try {
            return (Logger)loggerField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void replaceLoggerField(Field loggerField, Logger logger) {
        try {
            loggerField.set(null, logger);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static ListAppender<ILoggingEvent> registerListAppender(ch.qos.logback.classic.Logger logger) {
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        logger.addAppender((Appender)listAppender);
        return listAppender;
    }

    static {
        LOGBACK_CONTEXT = new LoggerContext();
        ROOT_LOGGER = LOGBACK_CONTEXT.getLogger("ROOT");
        DEFAULT_LOGGING_LEVEL = Level.DEBUG;
        try {
            LOGBACK_CONSTRUCTOR = ch.qos.logback.classic.Logger.class.getDeclaredConstructor(String.class, ch.qos.logback.classic.Logger.class, LoggerContext.class);
            LOGBACK_CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }
}

