/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.cql;

import io.github.artsok.RepeatedIfExceptionsTest;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.JanusGraphTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLGraphTest
extends JanusGraphTest {
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    public WriteConfiguration getConfiguration() {
        return cqlContainer.getConfiguration(((Object)((Object)this)).getClass().getSimpleName()).getConfiguration();
    }

    @Test
    public void testHasTTL() {
        Assertions.assertTrue((boolean)this.features.hasCellTTL());
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void simpleLogTest() throws InterruptedException {
        super.simpleLogTest();
    }

    protected static Stream<Arguments> generateConsistencyConfigs() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, true, 20, true}), Arguments.arguments((Object[])new Object[]{true, false, 20, true}), Arguments.arguments((Object[])new Object[]{true, false, 1, true}), Arguments.arguments((Object[])new Object[]{false, true, 20, true}), Arguments.arguments((Object[])new Object[]{false, false, 20, true}), Arguments.arguments((Object[])new Object[]{false, false, 1, true}), Arguments.arguments((Object[])new Object[]{true, true, 20, false}), Arguments.arguments((Object[])new Object[]{true, false, 20, false}), Arguments.arguments((Object[])new Object[]{true, false, 1, false}), Arguments.arguments((Object[])new Object[]{false, true, 20, false}), Arguments.arguments((Object[])new Object[]{false, false, 20, false}), Arguments.arguments((Object[])new Object[]{false, false, 1, false})});
    }

    @Test
    @Disabled
    public void testConsistencyEnforcement() {
    }

    @ParameterizedTest
    @MethodSource(value={"generateConsistencyConfigs"})
    public void testConsistencyEnforcement(boolean assignTimestamp, boolean atomicBatch, int batchSize, boolean executorServiceEnabled) {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.ASSIGN_TIMESTAMP, (String[])new String[0]), assignTimestamp, CQLGraphTest.option((ConfigOption)CQLConfigOptions.ATOMIC_BATCH_MUTATE, (String[])new String[0]), atomicBatch, CQLGraphTest.option((ConfigOption)CQLConfigOptions.BATCH_STATEMENT_SIZE, (String[])new String[0]), batchSize, CQLGraphTest.option((ConfigOption)CQLConfigOptions.EXECUTOR_SERVICE_ENABLED, (String[])new String[0]), executorServiceEnabled});
        super.testConsistencyEnforcement();
    }

    @Test
    @Disabled
    public void testConcurrentConsistencyEnforcement() {
    }

    @ParameterizedTest
    @MethodSource(value={"generateConsistencyConfigs"})
    public void testConcurrentConsistencyEnforcement(boolean assignTimestamp, boolean atomicBatch, int batchSize, boolean executorServiceEnabled) throws Exception {
        this.clopen(new Object[]{CQLGraphTest.option((ConfigOption)GraphDatabaseConfiguration.ASSIGN_TIMESTAMP, (String[])new String[0]), assignTimestamp, CQLGraphTest.option((ConfigOption)CQLConfigOptions.ATOMIC_BATCH_MUTATE, (String[])new String[0]), atomicBatch, CQLGraphTest.option((ConfigOption)CQLConfigOptions.BATCH_STATEMENT_SIZE, (String[])new String[0]), batchSize, CQLGraphTest.option((ConfigOption)CQLConfigOptions.EXECUTOR_SERVICE_ENABLED, (String[])new String[0]), executorServiceEnabled});
        super.testConcurrentConsistencyEnforcement();
    }

    @Test
    public void testQueryLongForPropertyKey() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        String testName = RandomStringUtils.random((int)100000, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new Random(0L));
        GraphTraversalSource g = this.graph.traversal();
        JanusGraphException ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> g.V(new Object[0]).has("name", (Object)testName).hasNext());
        Assertions.assertEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)ex, TemporaryBackendException.class), (String)"Query should not produce a TemporaryBackendException");
        Assertions.assertNotEquals((int)-1, (int)ExceptionUtils.indexOfType((Throwable)ex, PermanentBackendException.class), (String)"Query should produce a PermanentBackendException");
    }
}

