/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import java.time.Duration;
import java.util.Map;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.cql.builder.CQLProgrammaticConfigurationLoaderBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLSessionBuilder;

public class CachingCQLSessionBuilder
extends CQLSessionBuilder {
    private final Map<String, CqlSession> sessions;
    private final String keyspaceName;

    public CachingCQLSessionBuilder(Map<String, CqlSession> sessions, String keyspaceName) {
        this.sessions = sessions;
        this.keyspaceName = keyspaceName;
    }

    public CqlSession build(Configuration configuration, String[] baseHostnames, int baseDefaultPort, Duration baseConnectionTimeoutMS, CQLProgrammaticConfigurationLoaderBuilder baseConfigurationLoaderBuilder) throws PermanentBackendException {
        if (!this.sessions.containsKey(this.keyspaceName)) {
            this.sessions.put(this.keyspaceName, super.build(configuration, baseHostnames, baseDefaultPort, baseConnectionTimeoutMS, baseConfigurationLoaderBuilder));
        }
        return this.sessions.get(this.keyspaceName);
    }
}

