/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.KeyColumnValueStoreTest;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLStoreManager;
import org.janusgraph.diskstorage.cql.CachingCQLStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.testutil.FeatureFlag;
import org.janusgraph.testutil.JanusGraphFeature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@ExtendWith(value={MockitoExtension.class})
@Testcontainers
public class CQLStoreTest
extends KeyColumnValueStoreTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(CQLStoreTest.class);
    private static final String TEST_CF_NAME = "testcf";
    private static final String DEFAULT_COMPRESSOR_PACKAGE = "org.apache.cassandra.io.compress";
    private static final String TEST_KEYSPACE_NAME = CQLStoreTest.class.getSimpleName();
    @Mock
    private CqlSession session;
    @InjectMocks
    private CQLStoreManager mockManager = new CQLStoreManager((Configuration)this.getBaseStorageConfiguration());
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    protected ModifiableConfiguration getBaseStorageConfiguration() {
        return cqlContainer.getConfiguration(((Object)((Object)this)).getClass().getSimpleName());
    }

    private CQLStoreManager openStorageManager(Configuration c) throws BackendException {
        return new CachingCQLStoreManager(c);
    }

    public CQLStoreManager openStorageManager() throws BackendException {
        return this.openStorageManager((Configuration)this.getBaseStorageConfiguration());
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.UnorderedScan)
    public void testUnorderedConfiguration(TestInfo testInfo) {
        StoreFeatures features = this.manager.getFeatures();
        Assertions.assertFalse((boolean)features.hasLocalKeyPartition());
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.OrderedScan)
    public void testOrderedConfiguration(TestInfo testInfo) {
        StoreFeatures features = this.manager.getFeatures();
        Assertions.assertTrue((boolean)features.isKeyOrdered());
    }

    @Test
    public void testExternalLocking() throws BackendException {
        Assertions.assertFalse((boolean)this.manager.getFeatures().hasLocking());
        Assertions.assertTrue((boolean)this.openStorageManager((Configuration)this.getBaseStorageConfiguration().set(CQLConfigOptions.USE_EXTERNAL_LOCKING, (Object)true, new String[0])).getFeatures().hasLocking());
    }

    @Test
    public void testDefaultCFCompressor() throws BackendException {
        String cf = "testcf_snappy";
        CQLStoreManager cqlStoreManager = this.openStorageManager();
        cqlStoreManager.openDatabase("testcf_snappy");
        Map opts = cqlStoreManager.getCompressionOptions("testcf_snappy");
        Assertions.assertEquals((int)2, (int)opts.size());
        Assertions.assertEquals((Object)"64", opts.getOrDefault("chunk_length_kb", opts.get("chunk_length_in_kb")));
        Assertions.assertEquals((Object)("org.apache.cassandra.io.compress." + (String)CQLConfigOptions.CF_COMPRESSION_TYPE.getDefaultValue()), opts.getOrDefault("sstable_compression", opts.get("class")));
    }

    @Test
    public void testCustomCFCompressor() throws BackendException {
        String cname = "DeflateCompressor";
        int ckb = 128;
        String cf = "testcf_gzip";
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(CQLConfigOptions.CF_COMPRESSION_TYPE, (Object)"DeflateCompressor", new String[0]);
        config.set(CQLConfigOptions.CF_COMPRESSION_BLOCK_SIZE, (Object)128, new String[0]);
        CQLStoreManager mgr = this.openStorageManager((Configuration)config);
        mgr.openDatabase("testcf_gzip");
        Map opts = mgr.getCompressionOptions("testcf_gzip");
        Assertions.assertEquals((int)2, (int)opts.size());
        Assertions.assertEquals((Object)String.valueOf(128), opts.getOrDefault("chunk_length_kb", opts.get("chunk_length_in_kb")));
        Assertions.assertEquals((Object)"org.apache.cassandra.io.compress.DeflateCompressor", opts.getOrDefault("sstable_compression", opts.get("class")));
    }

    @Test
    public void testDisableCFCompressor() throws BackendException {
        String cf = "testcf_nocompress";
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(CQLConfigOptions.CF_COMPRESSION, (Object)false, new String[0]);
        CQLStoreManager mgr = this.openStorageManager((Configuration)config);
        mgr.openDatabase("testcf_nocompress");
        HashMap opts = new HashMap(mgr.getCompressionOptions("testcf_nocompress"));
        if ("false".equals(opts.get("enabled"))) {
            opts.remove("enabled");
        }
        Assertions.assertEquals(Collections.emptyMap(), opts);
    }

    @Test
    public void testCqlMetricsInitialization() throws BackendException, InterruptedException {
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(CQLConfigOptions.KEYSPACE, (Object)"testkeyspace_metrics", new String[0]);
        config.set(GraphDatabaseConfiguration.BASIC_METRICS, (Object)true, new String[0]);
        config.set(CQLConfigOptions.METRICS_NODE_ENABLED, (Object)"pool.open-connections,pool.available-streams,pool.in-flight,bytes-sent,bytes-received,cql-messages".split(","), new String[0]);
        config.set(CQLConfigOptions.METRICS_SESSION_ENABLED, (Object)"bytes-sent,bytes-received,cql-requests,cql-client-timeouts,throttling.delay,throttling.queue-size,throttling.errors".split(","), new String[0]);
        this.openStorageManager((Configuration)config);
    }

    @Test
    public void testSetGcGraceSeconds() throws BackendException {
        String cf = "testcf_set_gc_grace_seconds";
        int oneDayInSeconds = 86400;
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(CQLConfigOptions.GC_GRACE_SECONDS, (Object)86400, new String[0]);
        CQLStoreManager cqlStoreManager = this.openStorageManager((Configuration)config);
        cqlStoreManager.openDatabase("testcf_set_gc_grace_seconds");
        Assertions.assertEquals((int)86400, (Integer)cqlStoreManager.getGcGraceSeconds("testcf_set_gc_grace_seconds"));
    }

    @ParameterizedTest
    @MethodSource(value={"validSpeculativeRetryProvider"})
    public void testValidSpeculativeRetry(int idx, String input, String pattern) throws BackendException {
        String cf = "testcf_valid_speculative_retry_" + idx;
        ModifiableConfiguration config = this.getBaseStorageConfiguration();
        config.set(CQLConfigOptions.SPECULATIVE_RETRY, (Object)input, new String[0]);
        CQLStoreManager cqlStoreManager = this.openStorageManager((Configuration)config);
        cqlStoreManager.openDatabase(cf);
        String value = cqlStoreManager.getSpeculativeRetry(cf);
        if (!Pattern.matches(pattern, value)) {
            Assertions.fail((String)("Pattern " + pattern + " doesn\u00b4t match " + value));
        }
    }

    public static Stream<Arguments> validSpeculativeRetryProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{0, "NONE", "(NONE|NEVER)"}), Arguments.arguments((Object[])new Object[]{1, "ALWAYS", "ALWAYS"}), Arguments.arguments((Object[])new Object[]{2, "95percentile", "95(?:\\.0+)?(PERCENTILE|p)"}), Arguments.arguments((Object[])new Object[]{3, "99PERCENTILE", "99(?:\\.0+)?(PERCENTILE|p)"}), Arguments.arguments((Object[])new Object[]{4, "99.9PERCENTILE", "99\\.90*(PERCENTILE|p)"}), Arguments.arguments((Object[])new Object[]{5, "100ms", "100(?:\\.0+)?ms"}), Arguments.arguments((Object[])new Object[]{6, "100MS", "100(?:\\.0+)?ms"}), Arguments.arguments((Object[])new Object[]{7, "100.9ms", "100(\\.90*)*ms"}));
    }

    @Test
    public void testTTLSupported() {
        StoreFeatures features = this.manager.getFeatures();
        Assertions.assertTrue((boolean)features.hasCellTTL());
    }

    @Test
    public void testExistKeyspaceSession() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)Mockito.mock(KeyspaceMetadata.class);
        Optional<KeyspaceMetadata> keyspaceMetadataOptional = Optional.of(keyspaceMetadata);
        Mockito.when((Object)this.session.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getKeyspace(TEST_KEYSPACE_NAME)).thenReturn(keyspaceMetadataOptional);
        this.mockManager.initializeKeyspace();
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).execute((Statement)Mockito.any(Statement.class));
    }

    @Test
    public void testNewKeyspaceSession() {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Optional keyspaceMetadataOptional = Optional.empty();
        Mockito.when((Object)this.session.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getKeyspace(TEST_KEYSPACE_NAME)).thenReturn(keyspaceMetadataOptional);
        this.mockManager.initializeKeyspace();
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).execute((Statement)Mockito.any(Statement.class));
    }

    @Test
    public void testExistTableOpenDatabase() throws BackendException {
        String someTableName = "foo";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)Mockito.mock(KeyspaceMetadata.class);
        TableMetadata tableMetadata = (TableMetadata)Mockito.mock(TableMetadata.class);
        Mockito.when((Object)keyspaceMetadata.getTable(someTableName)).thenReturn(Optional.of(tableMetadata));
        Mockito.when((Object)this.session.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getKeyspace(this.mockManager.getKeyspaceName())).thenReturn(Optional.of(keyspaceMetadata));
        this.mockManager.openDatabase(someTableName, null);
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.never())).execute((Statement)Mockito.any(Statement.class));
    }

    @Test
    public void testNewTableOpenDatabase() throws BackendException {
        String someTableName = "foo";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        KeyspaceMetadata keyspaceMetadata = (KeyspaceMetadata)Mockito.mock(KeyspaceMetadata.class);
        Mockito.when((Object)keyspaceMetadata.getTable(someTableName)).thenReturn(Optional.empty());
        Mockito.when((Object)this.session.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getKeyspace(this.mockManager.getKeyspaceName())).thenReturn(Optional.of(keyspaceMetadata));
        this.mockManager.openDatabase(someTableName, null);
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)1))).execute((Statement)Mockito.any(Statement.class));
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.UnorderedScan)
    public void testGetKeysWithoutOrderedScan() throws BackendException, NoSuchFieldException, IllegalAccessException {
        Field field = StandardStoreFeatures.class.getDeclaredField("orderedScan");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(this.manager.getFeatures(), false);
        Exception ex = (Exception)Assertions.assertThrows(PermanentBackendException.class, () -> this.store.getKeys(new KeyRangeQuery(BufferUtil.getLongBuffer((long)1L), BufferUtil.getLongBuffer((long)1000L), BufferUtil.getLongBuffer((long)1L), BufferUtil.getLongBuffer((long)1000L)), this.tx));
        Assertions.assertEquals((Object)"This operation is only allowed when the byteorderedpartitioner is used.", (Object)ex.getMessage());
        Assertions.assertDoesNotThrow(() -> this.store.getKeys(new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)4)), this.tx));
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.OrderedScan)
    public void testGetKeysWithoutUnorderedScan() throws BackendException, NoSuchFieldException, IllegalAccessException {
        Field field = StandardStoreFeatures.class.getDeclaredField("unorderedScan");
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(this.manager.getFeatures(), false);
        Exception ex = (Exception)Assertions.assertThrows(PermanentBackendException.class, () -> this.store.getKeys(new SliceQuery(BufferUtil.zeroBuffer((int)1), BufferUtil.oneBuffer((int)4)), this.tx));
        Assertions.assertEquals((Object)"This operation is only allowed when partitioner supports unordered scan", (Object)ex.getMessage());
        Assertions.assertDoesNotThrow(() -> this.store.getKeys(new KeyRangeQuery(BufferUtil.getLongBuffer((long)1L), BufferUtil.getLongBuffer((long)1000L), BufferUtil.getLongBuffer((long)1L), BufferUtil.getLongBuffer((long)1000L)), this.tx));
    }

    public CQLStoreManager openStorageManagerForClearStorageTest() throws Exception {
        return this.openStorageManager((Configuration)this.getBaseStorageConfiguration().set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)true, new String[0]));
    }
}

