/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.CQLKeyColumnValueStore;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class CQLKeyColumnValueStoreTest {
    @Test
    public void testCompactionStrategyWithoutOptions() {
        CreateTable createTable = SchemaBuilder.createTable((String)"tableName").withPartitionKey("column", DataTypes.BLOB);
        ModifiableConfiguration configuration = GraphDatabaseConfiguration.buildGraphConfiguration().set(CQLConfigOptions.COMPACTION_STRATEGY, (Object)"LeveledCompactionStrategy", new String[0]);
        Assertions.assertDoesNotThrow(() -> CQLKeyColumnValueStoreTest.lambda$testCompactionStrategyWithoutOptions$0((CreateTableWithOptions)createTable, (Configuration)configuration));
    }

    @Test
    public void testCompactionStrategyWithOptions() {
        CreateTable createTable = SchemaBuilder.createTable((String)"tableName").withPartitionKey("column", DataTypes.BLOB);
        ModifiableConfiguration configuration = GraphDatabaseConfiguration.buildGraphConfiguration().set(CQLConfigOptions.COMPACTION_OPTIONS, (Object)new String[]{"enabled", "false"}, new String[0]).set(CQLConfigOptions.COMPACTION_STRATEGY, (Object)"LeveledCompactionStrategy", new String[0]);
        Assertions.assertDoesNotThrow(() -> CQLKeyColumnValueStoreTest.lambda$testCompactionStrategyWithOptions$1((CreateTableWithOptions)createTable, (Configuration)configuration));
    }

    private static /* synthetic */ void lambda$testCompactionStrategyWithOptions$1(CreateTableWithOptions createTable, Configuration configuration) throws Throwable {
        CQLKeyColumnValueStore.compactionOptions((CreateTableWithOptions)createTable, (Configuration)configuration);
    }

    private static /* synthetic */ void lambda$testCompactionStrategyWithoutOptions$0(CreateTableWithOptions createTable, Configuration configuration) throws Throwable {
        CQLKeyColumnValueStore.compactionOptions((CreateTableWithOptions)createTable, (Configuration)configuration);
    }
}

