/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.tracker.RequestLogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.diskstorage.cql.builder.CQLProgrammaticConfigurationLoaderBuilder;
import org.janusgraph.diskstorage.cql.builder.CQLSessionBuilder;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.JanusGraphConstants;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLConfigTest {
    private static final Logger log = LoggerFactory.getLogger(CQLConfigTest.class);
    private static final String DATASTAX_JAVA_DRIVER_STRING_CONFIGURATION_PATTERN = "datastax-java-driver {\nadvanced.address-translator.class = \"PassThroughAddressTranslator\"\nbasic.contact-points = [ \"${hostname}:${port}\" ]\nbasic.session-name = JanusGraphCQLSession\nbasic.load-balancing-policy{\n    local-datacenter = \"${datacenter}\"\n}\nbasic.request.timeout = ${timeout} milliseconds\nadvanced.connection.connect-timeout = ${timeout} milliseconds\n}\n";
    private static final String DATASTAX_JAVA_DRIVER_STRING_KEYSPACE_ONLY_CONFIGURATION_PATTERN = "datastax-java-driver {\nbasic.session-keyspace = testkeyspace\n}\n";
    private static final String DATASTAX_JAVA_DRIVER_STRING_CONTACT_POINTS_ONLY_CONFIGURATION_PATTERN = "datastax-java-driver {\nbasic.contact-points = [ \"${hostname}:${port}\" ]\n}\n";
    private static final String DATASTAX_JAVA_DRIVER_STRING_CONNECTION_TIMEOUT_ONLY_CONFIGURATION_PATTERN = "datastax-java-driver {\nadvanced.connection.connect-timeout = 54321 milliseconds\n}\n";
    private StandardJanusGraph graph;
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    @BeforeEach
    public void ensureCQLContainerIsOpened() {
        if (!cqlContainer.isRunning()) {
            cqlContainer.start();
        }
    }

    @AfterEach
    public void tearDown() {
        if (this.graph != null && this.graph.isOpen()) {
            this.graph.close();
        }
    }

    private WriteConfiguration getConfiguration() {
        return cqlContainer.getConfiguration(this.getClass().getSimpleName()).getConfiguration();
    }

    public static Stream<Arguments> getMetadataConfigs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, true, true}), Arguments.of((Object[])new Object[]{null, true, false}), Arguments.of((Object[])new Object[]{null, false, true}), Arguments.of((Object[])new Object[]{null, false, false}), Arguments.of((Object[])new Object[]{"Murmur3Partitioner", true, true}), Arguments.of((Object[])new Object[]{"Murmur3Partitioner", true, false}), Arguments.of((Object[])new Object[]{"Murmur3Partitioner", false, true}), Arguments.of((Object[])new Object[]{"Murmur3Partitioner", false, false}));
    }

    @Test
    public void testTitanGraphBackwardCompatibility() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.KEYSPACE, (String[])new String[0]), (Object)"titan");
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), (Object)"x.x.x");
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, (String[])new String[0]), GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION.getDatatype()));
        Assertions.assertFalse((boolean)JanusGraphConstants.TITAN_COMPATIBLE_VERSIONS.contains(wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS.getDatatype())));
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), (Object)"1.0.0");
        Assertions.assertTrue((boolean)JanusGraphConstants.TITAN_COMPATIBLE_VERSIONS.contains(wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS, (String[])new String[0]), GraphDatabaseConfiguration.TITAN_COMPATIBLE_VERSIONS.getDatatype())));
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
    }

    @Test
    public void testStorageVersionSet() {
        WriteConfiguration wc = this.getConfiguration();
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, (String[])new String[0]), GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION.getDatatype()));
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.INITIAL_STORAGE_VERSION, (String[])new String[0]), (Object)JanusGraphConstants.STORAGE_VERSION);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        JanusGraphManagement mgmt = this.graph.openManagement();
        Assertions.assertEquals((Object)JanusGraphConstants.STORAGE_VERSION, (Object)mgmt.get("graph.storage-version"));
        mgmt.rollback();
    }

    private String getCurrentPartitionerName() {
        switch (System.getProperty("cassandra.docker.partitioner")) {
            case "byteordered": {
                return "ByteOrderedPartitioner";
            }
        }
        return "Murmur3Partitioner";
    }

    @ParameterizedTest
    @MethodSource(value={"getMetadataConfigs"})
    public void testMetaDataGraphConfig(String partitionerName, boolean schemaEnabled, boolean tokenMapEnabled) {
        WriteConfiguration wc = this.getConfiguration();
        String currentPartitionerName = this.getCurrentPartitionerName();
        if (partitionerName != null) {
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.PARTITIONER_NAME, (String[])new String[0]), (Object)partitionerName);
        }
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.METADATA_SCHEMA_ENABLED, (String[])new String[0]), CQLConfigOptions.METADATA_SCHEMA_ENABLED.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.METADATA_TOKEN_MAP_ENABLED, (String[])new String[0]), CQLConfigOptions.METADATA_TOKEN_MAP_ENABLED.getDatatype()));
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.METADATA_SCHEMA_ENABLED, (String[])new String[0]), (Object)schemaEnabled);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.METADATA_TOKEN_MAP_ENABLED, (String[])new String[0]), (Object)tokenMapEnabled);
        if (tokenMapEnabled && partitionerName != null && !partitionerName.equals(currentPartitionerName) || !tokenMapEnabled && partitionerName == null) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> JanusGraphFactory.open((ReadConfiguration)wc));
        } else {
            JanusGraphFactory.open((ReadConfiguration)wc);
        }
    }

    @Test
    public void testGraphConfigUsedByThreadBoundTx() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.READ_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.WRITE_CONSISTENCY, (String[])new String[0]), (Object)"LOCAL_QUORUM");
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)this.graph.getCurrentThreadTx();
        Assertions.assertEquals((Object)"ALL", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(CQLConfigOptions.READ_CONSISTENCY, new String[0]));
        Assertions.assertEquals((Object)"LOCAL_QUORUM", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(CQLConfigOptions.WRITE_CONSISTENCY, new String[0]));
    }

    @Test
    public void testGraphConfigUsedByTx() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.READ_CONSISTENCY, (String[])new String[0]), (Object)"TWO");
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.WRITE_CONSISTENCY, (String[])new String[0]), (Object)"THREE");
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)this.graph.newTransaction();
        Assertions.assertEquals((Object)"TWO", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(CQLConfigOptions.READ_CONSISTENCY, new String[0]));
        Assertions.assertEquals((Object)"THREE", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(CQLConfigOptions.WRITE_CONSISTENCY, new String[0]));
        tx.rollback();
    }

    @Test
    public void testCustomConfigUsedByTx() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.READ_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.WRITE_CONSISTENCY, (String[])new String[0]), (Object)"ALL");
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        StandardJanusGraphTx tx = (StandardJanusGraphTx)this.graph.buildTransaction().customOption(ConfigElement.getPath((ConfigElement)CQLConfigOptions.READ_CONSISTENCY, (String[])new String[0]), (Object)"ONE").customOption(ConfigElement.getPath((ConfigElement)CQLConfigOptions.WRITE_CONSISTENCY, (String[])new String[0]), (Object)"TWO").start();
        Assertions.assertEquals((Object)"ONE", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(CQLConfigOptions.READ_CONSISTENCY, new String[0]));
        Assertions.assertEquals((Object)"TWO", (Object)tx.getTxHandle().getBaseTransactionConfig().getCustomOptions().get(CQLConfigOptions.WRITE_CONSISTENCY, new String[0]));
        tx.rollback();
    }

    @Test
    public void testRequestLoggerConfigurationSet() {
        WriteConfiguration wc = this.getConfiguration();
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_TRACKER_CLASS, (String[])new String[0]), CQLConfigOptions.REQUEST_TRACKER_CLASS.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SUCCESS_ENABLED, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_SUCCESS_ENABLED.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SLOW_THRESHOLD, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_SLOW_THRESHOLD.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SLOW_ENABLED, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_SLOW_ENABLED.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_ERROR_ENABLED, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_ERROR_ENABLED.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_MAX_QUERY_LENGTH, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_MAX_QUERY_LENGTH.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SHOW_VALUES, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_SHOW_VALUES.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_MAX_VALUE_LENGTH, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_MAX_VALUE_LENGTH.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_MAX_VALUES, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_MAX_VALUES.getDatatype()));
        Assertions.assertNull((Object)wc.get(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SHOW_STACK_TRACES, (String[])new String[0]), CQLConfigOptions.REQUEST_LOGGER_SHOW_STACK_TRACES.getDatatype()));
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_TRACKER_CLASS, (String[])new String[0]), (Object)RequestLogger.class.getSimpleName());
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SUCCESS_ENABLED, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SLOW_THRESHOLD, (String[])new String[0]), (Object)1L);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SLOW_ENABLED, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_ERROR_ENABLED, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_MAX_QUERY_LENGTH, (String[])new String[0]), (Object)100000);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SHOW_VALUES, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_MAX_VALUE_LENGTH, (String[])new String[0]), (Object)100000);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_MAX_VALUES, (String[])new String[0]), (Object)100000);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_LOGGER_SHOW_STACK_TRACES, (String[])new String[0]), (Object)true);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertDoesNotThrow(() -> {
            this.graph.traversal().V(new Object[0]).hasNext();
            this.graph.tx().rollback();
        });
    }

    @Test
    public void shouldCreateCachedThreadPool() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.EXECUTOR_SERVICE_CLASS, (String[])new String[0]), (Object)"cached");
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.EXECUTOR_SERVICE_ENABLED, (String[])new String[0]), (Object)true);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertDoesNotThrow(() -> {
            this.graph.traversal().V(new Object[0]).hasNext();
            this.graph.tx().rollback();
        });
    }

    @Test
    public void shouldGracefullyCloseGraphWhichLostAConnection() {
        Set threadsFromPossibleOtherOpenedConnections;
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.EXECUTOR_SERVICE_ENABLED, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.EXECUTOR_SERVICE_MAX_SHUTDOWN_WAIT_TIME, (String[])new String[0]), (Object)60000);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_MAX_SHUTDOWN_WAIT_TIME, (String[])new String[0]), (Object)60000);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.IDS_RENEW_TIMEOUT, (String[])new String[0]), (Object)10000);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.CONNECTION_TIMEOUT, (String[])new String[0]), (Object)10000);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.HEARTBEAT_TIMEOUT, (String[])new String[0]), (Object)10000);
        if (this.graph != null && this.graph.isOpen()) {
            this.graph.close();
        }
        boolean flakyTest = !(threadsFromPossibleOtherOpenedConnections = Thread.getAllStackTraces().keySet().stream().filter(thread -> {
            String threadNameLowercase = thread.getName().toLowerCase();
            return thread.isAlive() && (threadNameLowercase.startsWith("cql") || threadNameLowercase.startsWith("janusgraph"));
        }).collect(Collectors.toSet())).isEmpty();
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertDoesNotThrow(() -> {
            this.graph.traversal().V(new Object[0]).hasNext();
            this.graph.tx().rollback();
        });
        Set threadsToAwait = Thread.getAllStackTraces().keySet().stream().filter(thread -> {
            String threadNameLowercase = thread.getName().toLowerCase();
            return thread.isAlive() && !threadsFromPossibleOtherOpenedConnections.contains(thread) && (threadNameLowercase.startsWith("cql") || threadNameLowercase.startsWith("janusgraph"));
        }).collect(Collectors.toSet());
        cqlContainer.stop();
        this.graph.close();
        for (Thread thread2 : threadsToAwait) {
            if (!thread2.isAlive()) continue;
            if (flakyTest) {
                log.warn("Test shouldGracefullyCloseGraphWhichLostAConnection is currently running in flaky mode because there were open instances available before the test started. Thus, we don't fail this test because we can't be sure that current thread {} is leaked or were created by other JanusGraph instances.", (Object)thread2.getName());
                continue;
            }
            Assertions.fail((String)("Thread " + thread2.getName() + " was alive but expected to be terminated"));
        }
    }

    @Test
    public void shouldCreateCQLSessionWithDisabledSessionLeakThreshold() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.SESSION_LEAK_THRESHOLD, (String[])new String[0]), (Object)0);
        Assertions.assertDoesNotThrow(() -> JanusGraphFactory.open((ReadConfiguration)wc).close());
    }

    @Test
    public void shouldBeAbleToSetupCustomRequestTimeout() {
        Assertions.assertDoesNotThrow(() -> {
            WriteConfiguration wc = this.getConfiguration();
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_TIMEOUT, (String[])new String[0]), (Object)12345);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.NETTY_TIMER_TICK_DURATION, (String[])new String[0]), (Object)1);
            StandardJanusGraph graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            GraphTraversalSource graphTraversalSource = graph.traversal();
            for (int i = 0; i < 200; ++i) {
                graphTraversalSource.addV().property((Object)"name", (Object)"world", new Object[0]).property((Object)"age", (Object)123, new Object[0]).property((Object)"id", (Object)i, new Object[0]);
            }
            graphTraversalSource.tx().commit();
            graphTraversalSource.V(new Object[0]).has("id", P.lte((Object)195)).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.ids).toList();
            graphTraversalSource.tx().rollback();
            graph.close();
        });
    }

    @Test
    public void defaultProgrammaticConfigurationShouldUseJanusGraphDefaultRequestTimeout() {
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.getConfiguration(), BasicConfiguration.Restriction.NONE);
        CQLProgrammaticConfigurationLoaderBuilder builder = new CQLProgrammaticConfigurationLoaderBuilder();
        DriverConfigLoader loader = builder.build((Configuration)config, Collections.emptyList(), Duration.of(1L, ChronoUnit.SECONDS));
        Duration requestTimeout = loader.getInitialConfig().getDefaultProfile().getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT);
        Assertions.assertEquals((Object)Duration.of((Long)CQLConfigOptions.REQUEST_TIMEOUT.getDefaultValue(), ChronoUnit.MILLIS), (Object)requestTimeout);
    }

    @Test
    public void shouldFailDueToSmallTimeout() {
        try {
            WriteConfiguration wc = this.getConfiguration();
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_TIMEOUT, (String[])new String[0]), (Object)1);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.NETTY_TIMER_TICK_DURATION, (String[])new String[0]), (Object)1);
            try (StandardJanusGraph graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);){
                GraphTraversalSource graphTraversalSource = graph.traversal();
                for (int i = 0; i < 200; ++i) {
                    graphTraversalSource.addV().property((Object)"name", (Object)"world", new Object[0]).property((Object)"age", (Object)123, new Object[0]).property((Object)"id", (Object)i, new Object[0]);
                }
                graphTraversalSource.tx().commit();
                graphTraversalSource.V(new Object[0]).has("id", P.lte((Object)195)).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.ids).toList();
                graphTraversalSource.tx().rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void shouldCreateCQLSessionWithStringConfigurationOnly() {
        WriteConfiguration wc = this.getConfiguration();
        String dataStaxConfiguration = CQLConfigTest.prepareDataStaxConfiguration(wc);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.STRING_CONFIGURATION, (String[])new String[0]), (Object)dataStaxConfiguration);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertDoesNotThrow(() -> {
            this.graph.traversal().V(new Object[0]).hasNext();
            this.graph.tx().rollback();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateCQLSessionWithFileConfigurationOnly() throws IOException {
        WriteConfiguration wc = this.getConfiguration();
        String dataStaxConfiguration = CQLConfigTest.prepareDataStaxConfiguration(wc);
        File tempFile = File.createTempFile("datastaxTempExample", ".conf");
        try {
            tempFile.deleteOnExit();
            FileUtils.writeStringToFile((File)tempFile, (String)dataStaxConfiguration, (Charset)Charset.defaultCharset(), (boolean)false);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)false);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.FILE_CONFIGURATION, (String[])new String[0]), (Object)tempFile.getAbsolutePath());
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.assertDoesNotThrow(() -> {
                this.graph.traversal().V(new Object[0]).hasNext();
                this.graph.tx().rollback();
            });
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void shouldTryToCreateCQLSessionWithResourceConfigurationOnlyButFailDueToMisconfigurationOfPort() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.RESOURCE_CONFIGURATION, (String[])new String[0]), (Object)"datastaxMisconfiguredResourceTestConfig.conf");
        Assertions.assertThrows(Throwable.class, () -> JanusGraphFactory.open((ReadConfiguration)wc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateCQLSessionWithUrlConfigurationOnly() throws IOException {
        WriteConfiguration wc = this.getConfiguration();
        String dataStaxConfiguration = CQLConfigTest.prepareDataStaxConfiguration(wc);
        File tempFile = File.createTempFile("datastaxTempExample", ".conf");
        try {
            tempFile.deleteOnExit();
            FileUtils.writeStringToFile((File)tempFile, (String)dataStaxConfiguration, (Charset)Charset.defaultCharset(), (boolean)false);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)false);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.URL_CONFIGURATION, (String[])new String[0]), (Object)new URL("file", "", tempFile.getAbsolutePath()).toString());
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.assertDoesNotThrow(() -> {
                this.graph.traversal().V(new Object[0]).hasNext();
                this.graph.tx().rollback();
            });
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void shouldComposeProgrammaticConfigurationWithStringConfigurationAndFailDueToUnnecessaryKeyspaceConfigAdded() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.STRING_CONFIGURATION, (String[])new String[0]), (Object)DATASTAX_JAVA_DRIVER_STRING_KEYSPACE_ONLY_CONFIGURATION_PATTERN);
        Assertions.assertThrows(IllegalArgumentException.class, () -> JanusGraphFactory.open((ReadConfiguration)wc));
    }

    @Test
    public void shouldCreateCQLSessionWithResourceAndStringConfigurations() {
        WriteConfiguration wc = this.getConfiguration();
        String dataStaxConfiguration = CQLConfigTest.prepareDataStaxContactPointsOnlyConfiguration(wc);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.RESOURCE_CONFIGURATION, (String[])new String[0]), (Object)"datastaxResourceTestConfigWithoutContactPoints.conf");
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.STRING_CONFIGURATION, (String[])new String[0]), (Object)dataStaxConfiguration);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertDoesNotThrow(() -> {
            this.graph.traversal().V(new Object[0]).hasNext();
            this.graph.tx().rollback();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateCQLSessionWithMultipleComposedConfigurations() throws IOException {
        WriteConfiguration wc = this.getConfiguration();
        String dataStaxConfiguration = CQLConfigTest.prepareDataStaxConfiguration(wc);
        File tempFile = File.createTempFile("datastaxTempExample", ".conf");
        try {
            tempFile.deleteOnExit();
            FileUtils.writeStringToFile((File)tempFile, (String)dataStaxConfiguration, (Charset)Charset.defaultCharset(), (boolean)false);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)true);
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.URL_CONFIGURATION, (String[])new String[0]), (Object)new URL("file", "", tempFile.getAbsolutePath()).toString());
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.FILE_CONFIGURATION, (String[])new String[0]), (Object)tempFile.getAbsolutePath());
            wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.STRING_CONFIGURATION, (String[])new String[0]), (Object)dataStaxConfiguration);
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.assertDoesNotThrow(() -> {
                this.graph.traversal().V(new Object[0]).hasNext();
                this.graph.tx().rollback();
            });
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void shouldTryToCreateCQLSessionWithDefaultDataStaxConfigurationOnlyButFailDueToTestcontainersUseNonDefaultPort() {
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.BASE_PROGRAMMATIC_CONFIGURATION_ENABLED, (String[])new String[0]), (Object)false);
        Assertions.assertThrows(RuntimeException.class, () -> JanusGraphFactory.open((ReadConfiguration)wc));
    }

    @Test
    public void fallbackConfigurationsShouldNotBeOverwrittenWithDefaultValues() throws PermanentBackendException {
        Duration expectedCqlRequestTimeout = Duration.ofMillis(1234L);
        WriteConfiguration writeConfiguration = this.getConfiguration();
        writeConfiguration.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.REQUEST_TIMEOUT, (String[])new String[0]), (Object)expectedCqlRequestTimeout.toMillis());
        writeConfiguration.set(ConfigElement.getPath((ConfigElement)CQLConfigOptions.STRING_CONFIGURATION, (String[])new String[0]), (Object)DATASTAX_JAVA_DRIVER_STRING_CONNECTION_TIMEOUT_ONLY_CONFIGURATION_PATTERN);
        String[] hostname = (String[])writeConfiguration.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_HOSTS, (String[])new String[0]), String[].class);
        Integer port = (Integer)writeConfiguration.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_PORT, (String[])new String[0]), Integer.class);
        Duration timeout = (Duration)writeConfiguration.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.CONNECTION_TIMEOUT, (String[])new String[0]), Duration.class);
        if (timeout == null) {
            timeout = (Duration)GraphDatabaseConfiguration.CONNECTION_TIMEOUT.getDefaultValue();
        }
        ModifiableConfiguration config = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, writeConfiguration, BasicConfiguration.Restriction.NONE);
        CQLProgrammaticConfigurationLoaderBuilder cqlProgrammaticConfigurationLoaderBuilder = new CQLProgrammaticConfigurationLoaderBuilder();
        CQLSessionBuilder builder = new CQLSessionBuilder();
        CqlSession cqlSession = builder.build((Configuration)config, hostname, port.intValue(), timeout, cqlProgrammaticConfigurationLoaderBuilder);
        DriverExecutionProfile defaultDriverExecutionProfile = cqlSession.getContext().getConfig().getDefaultProfile();
        Duration requestTimeout = defaultDriverExecutionProfile.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT);
        Assertions.assertEquals((Object)expectedCqlRequestTimeout, (Object)requestTimeout);
    }

    private static String prepareDataStaxConfiguration(WriteConfiguration wc) {
        String[] hostname = (String[])wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_HOSTS, (String[])new String[0]), String[].class);
        String port = ((Integer)wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_PORT, (String[])new String[0]), Integer.class)).toString();
        Duration timeout = (Duration)wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.CONNECTION_TIMEOUT, (String[])new String[0]), Duration.class);
        if (timeout == null) {
            timeout = (Duration)GraphDatabaseConfiguration.CONNECTION_TIMEOUT.getDefaultValue();
        }
        return DATASTAX_JAVA_DRIVER_STRING_CONFIGURATION_PATTERN.replace("${hostname}", hostname[0]).replace("${port}", port).replace("${datacenter}", (CharSequence)CQLConfigOptions.LOCAL_DATACENTER.getDefaultValue()).replace("${timeout}", String.valueOf(timeout.toMillis()));
    }

    private static String prepareDataStaxContactPointsOnlyConfiguration(WriteConfiguration wc) {
        String[] hostname = (String[])wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_HOSTS, (String[])new String[0]), String[].class);
        String port = ((Integer)wc.get(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_PORT, (String[])new String[0]), Integer.class)).toString();
        return DATASTAX_JAVA_DRIVER_STRING_CONTACT_POINTS_ONLY_CONFIGURATION_PATTERN.replace("${hostname}", hostname[0]).replace("${port}", port);
    }
}

