/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.cql;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.janusgraph.JanusGraphCassandraContainer;
import org.janusgraph.core.AbstractConfiguredGraphFactoryTest;
import org.janusgraph.core.ConfiguredGraphFactory;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class CQLConfiguredGraphFactoryTest
extends AbstractConfiguredGraphFactoryTest {
    @Container
    public static final JanusGraphCassandraContainer cqlContainer = new JanusGraphCassandraContainer();

    protected MapConfiguration getManagementConfig() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "cql");
        map.put(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot(), cqlContainer.getContainerIpAddress());
        map.put(GraphDatabaseConfiguration.STORAGE_PORT.toStringWithoutRoot(), cqlContainer.getMappedCQLPort());
        return ConfigurationUtil.loadMapConfiguration(map);
    }

    protected MapConfiguration getTemplateConfig() {
        return this.getManagementConfig();
    }

    protected MapConfiguration getGraphConfig() {
        Map map = this.getTemplateConfig().getMap();
        map.put(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot(), "cql_test_graph_name");
        return ConfigurationUtil.loadMapConfiguration((Map)map);
    }

    protected MapConfiguration getTemplateConfigWithMultiHosts() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "cql");
        String host = cqlContainer.getContainerIpAddress();
        map.put(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot(), host + "," + host);
        map.put(GraphDatabaseConfiguration.STORAGE_PORT.toStringWithoutRoot(), cqlContainer.getMappedCQLPort());
        return new MapConfiguration(map);
    }

    protected MapConfiguration getGraphConfigWithMultiHosts() {
        Map map = this.getTemplateConfigWithMultiHosts().getMap();
        map.put(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot(), "cql_test_graph_name");
        return new MapConfiguration(map);
    }

    @Test
    public void templateConfigurationShouldSupportMultiHosts() throws Exception {
        try {
            ConfiguredGraphFactory.createTemplateConfiguration((Configuration)this.getTemplateConfigWithMultiHosts());
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph1");
            Assertions.assertNotNull((Object)graph);
            graph.close();
            StandardJanusGraph graph1 = (StandardJanusGraph)ConfiguredGraphFactory.open((String)"graph1");
            Assertions.assertNotNull((Object)graph1);
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)"graph1");
            ConfiguredGraphFactory.close((String)"graph1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createConfigurationShouldSupportMultiHosts() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfigWithMultiHosts();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dropGraphShouldRemoveGraphKeyspace() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            ConfiguredGraphFactory.drop((String)graphName);
            Session cql = cqlContainer.getCluster().connect();
            Row graph_keyspace = cql.execute("SELECT * FROM system_schema.keyspaces WHERE keyspace_name = ?", new Object[]{graphName}).one();
            cql.close();
            Assertions.assertNull((Object)graph_keyspace);
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }
}

