/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.berkeleyje;

import java.util.Collections;
import org.janusgraph.BerkeleyStorageSetup;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.KeyColumnValueStoreTest;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManagerAdapter;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class BerkeleyVariableLengthKCVSTest
extends KeyColumnValueStoreTest {
    public KeyColumnValueStoreManager openStorageManager() throws BackendException {
        BerkeleyJEStoreManager sm = new BerkeleyJEStoreManager((Configuration)BerkeleyStorageSetup.getBerkeleyJEConfiguration());
        return new OrderedKeyValueStoreManagerAdapter((OrderedKeyValueStoreManager)sm);
    }

    @Test
    public void testConcurrentGetSlice() {
    }

    @Test
    public void testConcurrentGetSliceAndMutate() {
    }

    @Test
    public void retrieveBackendAndGetKeyValue() {
        KeyColumnValueStoreManager storemanager = this.manager;
        KeyColumnValueStore store = this.store;
        try {
            String keyOne = "hello";
            String colOne = "column";
            String valOne = "world";
            StoreTransaction txh = storemanager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO));
            StaticBuffer keyBuffOne = (StaticBuffer)StaticBuffer.STATIC_FACTORY.get(keyOne.getBytes(), 0, keyOne.getBytes().length);
            StaticBuffer columnBuffOne = (StaticBuffer)StaticBuffer.STATIC_FACTORY.get(colOne.getBytes(), 0, colOne.getBytes().length);
            StaticBuffer valBuffOne = (StaticBuffer)StaticBuffer.STATIC_FACTORY.get(valOne.getBytes(), 0, valOne.getBytes().length);
            Entry insertEntry = StaticArrayEntry.of((StaticBuffer)columnBuffOne, (StaticBuffer)valBuffOne);
            store.mutate(keyBuffOne, Collections.singletonList(insertEntry), Collections.emptyList(), txh);
            txh.commit();
            String keyTwo = "hel";
            String colTwo = "column";
            String valTwo = "wor";
            txh = storemanager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO));
            StaticBuffer keyBuffTwo = (StaticBuffer)StaticBuffer.STATIC_FACTORY.get(keyTwo.getBytes(), 0, keyTwo.getBytes().length);
            StaticBuffer columnBuffTwo = (StaticBuffer)StaticBuffer.STATIC_FACTORY.get(colTwo.getBytes(), 0, colTwo.getBytes().length);
            StaticBuffer valBuffTwo = (StaticBuffer)StaticBuffer.STATIC_FACTORY.get(valTwo.getBytes(), 0, valTwo.getBytes().length);
            Entry insertEntryTwo = StaticArrayEntry.of((StaticBuffer)columnBuffTwo, (StaticBuffer)valBuffTwo);
            store.mutate(keyBuffTwo, Collections.singletonList(insertEntryTwo), Collections.emptyList(), txh);
            txh.commit();
            StaticArrayBuffer startRange = new StaticArrayBuffer(new byte[]{0});
            StaticArrayBuffer endRange = new StaticArrayBuffer(new byte[]{-1});
            txh = storemanager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO));
            try {
                KeySliceQuery keyslice = new KeySliceQuery(keyBuffTwo, (StaticBuffer)startRange, (StaticBuffer)endRange);
                EntryList result = store.getSlice(keyslice, txh);
                txh.commit();
                Assert.assertEquals((long)1L, (long)result.size());
                Assert.assertEquals((Object)valTwo, (Object)new String((byte[])((Entry)result.get(0)).getValue().as(StaticBuffer.ARRAY_FACTORY)));
            }
            catch (BackendException e) {
                txh.rollback();
            }
            txh = storemanager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MICRO));
            try {
                store.mutate(keyBuffOne, Collections.emptyList(), Collections.singletonList(columnBuffOne), txh);
                store.mutate(keyBuffTwo, Collections.emptyList(), Collections.singletonList(columnBuffTwo), txh);
                txh.commit();
            }
            catch (BackendException e) {
                txh.rollback();
            }
        }
        catch (BackendException backendException) {
            // empty catch block
        }
    }
}

