/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class MgmtOlapJobBenchmark {
    @Param(value={"10000"})
    int size;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]);
        return config.getConfiguration();
    }

    @Setup(value=Level.Iteration)
    public void setUp() throws Exception {
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        mgmt.commit();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"nameIndex").call();
        for (int j = 0; j < this.size; ++j) {
            this.graph.addVertex(new Object[]{"name", "value" + j, "alias", "value" + j});
        }
        this.graph.tx().commit();
        mgmt = this.graph.openManagement();
        mgmt.buildIndex("aliasIndex", Vertex.class).addKey(mgmt.getPropertyKey("alias")).buildCompositeIndex();
        mgmt.commit();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"aliasIndex").call();
        mgmt = this.graph.openManagement();
        mgmt.updateIndex((Index)mgmt.getGraphIndex("nameIndex"), SchemaAction.DISABLE_INDEX).get();
        mgmt.commit();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"nameIndex").call();
    }

    @Benchmark
    public void runReindex(Blackhole blackhole) throws ExecutionException, InterruptedException {
        JanusGraphManagement mgmt = this.graph.openManagement();
        blackhole.consume(mgmt.updateIndex((Index)mgmt.getGraphIndex("aliasIndex"), SchemaAction.REINDEX).get());
        mgmt.commit();
    }

    @Benchmark
    public void runRemoveIndex(Blackhole blackhole) throws ExecutionException, InterruptedException {
        JanusGraphManagement mgmt = this.graph.openManagement();
        blackhole.consume(mgmt.updateIndex((Index)mgmt.getGraphIndex("nameIndex"), SchemaAction.REMOVE_INDEX).get());
        mgmt.commit();
    }

    @TearDown(value=Level.Iteration)
    public void tearDown() {
        this.graph.close();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(MgmtOlapJobBenchmark.class.getSimpleName()).warmupIterations(1).measurementIterations(3).build();
        new Runner(options).run();
    }
}

