/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.example;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.process.traversal.AnonymousTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.Bindings;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.example.JanusGraphApp;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteGraphApp
extends JanusGraphApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteGraphApp.class);
    private static final String NAME = "name";
    private static final String AGE = "age";
    private static final String TIME = "time";
    private static final String REASON = "reason";
    private static final String PLACE = "place";
    private static final String LABEL = "label";
    private static final String OUT_V = "outV";
    private static final String IN_V = "inV";
    protected JanusGraph janusgraph;
    protected Cluster cluster;
    protected Client client;
    protected Configuration conf;

    public RemoteGraphApp(String fileName) {
        super(fileName);
        this.supportsTransactions = false;
    }

    public GraphTraversalSource openGraph() throws ConfigurationException, IOException {
        LOGGER.info("opening graph");
        this.conf = ConfigurationUtil.loadPropertiesConfig((String)this.propFileName);
        try {
            this.cluster = Cluster.open((String)this.conf.getString("gremlin.remote.driver.clusterFile"));
            this.client = this.cluster.connect();
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        return (GraphTraversalSource)AnonymousTraversalSource.traversal().withRemote(this.conf);
    }

    public void createElements() {
        LOGGER.info("creating elements");
        Bindings b = Bindings.instance();
        Vertex saturn = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"titan")).property((Object)NAME, b.of(NAME, (Object)"saturn"), new Object[0]).property((Object)AGE, b.of(AGE, (Object)10000), new Object[0]).next();
        Vertex sky = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"location")).property((Object)NAME, b.of(NAME, (Object)"sky"), new Object[0]).next();
        Vertex sea = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"location")).property((Object)NAME, b.of(NAME, (Object)"sea"), new Object[0]).next();
        Vertex jupiter = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"god")).property((Object)NAME, b.of(NAME, (Object)"jupiter"), new Object[0]).property((Object)AGE, b.of(AGE, (Object)5000), new Object[0]).next();
        Vertex neptune = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"god")).property((Object)NAME, b.of(NAME, (Object)"neptune"), new Object[0]).property((Object)AGE, b.of(AGE, (Object)4500), new Object[0]).next();
        Vertex hercules = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"demigod")).property((Object)NAME, b.of(NAME, (Object)"hercules"), new Object[0]).property((Object)AGE, b.of(AGE, (Object)30), new Object[0]).next();
        Vertex alcmene = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"human")).property((Object)NAME, b.of(NAME, (Object)"alcmene"), new Object[0]).property((Object)AGE, b.of(AGE, (Object)45), new Object[0]).next();
        Vertex pluto = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"god")).property((Object)NAME, b.of(NAME, (Object)"pluto"), new Object[0]).property((Object)AGE, b.of(AGE, (Object)4000), new Object[0]).next();
        Vertex nemean = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"monster")).property((Object)NAME, b.of(NAME, (Object)"nemean"), new Object[0]).next();
        Vertex hydra = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"monster")).property((Object)NAME, b.of(NAME, (Object)"hydra"), new Object[0]).next();
        Vertex cerberus = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"monster")).property((Object)NAME, b.of(NAME, (Object)"cerberus"), new Object[0]).next();
        Vertex tartarus = (Vertex)this.g.addV((String)b.of(LABEL, (Object)"location")).property((Object)NAME, b.of(NAME, (Object)"tartarus"), new Object[0]).next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)jupiter)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)saturn)}).addE((String)b.of(LABEL, (Object)"father")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)jupiter)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)sky)}).addE((String)b.of(LABEL, (Object)"lives")).property((Object)REASON, b.of(REASON, (Object)"loves fresh breezes"), new Object[0]).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)jupiter)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)neptune)}).addE((String)b.of(LABEL, (Object)"brother")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)jupiter)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)pluto)}).addE((String)b.of(LABEL, (Object)"brother")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)neptune)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)sea)}).addE((String)b.of(LABEL, (Object)"lives")).property((Object)REASON, b.of(REASON, (Object)"loves waves"), new Object[0]).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)neptune)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)jupiter)}).addE((String)b.of(LABEL, (Object)"brother")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)neptune)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)pluto)}).addE((String)b.of(LABEL, (Object)"brother")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)jupiter)}).addE((String)b.of(LABEL, (Object)"father")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)alcmene)}).addE((String)b.of(LABEL, (Object)"mother")).from("a").next();
        if (this.supportsGeoshape) {
            this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)nemean)}).addE((String)b.of(LABEL, (Object)"battled")).property((Object)TIME, b.of(TIME, (Object)1), new Object[0]).property((Object)PLACE, b.of(PLACE, (Object)Geoshape.point((double)38.1f, (double)23.7f)), new Object[0]).from("a").next();
            this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)hydra)}).addE((String)b.of(LABEL, (Object)"battled")).property((Object)TIME, b.of(TIME, (Object)2), new Object[0]).property((Object)PLACE, b.of(PLACE, (Object)Geoshape.point((double)37.7f, (double)23.9f)), new Object[0]).from("a").next();
            this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)cerberus)}).addE((String)b.of(LABEL, (Object)"battled")).property((Object)TIME, b.of(TIME, (Object)12), new Object[0]).property((Object)PLACE, b.of(PLACE, (Object)Geoshape.point((double)39.0, (double)22.0)), new Object[0]).from("a").next();
        } else {
            this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)nemean)}).addE((String)b.of(LABEL, (Object)"battled")).property((Object)TIME, b.of(TIME, (Object)1), new Object[0]).property((Object)PLACE, b.of(PLACE, (Object)this.getGeoFloatArray(38.1f, 23.7f)), new Object[0]).from("a").next();
            this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)hydra)}).addE((String)b.of(LABEL, (Object)"battled")).property((Object)TIME, b.of(TIME, (Object)2), new Object[0]).property((Object)PLACE, b.of(PLACE, (Object)this.getGeoFloatArray(37.7f, 23.9f)), new Object[0]).from("a").next();
            this.g.V(new Object[]{b.of(OUT_V, (Object)hercules)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)cerberus)}).addE((String)b.of(LABEL, (Object)"battled")).property((Object)TIME, b.of(TIME, (Object)12), new Object[0]).property((Object)PLACE, b.of(PLACE, (Object)this.getGeoFloatArray(39.0f, 22.0f)), new Object[0]).from("a").next();
        }
        this.g.V(new Object[]{b.of(OUT_V, (Object)pluto)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)jupiter)}).addE((String)b.of(LABEL, (Object)"brother")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)pluto)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)neptune)}).addE((String)b.of(LABEL, (Object)"brother")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)pluto)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)tartarus)}).addE((String)b.of(LABEL, (Object)"lives")).property((Object)REASON, b.of(REASON, (Object)"no fear of death"), new Object[0]).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)pluto)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)cerberus)}).addE((String)b.of(LABEL, (Object)"pet")).from("a").next();
        this.g.V(new Object[]{b.of(OUT_V, (Object)cerberus)}).as("a", new String[0]).V(new Object[]{b.of(IN_V, (Object)tartarus)}).addE((String)b.of(LABEL, (Object)"lives")).from("a").next();
    }

    public void closeGraph() throws Exception {
        LOGGER.info("closing graph");
        try {
            if (this.g != null) {
                this.g.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        finally {
            this.g = null;
            this.graph = null;
            this.client = null;
            this.cluster = null;
        }
    }

    public void createSchema() {
        LOGGER.info("creating schema");
        String req = this.createSchemaRequest();
        ResultSet resultSet = this.client.submit(req);
        Stream futureList = resultSet.stream();
        futureList.map(Result::toString).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    public static void main(String[] args) {
        String fileName = args != null && args.length > 0 ? args[0] : null;
        RemoteGraphApp app = new RemoteGraphApp(fileName);
        app.runApp();
    }
}

