/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BiMultiValMap<K, V>
implements Map<K, V> {
    protected final Map<K, V> forwardMap = new HashMap();
    protected final Multimap<V, K> reverseMap = HashMultimap.create();

    public Multimap<V, K> inverse() {
        return Multimaps.unmodifiableMultimap(this.reverseMap);
    }

    @Override
    public void clear() {
        this.forwardMap.clear();
        this.reverseMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.reverseMap.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forwardMap.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.forwardMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.forwardMap.keySet();
    }

    @Override
    public V put(K key, V value) {
        V oldVal = this.forwardMap.put(key, value);
        if (oldVal != null) {
            this.reverseMap.remove(oldVal, key);
        }
        this.reverseMap.put(value, key);
        return oldVal;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V oldVal = this.forwardMap.remove(key);
        this.reverseMap.remove(oldVal, key);
        return oldVal;
    }

    @Override
    public int size() {
        return this.forwardMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.reverseMap.keys();
    }
}

