/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser.tree;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.importer.xmlparser.event.Attribute;
import org.itsallcode.openfasttrace.importer.xmlparser.event.StartElementEvent;

public class TreeElement {
    private final StartElementEvent element;
    private final StringBuilder characterData = new StringBuilder();
    private final List<Consumer<TreeElement>> endElementListeners = new LinkedList<Consumer<TreeElement>>();
    private final TreeElement parent;

    TreeElement(StartElementEvent element, TreeElement parent) {
        this.element = element;
        this.parent = parent;
    }

    public StartElementEvent getElement() {
        return this.element;
    }

    public String getCharacterData() {
        return this.characterData.toString();
    }

    public boolean isRootElement() {
        return this.parent == null;
    }

    void addCharacterData(String characters) {
        this.characterData.append(characters);
    }

    void addEndElementListener(Consumer<TreeElement> newEndElementListener) {
        this.endElementListeners.add(newEndElementListener);
    }

    public Attribute getAttributeValueByName(String name) {
        return this.element.getAttributeValueByName(name);
    }

    public Location getLocation() {
        return this.element.getLocation();
    }

    public void invokeEndElementListeners() {
        this.endElementListeners.forEach(listener -> listener.accept(this));
    }

    public String toString() {
        return "TreeElement [element=" + this.element + ", characterData=" + this.characterData + ", endElementListeners=" + this.endElementListeners + ", parent=" + this.parent + "]";
    }
}

