/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.itsallcode.openfasttrace.importer.xmlparser.XmlParserException;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeElement;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeParsingController;

public class CallbackContentHandler
implements TreeContentHandler {
    private static final Logger LOG = Logger.getLogger(CallbackContentHandler.class.getName());
    private static final String OPENFASTTRACE_XML_NAMESPACE = "https://github.com/itsallcode/openfasttrace";
    private final Map<String, Consumer<TreeElement>> startElementListeners = new HashMap<String, Consumer<TreeElement>>();
    private Consumer<TreeElement> defaultStartElementListener;
    private TreeParsingController treeParsingController;

    public void setDefaultStartElementListener(Consumer<TreeElement> defaultListener) {
        this.defaultStartElementListener = defaultListener;
    }

    public CallbackContentHandler addSubTreeHandler(String elementName, Supplier<TreeContentHandler> supplier) {
        this.addElementListener(elementName, element -> this.pushDelegate((TreeContentHandler)supplier.get()));
        return this;
    }

    public CallbackContentHandler addElementListener(String elementName, Consumer<TreeElement> listener) {
        this.addElementListener(elementName, listener, null);
        return this;
    }

    public CallbackContentHandler addElementListener(String elementName, Consumer<TreeElement> startListener, Consumer<TreeElement> endListener) {
        if (this.startElementListeners.containsKey(elementName)) {
            throw new IllegalArgumentException("Listener already registered for start element '" + elementName + "'");
        }
        this.startElementListeners.put(elementName, startElement -> {
            if (endListener != null) {
                startElement.addEndElementListener(endListener);
            }
            if (startListener != null) {
                startListener.accept((TreeElement)startElement);
            }
        });
        return this;
    }

    @Override
    public void init(TreeParsingController treeParsingController) {
        this.treeParsingController = treeParsingController;
    }

    @Override
    public void startElement(TreeElement treeElement) {
        LOG.finest(() -> "Start element: " + treeElement);
        String namespaceURI = treeElement.getElement().getName().getNamespaceURI();
        if (this.isCustomXMLNamespace(namespaceURI)) {
            LOG.finest(() -> "custom XML element with namespace " + namespaceURI);
            return;
        }
        Consumer<TreeElement> consumer = this.startElementListeners.getOrDefault(treeElement.getElement().getName().getLocalPart(), this.defaultStartElementListener);
        if (consumer == null) {
            LOG.warning(() -> "No consumer for event " + treeElement);
            return;
        }
        try {
            consumer.accept(treeElement);
        }
        catch (Exception e) {
            throw new XmlParserException("Error handling " + treeElement + " with consumer " + consumer + ": " + e.getMessage(), e);
        }
    }

    private boolean isCustomXMLNamespace(String namespaceURI) {
        return !"".equals(namespaceURI) && !OPENFASTTRACE_XML_NAMESPACE.equals(namespaceURI);
    }

    @Override
    public void endElement(TreeElement closedElement) {
        closedElement.invokeEndElementListeners();
    }

    public void stopParsing() {
        this.treeParsingController.stopParsing();
    }

    public void pushDelegate(TreeContentHandler delegate) {
        this.treeParsingController.setDelegate(delegate);
        this.treeParsingController.getCurrentElement().addEndElementListener(endElement -> this.treeParsingController.setDelegate(this));
    }

    public CallbackContentHandler addIntDataListener(String elementName, IntConsumer listener) {
        this.addCharacterDataListener(elementName, data -> {
            if (data == null || data.isEmpty()) {
                throw new XmlParserException("No string data found for element '" + elementName + "'");
            }
            listener.accept(this.parseInt(elementName, (String)data));
        });
        return this;
    }

    private int parseInt(String elementName, String data) {
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException exception) {
            throw new XmlParserException("Failed parsing content '" + data + "' of element '" + elementName + "'", exception);
        }
    }

    public CallbackContentHandler addCharacterDataListener(String elementName, Consumer<String> listener) {
        this.addElementListener(elementName, startElement -> {}, endElement -> listener.accept(endElement.getCharacterData()));
        return this;
    }
}

