/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser.event;

import java.util.Map;
import javax.xml.namespace.QName;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.importer.xmlparser.event.Attribute;
import org.itsallcode.openfasttrace.importer.xmlparser.event.QNameFactory;
import org.xml.sax.Attributes;

public class StartElementEvent {
    private final QName qName;
    private final Location location;
    private final Map<String, Attribute> attributeMap;

    private StartElementEvent(QName qName, Map<String, Attribute> attributeMap, Location location) {
        this.attributeMap = attributeMap;
        this.location = location;
        this.qName = qName;
    }

    public static StartElementEvent create(String uri, String localName, String qName, Attributes attributes, Location location) {
        Map<String, Attribute> attributeMap = Attribute.buildMap(attributes);
        QName qualifiedName = QNameFactory.create(uri, localName, qName);
        return new StartElementEvent(qualifiedName, attributeMap, location);
    }

    public QName getName() {
        return this.qName;
    }

    public Location getLocation() {
        return this.location;
    }

    public Attribute getAttributeValueByName(String name) {
        return this.attributeMap.get(name);
    }

    public String toString() {
        return "StartElementEvent [qName=" + this.qName + ", attributeMap=" + this.attributeMap + ", location=" + this.location + "]";
    }
}

