/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.itsallcode.openfasttrace.importer.xmlparser.ContentHandlerAdapter;
import org.itsallcode.openfasttrace.importer.xmlparser.IgnoringEntityResolver;
import org.itsallcode.openfasttrace.importer.xmlparser.XmlParserException;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeBuildingContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.tree.TreeContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlParser {
    private final SAXParserFactory saxParserFactory;

    XmlParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public void parse(String filePath, Reader reader, TreeContentHandler eventHandler) {
        XMLReader xmlReader = this.createXmlReader();
        xmlReader.setEntityResolver(new IgnoringEntityResolver());
        new ContentHandlerAdapter(filePath, xmlReader, new TreeBuildingContentHandler(eventHandler)).registerListener();
        InputSource input = new InputSource(reader);
        try {
            xmlReader.parse(input);
        }
        catch (IOException | SAXException exception) {
            throw new XmlParserException("Failed to parse file '" + filePath + "': " + exception.getMessage(), exception);
        }
    }

    private XMLReader createXmlReader() {
        try {
            return this.saxParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new XmlParserException("Failed to create XML reader: " + exception.getMessage(), exception);
        }
    }
}

