/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.xmlparser;

import java.util.Objects;
import java.util.logging.Logger;
import org.itsallcode.openfasttrace.api.core.Location;
import org.itsallcode.openfasttrace.importer.xmlparser.ContentHandlerAdapterController;
import org.itsallcode.openfasttrace.importer.xmlparser.EventContentHandler;
import org.itsallcode.openfasttrace.importer.xmlparser.event.EndElementEvent;
import org.itsallcode.openfasttrace.importer.xmlparser.event.StartElementEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ContentHandlerAdapter
extends DefaultHandler
implements ContentHandlerAdapterController {
    private static final Logger LOG = Logger.getLogger(ContentHandlerAdapter.class.getName());
    private final String filePath;
    private final XMLReader xmlReader;
    private final EventContentHandler delegate;
    private Locator locator;

    ContentHandlerAdapter(String filePath, XMLReader xmlReader, EventContentHandler delegate) {
        this.filePath = Objects.requireNonNull(filePath, "filePath");
        this.xmlReader = Objects.requireNonNull(xmlReader, "xmlReader");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    void registerListener() {
        this.verifyNoContentHandlerRegistered();
        this.delegate.init(this);
        this.xmlReader.setContentHandler(this);
    }

    private void verifyNoContentHandlerRegistered() {
        ContentHandler originalContentHandler = this.xmlReader.getContentHandler();
        if (originalContentHandler != null) {
            throw new IllegalStateException("An XML content handler is already registered: " + originalContentHandler);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = Objects.requireNonNull(locator, "locator");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        LOG.finest(() -> "Start element: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
        StartElementEvent event = StartElementEvent.create(uri, localName, qName, attributes, this.getCurrentLocation());
        this.delegate.startElement(event);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        LOG.finest(() -> "End element: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
        EndElementEvent event = EndElementEvent.create(uri, localName, qName, this.getCurrentLocation());
        this.delegate.endElement(event);
    }

    private Location getCurrentLocation() {
        if (this.locator == null) {
            throw new IllegalStateException("Document locator was not defined");
        }
        return Location.create((String)this.filePath, (int)this.locator.getLineNumber(), (int)this.locator.getColumnNumber());
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.delegate.characters(new String(ch, start, length));
    }

    @Override
    public void parsingFinished() {
        this.xmlReader.setContentHandler(null);
    }
}

