/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.markdown;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Logger;
import org.itsallcode.openfasttrace.api.core.ItemStatus;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;
import org.itsallcode.openfasttrace.api.importer.ImportEventListener;
import org.itsallcode.openfasttrace.api.importer.Importer;
import org.itsallcode.openfasttrace.api.importer.ImporterException;
import org.itsallcode.openfasttrace.api.importer.input.InputFile;
import org.itsallcode.openfasttrace.importer.markdown.MarkdownForwardingSpecificationItem;
import org.itsallcode.openfasttrace.importer.markdown.MarkdownImporterStateMachine;
import org.itsallcode.openfasttrace.importer.markdown.MdPattern;
import org.itsallcode.openfasttrace.importer.markdown.State;
import org.itsallcode.openfasttrace.importer.markdown.Transition;
import org.itsallcode.openfasttrace.importer.markdown.TransitionAction;

class MarkdownImporter
implements Importer {
    private static final Logger LOG = Logger.getLogger(MarkdownImporter.class.getName());
    private final Transition[] transitions = new Transition[]{MarkdownImporter.transition(State.START, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.START, State.TITLE, MdPattern.TITLE, this::rememberTitle), MarkdownImporter.transition(State.START, State.OUTSIDE, MdPattern.FORWARD, this::forward), MarkdownImporter.transition(State.START, State.OUTSIDE, MdPattern.EVERYTHING, () -> {}), MarkdownImporter.transition(State.TITLE, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.TITLE, State.TITLE, MdPattern.TITLE, this::rememberTitle), MarkdownImporter.transition(State.TITLE, State.TITLE, MdPattern.EMPTY, () -> {}), MarkdownImporter.transition(State.TITLE, State.OUTSIDE, MdPattern.EVERYTHING, this::resetTitle), MarkdownImporter.transition(State.OUTSIDE, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.OUTSIDE, State.OUTSIDE, MdPattern.FORWARD, this::forward), MarkdownImporter.transition(State.OUTSIDE, State.TITLE, MdPattern.TITLE, this::rememberTitle), MarkdownImporter.transition(State.SPEC_ITEM, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.SPEC_ITEM, State.SPEC_ITEM, MdPattern.STATUS, this::setStatus), MarkdownImporter.transition(State.SPEC_ITEM, State.TITLE, MdPattern.TITLE, () -> {
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.SPEC_ITEM, State.RATIONALE, MdPattern.RATIONALE, this::beginRationale), MarkdownImporter.transition(State.SPEC_ITEM, State.COMMENT, MdPattern.COMMENT, this::beginComment), MarkdownImporter.transition(State.SPEC_ITEM, State.COVERS, MdPattern.COVERS, () -> {}), MarkdownImporter.transition(State.SPEC_ITEM, State.DEPENDS, MdPattern.DEPENDS, () -> {}), MarkdownImporter.transition(State.SPEC_ITEM, State.NEEDS, MdPattern.NEEDS_INT, this::addNeeds), MarkdownImporter.transition(State.SPEC_ITEM, State.NEEDS, MdPattern.NEEDS, () -> {}), MarkdownImporter.transition(State.SPEC_ITEM, State.DESCRIPTION, MdPattern.DESCRIPTION, this::beginDescription), MarkdownImporter.transition(State.SPEC_ITEM, State.DESCRIPTION, MdPattern.NOT_EMPTY, this::beginDescription), MarkdownImporter.transition(State.SPEC_ITEM, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.SPEC_ITEM, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.DESCRIPTION, State.SPEC_ITEM, MdPattern.ID, () -> {
        this.endDescription();
        this.beginItem();
    }), MarkdownImporter.transition(State.DESCRIPTION, State.TITLE, MdPattern.TITLE, () -> {
        this.endDescription();
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.DESCRIPTION, State.RATIONALE, MdPattern.RATIONALE, () -> {
        this.endDescription();
        this.beginRationale();
    }), MarkdownImporter.transition(State.DESCRIPTION, State.COMMENT, MdPattern.COMMENT, () -> {
        this.endDescription();
        this.beginComment();
    }), MarkdownImporter.transition(State.DESCRIPTION, State.COVERS, MdPattern.COVERS, this::endDescription), MarkdownImporter.transition(State.DESCRIPTION, State.DEPENDS, MdPattern.DEPENDS, this::endDescription), MarkdownImporter.transition(State.DESCRIPTION, State.NEEDS, MdPattern.NEEDS_INT, () -> {
        this.endDescription();
        this.addNeeds();
    }), MarkdownImporter.transition(State.DESCRIPTION, State.NEEDS, MdPattern.NEEDS, this::endDescription), MarkdownImporter.transition(State.DESCRIPTION, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.DESCRIPTION, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.DESCRIPTION, State.DESCRIPTION, MdPattern.EVERYTHING, this::appendDescription), MarkdownImporter.transition(State.RATIONALE, State.SPEC_ITEM, MdPattern.ID, () -> {
        this.endRationale();
        this.beginItem();
    }), MarkdownImporter.transition(State.RATIONALE, State.TITLE, MdPattern.TITLE, () -> {
        this.endRationale();
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.RATIONALE, State.COMMENT, MdPattern.COMMENT, () -> {
        this.endRationale();
        this.beginComment();
    }), MarkdownImporter.transition(State.RATIONALE, State.COVERS, MdPattern.COVERS, this::endRationale), MarkdownImporter.transition(State.RATIONALE, State.DEPENDS, MdPattern.DEPENDS, this::endRationale), MarkdownImporter.transition(State.RATIONALE, State.NEEDS, MdPattern.NEEDS_INT, () -> {
        this.endRationale();
        this.addNeeds();
    }), MarkdownImporter.transition(State.RATIONALE, State.NEEDS, MdPattern.NEEDS, this::endRationale), MarkdownImporter.transition(State.RATIONALE, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.RATIONALE, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.RATIONALE, State.RATIONALE, MdPattern.EVERYTHING, this::appendRationale), MarkdownImporter.transition(State.COMMENT, State.SPEC_ITEM, MdPattern.ID, () -> {
        this.endComment();
        this.beginItem();
    }), MarkdownImporter.transition(State.COMMENT, State.TITLE, MdPattern.TITLE, () -> {
        this.endComment();
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.COMMENT, State.COVERS, MdPattern.COVERS, this::endComment), MarkdownImporter.transition(State.COMMENT, State.DEPENDS, MdPattern.DEPENDS, this::endComment), MarkdownImporter.transition(State.COMMENT, State.NEEDS, MdPattern.NEEDS_INT, () -> {
        this.endComment();
        this.addNeeds();
    }), MarkdownImporter.transition(State.COMMENT, State.NEEDS, MdPattern.NEEDS, this::endComment), MarkdownImporter.transition(State.COMMENT, State.RATIONALE, MdPattern.RATIONALE, () -> {
        this.endComment();
        this.beginRationale();
    }), MarkdownImporter.transition(State.COMMENT, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.COMMENT, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.COMMENT, State.COMMENT, MdPattern.EVERYTHING, this::appendComment), MarkdownImporter.transition(State.COVERS, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.COVERS, State.TITLE, MdPattern.TITLE, () -> {
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.COVERS, State.COVERS, MdPattern.COVERS_REF, this::addCoverage), MarkdownImporter.transition(State.COVERS, State.RATIONALE, MdPattern.RATIONALE, this::beginRationale), MarkdownImporter.transition(State.COVERS, State.COMMENT, MdPattern.COMMENT, this::beginComment), MarkdownImporter.transition(State.COVERS, State.DEPENDS, MdPattern.DEPENDS, () -> {}), MarkdownImporter.transition(State.COVERS, State.NEEDS, MdPattern.NEEDS_INT, this::addNeeds), MarkdownImporter.transition(State.COVERS, State.NEEDS, MdPattern.NEEDS, () -> {}), MarkdownImporter.transition(State.COVERS, State.COVERS, MdPattern.EMPTY, () -> {}), MarkdownImporter.transition(State.COVERS, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.COVERS, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.DEPENDS, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.DEPENDS, State.TITLE, MdPattern.TITLE, () -> {
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.DEPENDS, State.DEPENDS, MdPattern.DEPENDS_REF, this::addDependency), MarkdownImporter.transition(State.DEPENDS, State.RATIONALE, MdPattern.RATIONALE, this::beginRationale), MarkdownImporter.transition(State.DEPENDS, State.COMMENT, MdPattern.COMMENT, this::beginComment), MarkdownImporter.transition(State.DEPENDS, State.DEPENDS, MdPattern.DEPENDS, () -> {}), MarkdownImporter.transition(State.DEPENDS, State.NEEDS, MdPattern.NEEDS_INT, this::addNeeds), MarkdownImporter.transition(State.DEPENDS, State.NEEDS, MdPattern.NEEDS, () -> {}), MarkdownImporter.transition(State.DEPENDS, State.DEPENDS, MdPattern.EMPTY, () -> {}), MarkdownImporter.transition(State.DEPENDS, State.COVERS, MdPattern.COVERS, () -> {}), MarkdownImporter.transition(State.DEPENDS, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.DEPENDS, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.NEEDS, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.NEEDS, State.TITLE, MdPattern.TITLE, () -> {
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.NEEDS, State.RATIONALE, MdPattern.RATIONALE, this::beginRationale), MarkdownImporter.transition(State.NEEDS, State.COMMENT, MdPattern.COMMENT, this::beginComment), MarkdownImporter.transition(State.NEEDS, State.DEPENDS, MdPattern.DEPENDS, () -> {}), MarkdownImporter.transition(State.NEEDS, State.NEEDS, MdPattern.NEEDS_INT, this::addNeeds), MarkdownImporter.transition(State.NEEDS, State.NEEDS, MdPattern.NEEDS_REF, this::addNeeds), MarkdownImporter.transition(State.NEEDS, State.NEEDS, MdPattern.EMPTY, () -> {}), MarkdownImporter.transition(State.NEEDS, State.COVERS, MdPattern.COVERS, () -> {}), MarkdownImporter.transition(State.NEEDS, State.TAGS, MdPattern.TAGS_INT, this::addTag), MarkdownImporter.transition(State.NEEDS, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.TAGS, State.TAGS, MdPattern.TAG_ENTRY, this::addTag), MarkdownImporter.transition(State.TAGS, State.SPEC_ITEM, MdPattern.ID, this::beginItem), MarkdownImporter.transition(State.TAGS, State.TITLE, MdPattern.TITLE, () -> {
        this.endItem();
        this.rememberTitle();
    }), MarkdownImporter.transition(State.TAGS, State.RATIONALE, MdPattern.RATIONALE, this::beginRationale), MarkdownImporter.transition(State.TAGS, State.COMMENT, MdPattern.COMMENT, this::beginComment), MarkdownImporter.transition(State.TAGS, State.DEPENDS, MdPattern.DEPENDS, () -> {}), MarkdownImporter.transition(State.TAGS, State.NEEDS, MdPattern.NEEDS_INT, this::addNeeds), MarkdownImporter.transition(State.TAGS, State.NEEDS, MdPattern.NEEDS, () -> {}), MarkdownImporter.transition(State.TAGS, State.NEEDS, MdPattern.EMPTY, () -> {}), MarkdownImporter.transition(State.TAGS, State.COVERS, MdPattern.COVERS, () -> {}), MarkdownImporter.transition(State.TAGS, State.TAGS, MdPattern.TAGS, () -> {}), MarkdownImporter.transition(State.TAGS, State.TAGS, MdPattern.TAGS_INT, this::addTag)};
    private final InputFile file;
    private final ImportEventListener listener;
    private final MarkdownImporterStateMachine stateMachine;
    private String lastTitle = null;
    private boolean inSpecificationItem;
    private StringBuilder lastDescription;
    private StringBuilder lastRationale;
    private StringBuilder lastComment;
    private int lineNumber = 0;

    MarkdownImporter(InputFile fileName, ImportEventListener listener) {
        this.file = fileName;
        this.listener = listener;
        this.stateMachine = new MarkdownImporterStateMachine(this.transitions);
    }

    public void runImport() {
        LOG.fine(() -> "Starting import of file " + this.file);
        this.lineNumber = 0;
        try (BufferedReader reader = this.file.createReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                ++this.lineNumber;
                this.stateMachine.step(line);
            }
        }
        catch (IOException exception) {
            throw new ImporterException("Error reading \"" + this.file.getPath() + "\" at line " + this.lineNumber, (Throwable)exception);
        }
        this.finishImport();
    }

    private void finishImport() {
        if (this.inSpecificationItem) {
            this.listener.endSpecificationItem();
        }
    }

    private static final Transition transition(State from, State to, MdPattern pattern, TransitionAction action) {
        return new Transition(from, to, pattern, action);
    }

    private void beginItem() {
        this.cleanUpLastItem();
        this.inSpecificationItem = true;
        this.informListenerAboutNewItem();
    }

    private void cleanUpLastItem() {
        if (this.inSpecificationItem) {
            this.endItem();
        }
    }

    private void informListenerAboutNewItem() {
        String idText = this.stateMachine.getLastToken();
        SpecificationItemId id = new SpecificationItemId.Builder(idText).build();
        this.listener.beginSpecificationItem();
        this.listener.setId(id);
        this.listener.setLocation(this.file.getPath(), this.lineNumber);
        if (this.lastTitle != null) {
            this.listener.setTitle(this.lastTitle);
        }
    }

    private void endItem() {
        this.inSpecificationItem = false;
        this.resetTitle();
        this.listener.endSpecificationItem();
    }

    private void setStatus() {
        this.listener.setStatus(ItemStatus.parseString((String)this.stateMachine.getLastToken()));
    }

    private void beginDescription() {
        this.lastDescription = new StringBuilder(this.stateMachine.getLastToken());
    }

    private void appendDescription() {
        this.lastDescription.append(System.lineSeparator()).append(this.stateMachine.getLastToken());
    }

    private void endDescription() {
        this.listener.appendDescription(this.lastDescription.toString().trim());
        this.lastDescription = null;
    }

    private void beginRationale() {
        this.lastRationale = new StringBuilder();
    }

    private void appendRationale() {
        if (this.lastRationale.length() > 0) {
            this.lastRationale.append(System.lineSeparator());
        }
        this.lastRationale.append(this.stateMachine.getLastToken());
    }

    private void endRationale() {
        this.listener.appendRationale(this.lastRationale.toString().trim());
        this.lastRationale = null;
    }

    private void beginComment() {
        this.lastComment = new StringBuilder();
    }

    private void appendComment() {
        if (this.lastComment.length() > 0) {
            this.lastComment.append(System.lineSeparator());
        }
        this.lastComment.append(this.stateMachine.getLastToken());
    }

    private void endComment() {
        this.listener.appendComment(this.lastComment.toString().trim());
        this.lastComment = null;
    }

    private void addDependency() {
        SpecificationItemId.Builder builder = new SpecificationItemId.Builder(this.stateMachine.getLastToken());
        this.listener.addDependsOnId(builder.build());
    }

    private void addNeeds() {
        String artifactTypes = this.stateMachine.getLastToken();
        for (String artifactType : artifactTypes.split(",\\s*")) {
            this.listener.addNeededArtifactType(artifactType);
        }
    }

    private void rememberTitle() {
        this.lastTitle = this.stateMachine.getLastToken();
    }

    private void resetTitle() {
        this.lastTitle = null;
    }

    private void addCoverage() {
        this.listener.addCoveredId(SpecificationItemId.parseId((String)this.stateMachine.getLastToken()));
    }

    private void addTag() {
        String tags = this.stateMachine.getLastToken();
        for (String tag : tags.split(",\\s*")) {
            this.listener.addTag(tag);
        }
    }

    private void forward() {
        MarkdownForwardingSpecificationItem forward = new MarkdownForwardingSpecificationItem(this.stateMachine.getLastToken());
        this.listener.beginSpecificationItem();
        this.listener.setId(forward.getSkippedId());
        this.listener.addCoveredId(forward.getOriginalId());
        for (String targetArtifactType : forward.getTargetArtifactTypes()) {
            this.listener.addNeededArtifactType(targetArtifactType.trim());
        }
        this.listener.setForwards(true);
        this.listener.endSpecificationItem();
    }
}

