/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.markdown;

import java.util.regex.Pattern;
import org.itsallcode.openfasttrace.api.core.SpecificationItemId;

public enum MdPattern {
    COMMENT("Comment:\\s*"),
    COVERS("Covers:\\s*"),
    COVERS_REF(PatternConstants.REFERENCE_AFTER_BULLET),
    DEPENDS("Depends:\\s*"),
    DEPENDS_REF(PatternConstants.REFERENCE_AFTER_BULLET),
    DESCRIPTION("Description:\\s*"),
    EMPTY("(\\s*)"),
    EVERYTHING("(.*)"),
    FORWARD(".*?([a-zA-Z]+\\s*-->\\s*[a-zA-Z]+(?:,\\s*[a-zA-Z]+)*\\s*:\\s*" + SpecificationItemId.ID_PATTERN + ").*?"),
    ID("`?((?:" + SpecificationItemId.ID_PATTERN + ")|(?:" + SpecificationItemId.LEGACY_ID_PATTERN + "))`?.*"),
    NEEDS_INT("Needs:\\s*(\\w+(?:,\\s*\\w+)*)"),
    NEEDS("Needs:\\s*"),
    NEEDS_REF("\\s{0,3}[+*-](?:.*\\W)?(\\p{Alpha}+)(?:\\W.*)?"),
    NOT_EMPTY("([^\n\r]+)"),
    RATIONALE("Rationale:\\s*"),
    STATUS("Status:\\s*(approved|proposed|draft)\\s*"),
    TAGS_INT("Tags:\\s*(\\w+(?:,\\s*\\w+)*)"),
    TAGS("Tags:\\s*"),
    TAG_ENTRY("\\s{0,3}[+*-]\\s*(.*)"),
    TITLE("#+\\s*(.*)");

    private final Pattern pattern;

    private MdPattern(String regularExpression) {
        this.pattern = Pattern.compile(regularExpression);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private static class PatternConstants {
        public static final String ARTIFACT_TYPE = "[a-zA-Z]+";
        public static final String BULLETS = "[+*-]";
        private static final String UP_TO_3_WHITESPACES = "\\s{0,3}";
        public static final String REFERENCE_AFTER_BULLET = "\\s{0,3}[+*-](?:.*\\W)?((?:" + SpecificationItemId.ID_PATTERN + ")|(?:" + SpecificationItemId.LEGACY_ID_PATTERN + "))(?:\\W.*)?";

        private PatternConstants() {
        }
    }
}

