/*
 * Decompiled with CFR 0.152.
 */
package org.itsallcode.openfasttrace.importer.markdown;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.itsallcode.openfasttrace.importer.markdown.State;
import org.itsallcode.openfasttrace.importer.markdown.Transition;

public class MarkdownImporterStateMachine {
    private static final Logger LOG = Logger.getLogger(MarkdownImporterStateMachine.class.getName());
    private State state = State.START;
    private String lastToken = "";
    private final Transition[] transitions;

    public MarkdownImporterStateMachine(Transition[] transitions) {
        this.transitions = transitions;
    }

    public void step(String line) {
        for (Transition entry : this.transitions) {
            if (this.state != entry.getFrom() || !this.matchToken(line, entry)) continue;
            LOG.finest(() -> entry + " : '" + line + "'");
            entry.getTransition().transit();
            this.state = entry.getTo();
            break;
        }
    }

    private boolean matchToken(String line, Transition entry) {
        boolean matches = false;
        Matcher matcher = entry.getMarkdownPattern().getPattern().matcher(line);
        if (matcher.matches()) {
            this.lastToken = matcher.groupCount() == 0 ? "" : matcher.group(1);
            matches = true;
        }
        return matches;
    }

    public String getLastToken() {
        return this.lastToken;
    }
}

