/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.intermine.bio.util.PostProcessUtil;
import org.intermine.metadata.ConstraintOp;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.Location;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.iql.IqlQuery;
import org.intermine.postprocess.PostProcessor;
import org.intermine.util.DynamicUtil;

public class MakeSpanningLocationsProcess
extends PostProcessor {
    Model model = Model.getInstanceByName((String)"genomic");
    protected ObjectStore os;

    public MakeSpanningLocationsProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        this.os = this.osw.getObjectStore();
        this.createSpanningLocations("Transcript", "Exon", "exons");
        this.createSpanningLocations("Gene", "Transcript", "transcripts");
    }

    protected void createSpanningLocations(String parentClsName, String childClsName, String refField) throws ObjectStoreException {
        try {
            String message = "Not performing CalculateLocations.createSpanningLocations(" + parentClsName + ", " + childClsName + ", " + refField + ") ";
            PostProcessUtil.checkFieldExists((Model)this.model, (String)parentClsName, (String)refField, (String)message);
            PostProcessUtil.checkFieldExists((Model)this.model, (String)childClsName, null, (String)message);
        }
        catch (MetaDataException e) {
            return;
        }
        Class parentClass = this.model.getClassDescriptorByName(parentClsName).getType();
        Class childClass = this.model.getClassDescriptorByName(childClsName).getType();
        Query parentIdQuery = new IqlQuery("SELECT DISTINCT a1_.id as id FROM " + parentClass.getName() + " AS a1_, org.intermine.model.bio.Location AS a2_, org.intermine.model.bio.BioEntity as a3_ WHERE (a1_.locations CONTAINS a2_ and a3_.locatedFeatures CONTAINS a2_)", null).toQuery();
        if (this.os == null) {
            this.os = this.osw.getObjectStore();
        }
        Results parentIdResults = this.os.execute(parentIdQuery);
        HashSet<Object> locatedParents = new HashSet<Object>();
        Iterator parentIdIter = parentIdResults.iterator();
        while (parentIdIter.hasNext()) {
            Object parentId = ((ResultsRow)parentIdIter.next()).get(0);
            locatedParents.add(parentId);
        }
        Iterator<?> resIter = MakeSpanningLocationsProcess.findCollections(this.os, parentClass, childClass, refField);
        HashMap locatedOnObjectMap = new HashMap();
        while (resIter.hasNext()) {
            SimpleLoc parentObjectSimpleLoc;
            ResultsRow rr = (ResultsRow)resIter.next();
            BioEntity parentObject = (BioEntity)rr.get(0);
            Location location = (Location)rr.get(2);
            BioEntity locatedOnObject = (BioEntity)rr.get(3);
            Integer parentObjectId = parentObject.getId();
            if (locatedParents.contains(parentObjectId)) continue;
            HashMap<Integer, SimpleLoc> parentObjectMap = (HashMap<Integer, SimpleLoc>)locatedOnObjectMap.get(locatedOnObject.getId());
            if (parentObjectMap == null) {
                parentObjectMap = new HashMap<Integer, SimpleLoc>();
                locatedOnObjectMap.put(locatedOnObject.getId(), parentObjectMap);
            }
            if ((parentObjectSimpleLoc = (SimpleLoc)parentObjectMap.get(parentObjectId)) == null) {
                parentObjectSimpleLoc = new SimpleLoc(-1, -1, Integer.MAX_VALUE, -1, "0");
                parentObjectMap.put(parentObjectId, parentObjectSimpleLoc);
            }
            int currentParentStart = parentObjectSimpleLoc.getStart();
            int currentParentEnd = parentObjectSimpleLoc.getEnd();
            if (location.getStart() < currentParentStart) {
                parentObjectSimpleLoc.setStart(location.getStart());
            }
            if (location.getEnd() > currentParentEnd) {
                parentObjectSimpleLoc.setEnd(location.getEnd());
            }
            parentObjectSimpleLoc.setStrand(location.getStrand());
        }
        this.osw.beginTransaction();
        for (Integer locatedOnObjectId : locatedOnObjectMap.keySet()) {
            BioEntity locatedOnObject = (BioEntity)this.os.getObjectById(locatedOnObjectId);
            Map parentObjectMap = (Map)locatedOnObjectMap.get(locatedOnObjectId);
            for (Integer parentObjectId : parentObjectMap.keySet()) {
                BioEntity parentObject = (BioEntity)this.os.getObjectById(parentObjectId);
                SimpleLoc parentObjectSimpleLoc = (SimpleLoc)parentObjectMap.get(parentObjectId);
                Location newLocation = (Location)DynamicUtil.createObject(Collections.singleton(Location.class));
                newLocation.setStart(new Integer(parentObjectSimpleLoc.getStart()));
                newLocation.setEnd(new Integer(parentObjectSimpleLoc.getEnd()));
                newLocation.setStrand(parentObjectSimpleLoc.getStrand());
                newLocation.setFeature(parentObject);
                newLocation.setLocatedOn(locatedOnObject);
                this.osw.store((Object)newLocation);
            }
        }
        this.osw.commitTransaction();
    }

    private static Iterator<?> findCollections(ObjectStore os, Class<?> parentClass, Class<?> childClass, String refField) throws ObjectStoreException {
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qcParent = new QueryClass(new Class[]{parentClass});
        q.addFrom((FromElement)qcParent);
        q.addToSelect((QuerySelectable)qcParent);
        q.addToOrderBy((QueryOrderable)qcParent);
        QueryClass qcChild = new QueryClass(new Class[]{childClass});
        q.addFrom((FromElement)qcChild);
        q.addToSelect((QuerySelectable)qcChild);
        QueryClass qcLoc = new QueryClass(Location.class);
        q.addFrom((FromElement)qcLoc);
        q.addToSelect((QuerySelectable)qcLoc);
        QueryClass qcLocObject = new QueryClass(BioEntity.class);
        q.addFrom((FromElement)qcLocObject);
        q.addToSelect((QuerySelectable)qcLocObject);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        QueryObjectReference ref1 = new QueryObjectReference(qcLoc, "locatedOn");
        ContainsConstraint cc1 = new ContainsConstraint((QueryReference)ref1, ConstraintOp.CONTAINS, qcLocObject);
        cs.addConstraint((Constraint)cc1);
        QueryObjectReference ref2 = new QueryObjectReference(qcLoc, "feature");
        ContainsConstraint cc2 = new ContainsConstraint((QueryReference)ref2, ConstraintOp.CONTAINS, qcChild);
        cs.addConstraint((Constraint)cc2);
        QueryCollectionReference ref3 = new QueryCollectionReference(qcParent, refField);
        ContainsConstraint cc3 = new ContainsConstraint((QueryReference)ref3, ConstraintOp.CONTAINS, qcChild);
        cs.addConstraint((Constraint)cc3);
        q.setConstraint((Constraint)cs);
        ((ObjectStoreInterMineImpl)os).precompute(q, "precompute");
        Results res = os.execute(q, 1000, true, true, true);
        return res.iterator();
    }

    protected class SimpleLoc {
        private int start;
        private int parentId;
        private int childId;
        private String strand;
        private int end;

        public SimpleLoc(int parentId, int childId, int start, int end, String strand) {
            this.parentId = parentId;
            this.childId = childId;
            this.start = start;
            this.end = end;
            this.strand = strand;
        }

        public SimpleLoc(int parentId, int childId, Location loc) {
            this.parentId = parentId;
            this.childId = childId;
            this.start = loc.getStart();
            this.end = loc.getEnd();
            this.strand = loc.getStrand() != null ? loc.getStrand() : "0";
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getParentId() {
            return this.parentId;
        }

        public int getChildId() {
            return this.childId;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public String getStrand() {
            return this.strand;
        }

        public void setStrand(String strand) {
            this.strand = strand;
        }

        public String toString() {
            return "parent " + this.parentId + " child " + this.childId + " start " + this.start + " end " + this.end + " strand " + this.strand;
        }
    }
}

