/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl;
import org.intermine.postprocess.PostProcessor;
import org.intermine.sql.Database;

public class CreateOverlapViewProcess
extends PostProcessor {
    private static final Logger LOG = Logger.getLogger(CreateOverlapViewProcess.class);

    public CreateOverlapViewProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        try {
            this.createView();
        }
        catch (SQLException e) {
            throw new RuntimeException("failed to create view " + e);
        }
    }

    private void createView() throws SQLException {
        Statement statement;
        if (!(this.osw instanceof ObjectStoreWriterInterMineImpl)) {
            throw new RuntimeException("The ObjectStoreWriter is not an ObjectStoreWriterInterMineImpl");
        }
        Database db = ((ObjectStoreWriterInterMineImpl)this.osw).getDatabase();
        Connection con = db.getConnection();
        con.setAutoCommit(true);
        String viewSql = "CREATE VIEW overlappingfeaturessequencefeature  AS SELECT l1.featureid AS overlappingfeatures,            l2.featureid AS sequencefeature       FROM location l1, location l2      WHERE l1.locatedonid = l2.locatedonid        AND l1.featureid != l2.featureid       AND int4range(l1.intermine_start, l1.intermine_end + 1)            && int4range(l2.intermine_start, l2.intermine_end + 1)";
        LOG.info((Object)("Creating overlap view with SQL: " + viewSql));
        String dropSql = "DROP TABLE overlappingfeaturessequencefeature";
        try {
            statement = con.createStatement();
            statement.executeUpdate(dropSql);
            statement.close();
        }
        catch (SQLException e) {
            dropSql = "DROP VIEW overlappingfeaturessequencefeature";
            Statement statement2 = con.createStatement();
            statement2.executeUpdate(dropSql);
            statement2.close();
        }
        statement = con.createStatement();
        statement.executeUpdate(viewSql);
        statement.close();
        con.close();
    }
}

