/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl;
import org.intermine.postprocess.PostProcessor;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseConnectionException;

public class CreateLocationOverlapIndexProcess
extends PostProcessor {
    private static final String RANGE_TYPE = "int4range";
    private static final Logger LOG = Logger.getLogger(CreateLocationOverlapIndexProcess.class);

    public CreateLocationOverlapIndexProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        if (!(this.osw instanceof ObjectStoreWriterInterMineImpl)) {
            throw new RuntimeException("The ObjectStoreWriter is not an ObjectStoreWriterInterMineImpl");
        }
        Database db = ((ObjectStoreWriterInterMineImpl)this.osw).getDatabase();
        Connection con = null;
        try {
            con = db.getConnection();
            if (this.hasIndexAlready(con)) {
                return;
            }
            String indexType = "SPGIST";
            long startTime = System.currentTimeMillis();
            String indexSql = "CREATE INDEX location__int4range ON location USING " + indexType + " (" + RANGE_TYPE + "(intermine_start, intermine_end + 1))";
            LOG.info((Object)indexSql);
            Statement statement = con.createStatement();
            statement.executeUpdate(indexSql);
            statement.close();
            long took = System.currentTimeMillis() - startTime;
            LOG.info((Object)("Created int4range index on location, took: " + took + "ms."));
        }
        catch (DatabaseConnectionException e) {
            throw new RuntimeException("Cannot get database connection. " + (Object)((Object)e));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create location__int4range. You likely have bad locations. ", e);
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private boolean hasIndexAlready(Connection con) throws SQLException {
        String sql = "SELECT 1 FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relname = 'location__int4range' AND n.nspname = 'public'";
        Statement statement = con.createStatement();
        ResultSet res = statement.executeQuery("SELECT 1 FROM pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relname = 'location__int4range' AND n.nspname = 'public'");
        boolean hasIndex = res.next();
        statement.close();
        return hasIndex;
    }
}

