/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.intermine.bio.util.BioQueries;
import org.intermine.bio.util.PostProcessUtil;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.metadata.Util;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.BioEntity;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.DataSet;
import org.intermine.model.bio.DataSource;
import org.intermine.model.bio.Gene;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.postprocess.PostProcessor;
import org.intermine.util.DynamicUtil;

public class CreateIntergenicRegionFeaturesProcess
extends PostProcessor {
    private ObjectStore os;
    private Model model;
    private DataSet dataSet;
    private DataSource dataSource;

    public CreateIntergenicRegionFeaturesProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        this.os = this.osw.getObjectStore();
        this.model = this.os.getModel();
        this.dataSource = (DataSource)DynamicUtil.createObject(Collections.singleton(DataSource.class));
        this.dataSource.setName("FlyMine");
        try {
            this.dataSource = (DataSource)this.os.getObjectByExample((InterMineObject)this.dataSource, Collections.singleton("name"));
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("unable to fetch InterMine DataSource object", e);
        }
        try {
            String message = "Not performing IntergenicRegionUtil.createIntergenicRegionFeatures ";
            PostProcessUtil.checkFieldExists((Model)this.model, (String)"IntergenicRegion", (String)"adjacentGenes", (String)message);
            PostProcessUtil.checkFieldExists((Model)this.model, (String)"Gene", (String)"upstreamIntergenicRegion", (String)message);
            PostProcessUtil.checkFieldExists((Model)this.model, (String)"Gene", (String)"downstreamIntergenicRegion", (String)message);
        }
        catch (MetaDataException e) {
            return;
        }
        Results results = BioQueries.findLocationAndObjects((ObjectStore)this.os, Chromosome.class, Gene.class, (boolean)false, (boolean)false, (boolean)false, (int)1000);
        this.dataSet = (DataSet)DynamicUtil.createObject(Collections.singleton(DataSet.class));
        this.dataSet.setName("FlyMine intergenic regions");
        this.dataSet.setDescription("Intergenic regions created by FlyMine");
        this.dataSet.setVersion("" + new Date());
        this.dataSet.setUrl("http://www.flymine.org");
        this.dataSet.setDataSource(this.dataSource);
        Iterator resIter = results.iterator();
        Integer previousChrId = null;
        HashSet<Object> locationSet = new HashSet<Location>();
        HashMap<Integer, Set<Object>> locToGeneMap = new HashMap<Integer, Set<Gene>>();
        this.osw.beginTransaction();
        while (resIter.hasNext()) {
            ResultsRow rr = (ResultsRow)resIter.next();
            Integer chrId = (Integer)rr.get(0);
            Gene gene = (Gene)rr.get(1);
            Location loc = (Location)rr.get(2);
            if (previousChrId != null && !chrId.equals(previousChrId)) {
                Iterator<SequenceFeature> irIter = this.createFeatures(locationSet, locToGeneMap, previousChrId);
                try {
                    CreateIntergenicRegionFeaturesProcess.storeIntergenicRegions(this.osw, irIter);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to store intergenic region " + e);
                }
                locationSet = new HashSet();
                locToGeneMap = new HashMap();
            }
            CreateIntergenicRegionFeaturesProcess.addToLocToGeneMap(locToGeneMap, loc, gene);
            locationSet.add(loc);
            previousChrId = chrId;
        }
        if (previousChrId != null) {
            Iterator<SequenceFeature> irIter = this.createFeatures(locationSet, locToGeneMap, previousChrId);
            try {
                CreateIntergenicRegionFeaturesProcess.storeIntergenicRegions(this.osw, irIter);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to store intergenic region " + e);
            }
            this.osw.store((Object)this.dataSet);
        }
        this.osw.commitTransaction();
    }

    private static void addToLocToGeneMap(Map<Integer, Set<Gene>> locToGeneMap, Location loc, Gene gene) {
        Util.addToSetMap(locToGeneMap, (Object)loc.getStart(), (Object)gene);
        Util.addToSetMap(locToGeneMap, (Object)loc.getEnd(), (Object)gene);
    }

    private static void storeIntergenicRegions(ObjectStoreWriter objectStoreWriter, Iterator<SequenceFeature> irIter) throws ObjectStoreException, IllegalAccessException {
        while (irIter.hasNext()) {
            SequenceFeature ir = irIter.next();
            if (ir == null) continue;
            objectStoreWriter.store((Object)ir);
            objectStoreWriter.store((Object)ir.getChromosomeLocation());
            Set adjacentGenes = (Set)ir.getFieldValue("adjacentGenes");
            Iterator adjacentGenesIter = adjacentGenes.iterator();
            while (adjacentGenesIter.hasNext()) {
                objectStoreWriter.store(adjacentGenesIter.next());
            }
        }
    }

    protected Iterator<SequenceFeature> createFeatures(Set<Location> locationSet, final Map<Integer, Set<Gene>> locToGeneMap, Integer chrId) throws ObjectStoreException {
        Chromosome chr;
        if (this.os == null) {
            this.os = this.osw.getObjectStore();
        }
        if ((chr = (Chromosome)this.os.getObjectById(chrId)).getLength() == null) {
            return new HashSet().iterator();
        }
        final BitSet bs = new BitSet(chr.getLength() + 1);
        for (Location location : locationSet) {
            bs.set((int)location.getStart(), location.getEnd() + 1);
        }
        return new Iterator<SequenceFeature>(){
            int prevEndPos = 0;
            {
                if (bs.nextClearBit(this.prevEndPos) == -1) {
                    this.prevEndPos = -1;
                }
            }

            @Override
            public boolean hasNext() {
                return this.prevEndPos != -1;
            }

            @Override
            public SequenceFeature next() {
                Set prevGenes;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int nextIntergenicStart = bs.nextClearBit(this.prevEndPos + 1);
                int nextSetBit = bs.nextSetBit(nextIntergenicStart);
                int intergenicEnd = nextSetBit == -1 ? chr.getLength() : nextSetBit - 1;
                this.prevEndPos = nextSetBit == -1 || bs.nextClearBit(nextSetBit) > chr.getLength() ? -1 : intergenicEnd;
                int newLocStart = nextIntergenicStart;
                int newLocEnd = intergenicEnd;
                if (newLocStart > newLocEnd) {
                    return null;
                }
                Class igCls = CreateIntergenicRegionFeaturesProcess.this.os.getModel().getClassDescriptorByName("IntergenicRegion").getType();
                SequenceFeature intergenicRegion = (SequenceFeature)DynamicUtil.createObject(Collections.singleton(igCls));
                Location location = (Location)DynamicUtil.createObject(Collections.singleton(Location.class));
                location.setStart(new Integer(newLocStart));
                location.setEnd(new Integer(newLocEnd));
                location.setStrand("1");
                location.setFeature((BioEntity)intergenicRegion);
                location.setLocatedOn((BioEntity)chr);
                location.addDataSets(CreateIntergenicRegionFeaturesProcess.this.dataSet);
                intergenicRegion.setChromosomeLocation(location);
                intergenicRegion.setChromosome(chr);
                intergenicRegion.setOrganism(chr.getOrganism());
                intergenicRegion.addDataSets(CreateIntergenicRegionFeaturesProcess.this.dataSet);
                int length = location.getEnd() - location.getStart() + 1;
                intergenicRegion.setLength(new Integer(length));
                String primaryIdentifier = "intergenic_region_chr" + chr.getPrimaryIdentifier() + "_" + location.getStart() + ".." + location.getEnd();
                intergenicRegion.setPrimaryIdentifier(primaryIdentifier);
                HashSet<Gene> adjacentGenes = new HashSet<Gene>();
                Set nextGenes = (Set)locToGeneMap.get(new Integer(newLocEnd + 1));
                if (nextGenes != null) {
                    for (Gene nextGene : nextGenes) {
                        String strand = null;
                        if (nextGene.getChromosomeLocation() != null) {
                            strand = nextGene.getChromosomeLocation().getStrand();
                        }
                        if (strand != null) {
                            if ("1".equals(strand)) {
                                nextGene.setFieldValue("upstreamIntergenicRegion", (Object)intergenicRegion);
                            } else {
                                nextGene.setFieldValue("downstreamIntergenicRegion", (Object)intergenicRegion);
                            }
                        }
                        adjacentGenes.add(nextGene);
                    }
                }
                if ((prevGenes = (Set)locToGeneMap.get(new Integer(newLocStart - 1))) != null) {
                    for (Gene prevGene : prevGenes) {
                        String strand = null;
                        if (prevGene.getChromosomeLocation() != null) {
                            strand = prevGene.getChromosomeLocation().getStrand();
                        }
                        if (strand != null) {
                            if ("1".equals(strand)) {
                                prevGene.setFieldValue("downstreamIntergenicRegion", (Object)intergenicRegion);
                            } else {
                                prevGene.setFieldValue("upstreamIntergenicRegion", (Object)intergenicRegion);
                            }
                        }
                        adjacentGenes.add(prevGene);
                    }
                }
                intergenicRegion.setFieldValue("adjacentGenes", adjacentGenes);
                return intergenicRegion;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from this iterator.");
            }
        };
    }
}

