/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.bio.postprocess;

import java.util.Iterator;
import org.intermine.bio.util.BioQueries;
import org.intermine.bio.util.PostProcessUtil;
import org.intermine.model.InterMineObject;
import org.intermine.model.bio.Chromosome;
import org.intermine.model.bio.Location;
import org.intermine.model.bio.SequenceFeature;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.postprocess.PostProcessor;

public class CreateChromosomeLocationsProcess
extends PostProcessor {
    public CreateChromosomeLocationsProcess(ObjectStoreWriter osw) {
        super(osw);
    }

    public void postProcess() throws ObjectStoreException {
        Results results = BioQueries.findLocationAndObjects((ObjectStore)this.osw, Chromosome.class, SequenceFeature.class, (boolean)true, (boolean)false, (boolean)false, (int)10000);
        Iterator resIter = results.iterator();
        this.osw.beginTransaction();
        Integer lastChrId = null;
        SequenceFeature lastFeature = null;
        boolean storeLastFeature = true;
        Location lastLoc = null;
        while (resIter.hasNext()) {
            ResultsRow rr = (ResultsRow)resIter.next();
            Integer chrId = (Integer)rr.get(0);
            SequenceFeature lsf = (SequenceFeature)rr.get(1);
            Location locOnChr = (Location)rr.get(2);
            if (lastFeature != null && !lsf.getId().equals(lastFeature.getId())) {
                if (storeLastFeature) {
                    try {
                        this.setChromosomeReferencesAndStore(lastFeature, lastLoc, lastChrId);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Error storing chromosome reference:" + e);
                    }
                }
                storeLastFeature = true;
            } else if (lastFeature != null) {
                storeLastFeature = false;
            }
            lastFeature = lsf;
            lastChrId = chrId;
            lastLoc = locOnChr;
        }
        if (storeLastFeature && lastFeature != null) {
            try {
                this.setChromosomeReferencesAndStore(lastFeature, lastLoc, lastChrId);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error storing chromosome reference:" + e);
            }
        }
        this.osw.commitTransaction();
    }

    private void setChromosomeReferencesAndStore(SequenceFeature lsf, Location loc, Integer chrId) throws ObjectStoreException, IllegalAccessException {
        SequenceFeature lsfClone = (SequenceFeature)PostProcessUtil.cloneInterMineObject((InterMineObject)lsf);
        lsfClone.setChromosomeLocation(loc);
        if (loc.getStart() != null && loc.getEnd() != null) {
            int end = loc.getEnd();
            int start = loc.getStart();
            if (lsfClone.getLength() == null) {
                int length = Math.abs(end - start) + 1;
                lsfClone.setLength(new Integer(length));
            }
        }
        lsfClone.proxyChromosome(new ProxyReference((ObjectStore)this.osw, chrId, Chromosome.class));
        this.osw.store((Object)lsfClone);
    }
}

