/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileIndexResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.InputLimit;
import org.apache.http.client.cache.Resource;
import org.apache.http.client.cache.ResourceFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class FileIndexResourceFactory
implements ResourceFactory {
    private final Path cacheDir;

    public FileIndexResourceFactory(Path cacheDir) {
        this.cacheDir = cacheDir;
    }

    protected Path generateUniqueCachePath(String uri) {
        Object resourcePart = !uri.isEmpty() ? uri.substring(uri.lastIndexOf(47) + 1) : uri;
        resourcePart = ((String)resourcePart).isEmpty() ? resourcePart : (String)resourcePart + "_";
        return Paths.get((String)resourcePart + DigestUtils.md5Hex((String)UUID.randomUUID().toString()), new String[0]);
    }

    public Resource generate(String requestId, InputStream inStream, InputLimit limit) throws IOException {
        if (!Files.exists(this.cacheDir, new LinkOption[0])) {
            Files.createDirectories(this.cacheDir, new FileAttribute[0]);
        }
        Path cachedFile = this.generateUniqueCachePath(requestId);
        Files.copy(inStream, this.cacheDir.resolve(cachedFile), StandardCopyOption.REPLACE_EXISTING);
        return new FileIndexResource(cachedFile, this.cacheDir);
    }

    public Resource copy(String requestId, Resource resource) throws IOException {
        Path dst = this.generateUniqueCachePath(requestId);
        if (resource instanceof FileIndexResource) {
            Files.copy(this.cacheDir.resolve(((FileIndexResource)resource).getPath()), this.cacheDir.resolve(dst), StandardCopyOption.REPLACE_EXISTING);
        } else {
            try (InputStream is = resource.getInputStream();){
                Files.copy(is, this.cacheDir.resolve(dst), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return new FileIndexResource(dst, this.cacheDir);
    }
}

