/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.googlecode.download.maven.plugin.internal.DownloadFailureException;
import com.googlecode.download.maven.plugin.internal.ProgressReport;
import com.googlecode.download.maven.plugin.internal.cache.FileBackedIndex;
import com.googlecode.download.maven.plugin.internal.cache.FileIndexResourceFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.apache.maven.shared.utils.StringUtils;

public class HttpFileRequester {
    public static final int HEURISTIC_DEFAULT_LIFETIME = 31449600;
    private ProgressReport progressReport;
    private int connectTimeout;
    private int socketTimeout;
    private HttpRoutePlanner routePlanner;
    private CredentialsProvider credentialsProvider;
    private File cacheDir;
    private Log log;
    private boolean redirectsEnabled;
    private URI uri;
    private boolean preemptiveAuth;

    private HttpFileRequester() {
    }

    public void download(File outputFile, List<Header> headers) throws IOException {
        CachingHttpClientBuilder httpClientBuilder = this.createHttpClientBuilder();
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            HttpCacheContext clientContext = HttpCacheContext.create();
            clientContext.setCredentialsProvider(this.credentialsProvider);
            if (this.preemptiveAuth) {
                BasicAuthCache authCache = new BasicAuthCache();
                authCache.put(new HttpHost(this.uri.getHost(), this.uri.getPort()), (AuthScheme)new BasicScheme());
                clientContext.setAuthCache((AuthCache)authCache);
            }
            HttpGet httpGet = new HttpGet(this.uri);
            headers.forEach(arg_0 -> ((HttpGet)httpGet).setHeader(arg_0));
            httpClient.execute((HttpUriRequest)httpGet, response -> this.handleResponse(this.uri, outputFile, clientContext, response), (HttpContext)clientContext);
        }
    }

    private Object handleResponse(URI uri, File outputFile, HttpCacheContext clientContext, HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new DownloadFailureException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
        }
        if (response.getStatusLine().getStatusCode() >= 301 && response.getStatusLine().getStatusCode() <= 303) {
            throw new DownloadFailureException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase() + ". Not downloading the resource because followRedirects is false.");
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            switch (clientContext.getCacheResponseStatus()) {
                case CACHE_HIT: 
                case CACHE_MODULE_RESPONSE: 
                case VALIDATED: {
                    this.log.debug((CharSequence)"Copying file from cache");
                    Files.copy(entity.getContent(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    break;
                }
                default: {
                    this.progressReport.initiate(uri, entity.getContentLength());
                    byte[] tmp = new byte[88192];
                    try (InputStream in = entity.getContent();
                         OutputStream out = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);){
                        int bytesRead;
                        while ((bytesRead = in.read(tmp)) != -1) {
                            out.write(tmp, 0, bytesRead);
                            this.progressReport.update(bytesRead);
                        }
                        out.flush();
                        this.progressReport.completed();
                        break;
                    }
                    catch (IOException ex) {
                        this.progressReport.error(ex);
                        throw ex;
                    }
                }
            }
        }
        return entity;
    }

    private CachingHttpClientBuilder createHttpClientBuilder() throws NotDirectoryException {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.socketTimeout).setRedirectsEnabled(this.redirectsEnabled).build();
        CachingHttpClientBuilder httpClientBuilder = (CachingHttpClientBuilder)CachingHttpClients.custom().setDefaultCredentialsProvider(this.credentialsProvider).setRoutePlanner(this.routePlanner).setDefaultRequestConfig(requestConfig);
        if (this.cacheDir != null) {
            CacheConfig config = CacheConfig.custom().setHeuristicDefaultLifetime(31449600L).setHeuristicCachingEnabled(true).setMaxObjectSize(Long.MAX_VALUE).setMaxCacheEntries(Integer.MAX_VALUE).build();
            httpClientBuilder.setCacheDir(this.cacheDir).setCacheConfig(config).setResourceFactory((ResourceFactory)new FileIndexResourceFactory(this.cacheDir.toPath())).setHttpCacheStorage((HttpCacheStorage)new FileBackedIndex(this.cacheDir.toPath(), this.log)).setDeleteCache(false);
        }
        return httpClientBuilder;
    }

    public static class Builder {
        private ProgressReport progressReport;
        private File cacheDir;
        private int connectTimeout = 3000;
        private int socketTimeout = 3000;
        private URI uri;
        private String username;
        private String password;
        private String serverId;
        private String proxyHost;
        private int proxyPort;
        private String proxyUserName;
        private String proxyPassword;
        private String proxyNtlmHost;
        private String proxyNtlmDomain;
        private Log log;
        private boolean redirectsEnabled;
        private MavenSession mavenSession;
        private boolean preemptiveAuth;

        public Builder withUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder withProgressReport(ProgressReport progressReport) {
            this.progressReport = progressReport;
            return this;
        }

        public Builder withCacheDir(File cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withServerId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder withProxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder withProxyUserName(String proxyUserName) {
            this.proxyUserName = proxyUserName;
            return this;
        }

        public Builder withProxyPassword(String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public Builder withNtlmHost(String proxyNtlmHost) {
            this.proxyNtlmHost = proxyNtlmHost;
            return this;
        }

        public Builder withNtlmDomain(String proxyNtlmDomain) {
            this.proxyNtlmDomain = proxyNtlmDomain;
            return this;
        }

        public Builder withLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder withRedirectsEnabled(boolean followRedirects) {
            this.redirectsEnabled = followRedirects;
            return this;
        }

        public Builder withPreemptiveAuth(boolean preemptiveAuth) {
            this.preemptiveAuth = preemptiveAuth;
            return this;
        }

        public Builder withMavenSession(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
            return this;
        }

        public HttpFileRequester build() throws MojoExecutionException {
            HttpFileRequester instance = new HttpFileRequester();
            instance.uri = Objects.requireNonNull(this.uri);
            instance.progressReport = this.progressReport;
            instance.connectTimeout = this.connectTimeout;
            instance.socketTimeout = this.socketTimeout;
            instance.cacheDir = this.cacheDir;
            instance.redirectsEnabled = this.redirectsEnabled;
            instance.preemptiveAuth = this.preemptiveAuth;
            instance.log = Objects.requireNonNull(this.log);
            instance.credentialsProvider = new BasicCredentialsProvider();
            if (StringUtils.isNotBlank((String)this.serverId)) {
                Server server;
                Objects.requireNonNull(this.mavenSession);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("providing custom authentication for " + this.serverId));
                }
                if ((server = this.mavenSession.getSettings().getServer(this.serverId)) == null) {
                    throw new MojoExecutionException(String.format("Server %s not found", this.serverId));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)String.format("serverId %s supplies username: %s and password: ***", this.serverId, server.getUsername()));
                }
                instance.credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(server.getUsername(), server.getPassword()));
            } else if (StringUtils.isNotBlank((String)this.username)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)"providing custom authentication");
                    this.log.debug((CharSequence)("username: " + this.username + " and password: ***"));
                }
                instance.credentialsProvider.setCredentials(new AuthScope(this.uri.getHost(), this.uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            }
            if (StringUtils.isNotBlank((String)this.proxyHost)) {
                HttpHost host = new HttpHost(this.proxyHost, this.proxyPort);
                instance.routePlanner = new DefaultProxyRoutePlanner(host);
                if (StringUtils.isNotBlank((String)this.proxyUserName) && StringUtils.isNotBlank((String)this.proxyPassword)) {
                    instance.credentialsProvider.setCredentials(new AuthScope(host.getHostName(), host.getPort()), (Credentials)(StringUtils.isNotBlank((String)this.proxyNtlmHost) && StringUtils.isNotBlank((String)this.proxyNtlmDomain) ? new NTCredentials(this.proxyUserName, this.proxyPassword, this.proxyNtlmHost, this.proxyNtlmDomain) : new UsernamePasswordCredentials(this.proxyUserName, this.proxyPassword)));
                }
            } else {
                instance.routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
            }
            return instance;
        }
    }
}

