/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileBackedIndex;
import com.googlecode.download.maven.plugin.internal.cache.FileIndexResource;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.Resource;
import org.apache.http.message.BasicStatusLine;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class FileBackedIndexTest {
    @Test
    public void testAsUri() {
        MatcherAssert.assertThat((Object)FileBackedIndex.asUri((String)"foo://test/file.bin"), (Matcher)Is.is((Object)URI.create("foo://test/file.bin")));
    }

    @Test
    public void testUriWithPortAsUri() {
        MatcherAssert.assertThat((Object)FileBackedIndex.asUri((String)"bar://test:8080/file.bin"), (Matcher)Is.is((Object)URI.create("bar://test/file.bin")));
    }

    @Test
    public void testUriWithAuthInfoAsUri() {
        MatcherAssert.assertThat((Object)FileBackedIndex.asUri((String)"test://bill@test:8080/file.bin"), (Matcher)Is.is((Object)URI.create("test://bill@test/file.bin")));
    }

    @Test
    public void testUriWithAdditionalHeaderInfoUri() {
        MatcherAssert.assertThat((Object)FileBackedIndex.asUri((String)"{Accept-Encoding=gzip%2Cdeflate}https://postman-echo.com:443/get"), (Matcher)Is.is((Object)URI.create("https://postman-echo.com/get")));
    }

    @Test
    public void testIndexedFileNotFound() throws Exception {
        Path path = Files.createTempDirectory("file-backed-index", new FileAttribute[0]);
        class ClosablePath
        implements AutoCloseable {
            private final Path dir;

            public ClosablePath(Path dir) {
                this.dir = dir;
            }

            @Override
            public void close() throws Exception {
                FileUtils.deleteDirectory((File)this.dir.toFile());
            }
        }
        try (ClosablePath ignored = new ClosablePath(path);){
            FileBackedIndex index = new FileBackedIndex(path, (Log)new SystemStreamLog());
            index.putEntry("foo://file.bin", new HttpCacheEntry(new Date(), new Date(), (StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"), new Header[0], (Resource)new FileIndexResource(Paths.get("bogus", new String[0]), path)));
            MatcherAssert.assertThat((Object)index.getEntry("foo://file.bin"), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        }
    }
}

