/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.googlecode.download.maven.plugin.internal.DownloadFailureException;
import com.googlecode.download.maven.plugin.internal.WGetMojo;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.codehaus.plexus.util.ReflectionUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.sonatype.plexus.build.incremental.BuildContext;

public class WGetMojoTest {
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort());
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path cacheDirectory;
    private static final String OUTPUT_FILE_NAME = "output-file";
    private Path outputDirectory;

    @Before
    public void setUp() throws Exception {
        this.temporaryFolder.create();
        this.cacheDirectory = this.temporaryFolder.newFolder("wget-test-cache").toPath();
        this.outputDirectory = this.temporaryFolder.newFolder("wget-test").toPath();
    }

    @After
    public void tearDown() {
        this.temporaryFolder.delete();
    }

    private <T> void setVariableValueToObject(Object object, String variable, T value) {
        try {
            Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private WGetMojo createMojo(Consumer<WGetMojo> initializer) {
        WGetMojo mojo = new WGetMojo();
        BuildContext buildContext = (BuildContext)Mockito.mock(BuildContext.class);
        ((BuildContext)Mockito.doNothing().when((Object)buildContext)).refresh((File)ArgumentMatchers.any(File.class));
        this.setVariableValueToObject(mojo, "outputFileName", OUTPUT_FILE_NAME);
        this.setVariableValueToObject(mojo, "outputDirectory", this.outputDirectory.toFile());
        this.setVariableValueToObject(mojo, "cacheDirectory", this.cacheDirectory.toFile());
        this.setVariableValueToObject(mojo, "retries", 1);
        this.setVariableValueToObject(mojo, "buildContext", buildContext);
        this.setVariableValueToObject(mojo, "overwrite", true);
        try {
            this.setVariableValueToObject(mojo, "uri", new URI("http://test"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        class MavenSessionStub
        extends MavenSession {
            MavenSessionStub() {
                super(null, (MavenExecutionRequest)Mockito.mock(MavenExecutionRequest.class), null, new LinkedList());
                DefaultRepositorySystemSession repositorySystemSession = new DefaultRepositorySystemSession();
                repositorySystemSession.setOffline(false);
                WGetMojoTest.this.setVariableValueToObject((Object)this, "repositorySession", repositorySystemSession);
            }
        }
        this.setVariableValueToObject(mojo, "session", new MavenSessionStub());
        initializer.accept(mojo);
        return mojo;
    }

    private static CachingHttpClientBuilder createClientBuilderForResponse(final Supplier<HttpResponse> responseSupplier) {
        CachingHttpClientBuilder clientBuilder = CachingHttpClientBuilder.create();
        clientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager(){

            public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) {
            }
        });
        clientBuilder.setRequestExecutor(new HttpRequestExecutor(){

            protected HttpResponse doSendRequest(HttpRequest request, HttpClientConnection conn, HttpContext context) {
                return (HttpResponse)responseSupplier.get();
            }
        });
        return clientBuilder;
    }

    private static CachingHttpClientBuilder createClientBuilder(final Supplier<String> contentSupplier) {
        return WGetMojoTest.createClientBuilderForResponse(() -> new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "Ok"){
            {
                super(ver, code, reason);
                try {
                    this.setEntity((HttpEntity)new StringEntity((String)contentSupplier.get() + "\n"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testCacheDirectoryNotCreated() throws MojoExecutionException, MojoFailureException {
        CachingHttpClientBuilder clientBuilder = WGetMojoTest.createClientBuilder(() -> "Hello, world!");
        try (MockedStatic httpClientBuilder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
            httpClientBuilder.when(CachingHttpClientBuilder::create).thenReturn((Object)clientBuilder);
            this.createMojo(m -> this.setVariableValueToObject(m, "skipCache", true)).execute();
        }
        MatcherAssert.assertThat((String)"Cache directory should remain empty if skipCache is true", (Object)this.cacheDirectory.toFile().list(), (Matcher)Matchers.emptyArray());
    }

    @Test
    public void testCacheInANonExistingDirectory() throws Exception {
        Path cacheDir = this.cacheDirectory.resolve("cache/dir");
        CachingHttpClientBuilder clientBuilder = WGetMojoTest.createClientBuilder(() -> "Hello, world!");
        try (MockedStatic builder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
            builder.when(CachingHttpClientBuilder::create).thenReturn((Object)clientBuilder);
            this.createMojo(m -> this.setVariableValueToObject(m, "cacheDirectory", cacheDir.toFile())).execute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw new RuntimeException(e);
        }
        finally {
            MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
        }
    }

    @Test
    public void testCacheInNotADirectory() throws Exception {
        try {
            this.createMojo(m -> {
                File notADirectory = (File)Mockito.mock(File.class);
                Mockito.when((Object)notADirectory.getAbsolutePath()).thenReturn((Object)"/nonExistingDirectory");
                Mockito.when((Object)notADirectory.exists()).thenReturn((Object)true);
                Mockito.when((Object)notADirectory.isDirectory()).thenReturn((Object)false);
                this.setVariableValueToObject(m, "cacheDirectory", notADirectory);
            }).execute();
            Assert.fail();
        }
        catch (MojoFailureException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"cacheDirectory is not a directory"));
        }
    }

    @Test
    public void testCacheNotWrittenToIfFailed() throws Exception {
        try {
            WGetMojo mojo = this.createMojo(ignored -> {});
            this.setVariableValueToObject(mojo, "session", null);
            mojo.execute();
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            MatcherAssert.assertThat((String)"Cache directory should remain empty if quit abruptly", (Object)this.cacheDirectory.toFile().list(), (Matcher)Matchers.emptyArray());
        }
    }

    @Test
    public void testReadingFromCache() throws Exception {
        CachingHttpClientBuilder firstAnswer = WGetMojoTest.createClientBuilder(() -> "Hello, world!");
        try (MockedStatic httpClientBuilder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
            httpClientBuilder.when(CachingHttpClientBuilder::create).thenReturn((Object)firstAnswer);
            this.createMojo(mojo -> {}).execute();
        }
        CachingHttpClientBuilder secondAnswer = WGetMojoTest.createClientBuilder(() -> "Goodbye!");
        try (MockedStatic httpClientBuilder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
            httpClientBuilder.when(CachingHttpClientBuilder::create).thenReturn((Object)secondAnswer);
            this.createMojo(mojo -> this.setVariableValueToObject(mojo, "overwrite", true)).execute();
        }
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
    }

    @Test
    public void testCacheRetainingValuesFromTwoConcurrentCalls() throws Exception {
        URI firstMojoUri = URI.create("http://test/foo");
        URI secondMojoUri = URI.create("http://test/bar");
        WGetMojo firstMojo = this.createMojo(mojo -> {
            this.setVariableValueToObject(mojo, "uri", firstMojoUri);
            this.setVariableValueToObject(mojo, "outputFileName", OUTPUT_FILE_NAME);
        });
        WGetMojo secondMojo = this.createMojo(mojo -> {
            this.setVariableValueToObject(mojo, "uri", secondMojoUri);
            this.setVariableValueToObject(mojo, "outputFileName", "second-output-file");
        });
        CountDownLatch firstMojoStarted = new CountDownLatch(1);
        CountDownLatch secondMojoFinished = new CountDownLatch(1);
        Arrays.asList(CompletableFuture.runAsync(() -> {
            CachingHttpClientBuilder clientBuilder = WGetMojoTest.createClientBuilder(() -> {
                firstMojoStarted.countDown();
                try {
                    assert (secondMojoFinished.await(1L, TimeUnit.SECONDS));
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return "foo";
            });
            try (MockedStatic builder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
                builder.when(CachingHttpClientBuilder::create).thenReturn((Object)clientBuilder);
                firstMojo.execute();
            }
            catch (MojoExecutionException | MojoFailureException e) {
                throw new RuntimeException(e);
            }
        }), CompletableFuture.runAsync(() -> {
            CachingHttpClientBuilder clientBuilder = WGetMojoTest.createClientBuilder(() -> "bar");
            try (MockedStatic builder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
                builder.when(CachingHttpClientBuilder::create).thenReturn((Object)clientBuilder);
                assert (firstMojoStarted.await(1L, TimeUnit.SECONDS));
                secondMojo.execute();
                secondMojoFinished.countDown();
            }
            catch (InterruptedException | MojoExecutionException | MojoFailureException e) {
                throw new RuntimeException(e);
            }
        })).forEach(CompletableFuture::join);
        try (ObjectInputStream stream = new ObjectInputStream(Files.newInputStream(this.cacheDirectory.resolve("index.ser"), new OpenOption[0]));){
            Map index = (Map)stream.readObject();
            MatcherAssert.assertThat(index.entrySet(), (Matcher)Matchers.hasSize((int)2));
            MatcherAssert.assertThat(index.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new URI[]{firstMojoUri, secondMojoUri}));
            MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.cacheDirectory.resolve((String)index.get(firstMojoUri)))), (Matcher)Matchers.is((Object)"foo"));
            MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.cacheDirectory.resolve((String)index.get(secondMojoUri)))), (Matcher)Matchers.is((Object)"bar"));
        }
    }

    @Test
    public void testCustomHeaders() throws MojoExecutionException, MojoFailureException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.serverError()));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "headers", new HashMap<String, String>(){
                {
                    this.put("X-Custom-1", "first custom header");
                    this.put("X-Custom-2", "second custom header");
                }
            });
        }).execute();
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()).withHeader("X-Custom-1", WireMock.equalTo((String)"first custom header")).withHeader("X-Custom-2", WireMock.equalTo((String)"second custom header")));
    }

    @Test
    public void testQuery() throws MojoExecutionException, MojoFailureException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.serverError()));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl() + "?query=value"));
            this.setVariableValueToObject(m, "skipCache", true);
        }).execute();
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()).withQueryParam("query", WireMock.equalTo((String)"value")));
    }

    @Test
    public void testTemporaryRedirect() throws MojoExecutionException, MojoFailureException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/old")).willReturn(WireMock.temporaryRedirect((String)"/new")));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/new")).willReturn(WireMock.serverError()));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.url("/old")));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "followRedirects", true);
        }).execute();
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/old")));
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/new")));
    }

    @Test
    public void testPermanentRedirect() throws MojoExecutionException, MojoFailureException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/old")).willReturn(WireMock.permanentRedirect((String)"/new")));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/new")).willReturn(WireMock.serverError()));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.url("/old")));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "followRedirects", true);
        }).execute();
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/old")));
        WireMock.verify((RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/new")));
    }

    @Test
    public void testAlwaysOverwrite() throws MojoExecutionException, MojoFailureException, IOException, InterruptedException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello")));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "overwrite", true);
            this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
        }).execute();
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello"));
        Path outputPath = this.outputDirectory.resolve(OUTPUT_FILE_NAME);
        FileTime firstModificationTime = Files.getLastModifiedTime(outputPath, new LinkOption[0]);
        Thread.sleep(1000L);
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "overwrite", true);
            this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
        }).execute();
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello"));
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(outputPath, new LinkOption[0]), (Matcher)Matchers.not((Object)firstModificationTime));
    }

    @Test
    public void testOverwriteWithSkipCache() throws MojoExecutionException, MojoFailureException, IOException, InterruptedException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello")));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
            this.setVariableValueToObject(m, "skipCache", false);
            this.setVariableValueToObject(m, "overwrite", true);
            this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
        }).execute();
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello"));
        Path outputPath = this.outputDirectory.resolve(OUTPUT_FILE_NAME);
        FileTime firstModificationTime = Files.getLastModifiedTime(outputPath, new LinkOption[0]);
        Thread.sleep(1000L);
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "overwrite", true);
            this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
        }).execute();
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello"));
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(outputPath, new LinkOption[0]), (Matcher)Matchers.not((Object)firstModificationTime));
    }

    @Test
    public void testSignatures() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello, world!\n")));
        new HashMap<String, String>(){
            {
                this.put("md5", "746308829575e17c3331bbcb00c0898b");
                this.put("sha1", "09fac8dbfd27bd9b4d23a00eb648aa751789536d");
                this.put("sha256", "d9014c4624844aa5bac314773d6b689ad467fa4e1d1a50a1b8a99d5a95f72ff5");
                this.put("sha512", "09e1e2a84c92b56c8280f4a1203c7cffd61b162cfe987278d4d6be9afbf38c0e8934cdadf83751f4e99d111352bffefc958e5a4852c8a7a29c95742ce59288a8");
            }
        }.forEach((key, value) -> {
            try {
                this.createMojo(m -> {
                    this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                    this.setVariableValueToObject(m, "skipCache", true);
                    this.setVariableValueToObject(m, "overwrite", true);
                    this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
                    this.setVariableValueToObject(m, (String)key, (Object)value);
                }).execute();
                MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
            }
            catch (IOException | MojoExecutionException | MojoFailureException ex) {
                Throwable rootCause = WGetMojoTest.getRootCause(ex);
                Assert.fail((String)("Execution failed with " + key + " test: " + rootCause + " stack trace:\n" + WGetMojoTest.printStackTrace(rootCause)));
            }
        });
    }

    @Test
    public void testWrongSignatures() throws MojoExecutionException, MojoFailureException, IOException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello, world!\n")));
        Arrays.stream(new String[]{"md5", "sha1", "sha256", "sha512"}).forEach(key -> {
            block2: {
                try {
                    this.createMojo(m -> {
                        this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                        this.setVariableValueToObject(m, "skipCache", true);
                        this.setVariableValueToObject(m, "overwrite", true);
                        this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
                        this.setVariableValueToObject(m, (String)key, (Object)"wrong");
                    }).execute();
                    MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
                    Assert.fail((String)("Execution failed with " + key + " test: accepted an incorrect signature"));
                }
                catch (IOException | MojoExecutionException | MojoFailureException ex) {
                    Throwable rootCause = WGetMojoTest.getRootCause(ex);
                    if (rootCause.getMessage() != null && rootCause.getMessage().contains("Not same digest as expected")) break block2;
                    Assert.fail((String)("Execution failed with " + key + " test: " + rootCause + " stack trace:\n" + WGetMojoTest.printStackTrace(rootCause)));
                }
            }
        });
    }

    private static Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    private static String printStackTrace(Throwable t) {
        return Arrays.stream(t.getStackTrace()).map(StackTraceElement::toString).map(s -> "\t" + s).collect(Collectors.joining("\n"));
    }

    @Test
    public void testExistingFileSignatures() {
        Path outputFile = this.outputDirectory.resolve(OUTPUT_FILE_NAME);
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello, world!\n")));
        new HashMap<String, String>(){
            {
                this.put("md5", "746308829575e17c3331bbcb00c0898b");
                this.put("sha1", "09fac8dbfd27bd9b4d23a00eb648aa751789536d");
                this.put("sha256", "d9014c4624844aa5bac314773d6b689ad467fa4e1d1a50a1b8a99d5a95f72ff5");
                this.put("sha512", "09e1e2a84c92b56c8280f4a1203c7cffd61b162cfe987278d4d6be9afbf38c0e8934cdadf83751f4e99d111352bffefc958e5a4852c8a7a29c95742ce59288a8");
            }
        }.forEach((key, value) -> {
            try {
                Files.write(outputFile, Collections.singletonList("Hello, world!"), new OpenOption[0]);
                this.createMojo(m -> {
                    this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                    this.setVariableValueToObject(m, "skipCache", true);
                    this.setVariableValueToObject(m, "alwaysVerifyChecksum", true);
                    this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
                    this.setVariableValueToObject(m, (String)key, (Object)value);
                }).execute();
                MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
            }
            catch (IOException | MojoExecutionException | MojoFailureException ex) {
                Throwable rootCause = WGetMojoTest.getRootCause(ex);
                Assert.fail((String)("Execution failed with " + key + " test: " + rootCause + " stack trace:\n" + WGetMojoTest.printStackTrace(rootCause)));
            }
        });
    }

    @Test
    public void testWrongSignatureOfExistingFile() {
        Path outputFile = this.outputDirectory.resolve(OUTPUT_FILE_NAME);
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello, world!\n")));
        Log log = (Log)Mockito.spy(SystemStreamLog.class);
        StringBuilder loggedWarningMessages = new StringBuilder();
        ((Log)Mockito.doAnswer(invocation -> loggedWarningMessages.append((CharSequence)invocation.getArgument(0))).when((Object)log)).warn((CharSequence)Mockito.anyString());
        new HashMap<String, String>(){
            {
                this.put("md5", "746308829575e17c3331bbcb00c0898b");
                this.put("sha1", "09fac8dbfd27bd9b4d23a00eb648aa751789536d");
                this.put("sha256", "d9014c4624844aa5bac314773d6b689ad467fa4e1d1a50a1b8a99d5a95f72ff5");
                this.put("sha512", "09e1e2a84c92b56c8280f4a1203c7cffd61b162cfe987278d4d6be9afbf38c0e8934cdadf83751f4e99d111352bffefc958e5a4852c8a7a29c95742ce59288a8");
            }
        }.forEach((key, value) -> {
            block2: {
                try {
                    Files.write(outputFile, Collections.singletonList("wrong"), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                    this.createMojo(m -> {
                        this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                        this.setVariableValueToObject(m, "skipCache", true);
                        this.setVariableValueToObject(m, "alwaysVerifyChecksum", true);
                        this.setVariableValueToObject(m, "outputFileName", OUTPUT_FILE_NAME);
                        this.setVariableValueToObject(m, "log", log);
                        this.setVariableValueToObject(m, (String)key, (Object)value);
                    }).execute();
                    MatcherAssert.assertThat((Object)loggedWarningMessages.toString(), (Matcher)Matchers.containsString((String)"The local version of file output-file doesn't match the expected checksum."));
                }
                catch (IOException | MojoExecutionException | MojoFailureException ex) {
                    Throwable rootCause = WGetMojoTest.getRootCause(ex);
                    if (rootCause.getMessage() != null && rootCause.getMessage().contains("Not same digest as expected")) break block2;
                    Assert.fail((String)("Execution failed with " + key + " test: " + rootCause + " stack trace:\n" + WGetMojoTest.printStackTrace(rootCause)));
                }
            }
        });
    }

    @Test
    public void testBuildShouldFailIfDownloadFails() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.forbidden()));
        try {
            this.createMojo(m -> {
                this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                this.setVariableValueToObject(m, "skipCache", true);
                this.setVariableValueToObject(m, "failOnError", true);
            }).execute();
            Assert.fail((String)"The mojo should have failed upon error");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MojoExecutionException.class)));
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DownloadFailureException.class)));
            MatcherAssert.assertThat((Object)((DownloadFailureException)e.getCause()).getHttpCode(), (Matcher)Matchers.is((Object)403));
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
        }
    }

    @Test
    public void testRetriedAfterDownloadFailsWithCode500() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.serverError()));
        try {
            this.createMojo(m -> {
                this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                this.setVariableValueToObject(m, "skipCache", true);
                this.setVariableValueToObject(m, "failOnError", true);
                this.setVariableValueToObject(m, "retries", 3);
            }).execute();
            Assert.fail((String)"The mojo should have failed upon error");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(MojoExecutionException.class)));
            WireMock.verify((int)3, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
        }
    }

    @Test
    public void testIgnoreDownloadFailure() throws MojoExecutionException, MojoFailureException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.forbidden()));
        try {
            this.createMojo(m -> {
                this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
                this.setVariableValueToObject(m, "skipCache", true);
                this.setVariableValueToObject(m, "failOnError", false);
            }).execute();
            WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
        }
        catch (MojoExecutionException e) {
            if (e.getCause() instanceof DownloadFailureException) {
                Assert.fail((String)"Plugin should ignore a download failure");
            }
            throw e;
        }
    }

    @Test
    public void testShouldNotRetrySuccessfulDownload() throws MojoExecutionException, MojoFailureException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)"Hello, world!\n")));
        this.createMojo(m -> {
            this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl()));
            this.setVariableValueToObject(m, "skipCache", true);
            this.setVariableValueToObject(m, "failOnError", true);
            this.setVariableValueToObject(m, "retries", 3);
        }).execute();
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.anyUrl()));
    }

    @Test
    public void testShouldCacheLargeFiles() throws Exception {
        CachingHttpClientBuilder firstAnswer = WGetMojoTest.createClientBuilderForResponse(() -> new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "Ok"){
            {
                try {
                    this.setEntity((HttpEntity)new StringEntity("Hello, world!\n"));
                    this.setHeader("Content-Length", String.valueOf(Long.MAX_VALUE));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try (MockedStatic httpClientBuilder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
            httpClientBuilder.when(CachingHttpClientBuilder::create).thenReturn((Object)firstAnswer);
            this.createMojo(mojo -> {}).execute();
        }
        CachingHttpClientBuilder secondAnswer = WGetMojoTest.createClientBuilder(() -> "Goodbye!");
        try (MockedStatic httpClientBuilder = Mockito.mockStatic(CachingHttpClientBuilder.class);){
            httpClientBuilder.when(CachingHttpClientBuilder::create).thenReturn((Object)secondAnswer);
            this.createMojo(mojo -> this.setVariableValueToObject(mojo, "overwrite", true)).execute();
        }
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
    }

    private void testRedirect(int code) {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/" + code))).willReturn(WireMock.aResponse().withStatus(code).withHeader("Location", new String[]{"/hello"})));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hello")).willReturn(WireMock.ok((String)"Hello, world!\n")));
        try {
            this.createMojo(m -> {
                this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl() + "/" + code));
                this.setVariableValueToObject(m, "skipCache", true);
            }).execute();
            MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputDirectory.resolve(OUTPUT_FILE_NAME))), (Matcher)Matchers.is((Object)"Hello, world!"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testShouldFollowRedirects() {
        IntStream.of(301, 302, 303).forEach(this::testRedirect);
    }

    private void testNoRedirects(int code) {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/" + code))).willReturn(WireMock.aResponse().withStatus(code).withHeader("Location", new String[]{"/hello"})));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/hello")).willReturn(WireMock.ok((String)"Hello, world!\n")));
        Log log = (Log)Mockito.spy(SystemStreamLog.class);
        StringBuilder loggedWarningMessages = new StringBuilder();
        ((Log)Mockito.doAnswer(invocation -> loggedWarningMessages.append((CharSequence)invocation.getArgument(0))).when((Object)log)).warn((CharSequence)Mockito.anyString());
        try {
            this.createMojo(m -> {
                this.setVariableValueToObject(m, "log", log);
                this.setVariableValueToObject(m, "followRedirects", false);
                this.setVariableValueToObject(m, "uri", URI.create(this.wireMock.baseUrl() + "/" + code));
                this.setVariableValueToObject(m, "skipCache", true);
            }).execute();
            MatcherAssert.assertThat((Object)loggedWarningMessages.toString(), (Matcher)Matchers.containsString((String)("Download failed with code " + code)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testShouldWarnOnRedirectsIfDisabled() {
        IntStream.of(301, 302, 303).forEach(this::testNoRedirects);
    }
}

