/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.googlecode.download.maven.plugin.internal.DownloadFailureException;
import com.googlecode.download.maven.plugin.internal.HttpFileRequester;
import com.googlecode.download.maven.plugin.internal.LoggingProgressReport;
import com.googlecode.download.maven.plugin.internal.ProgressReport;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;

public class HttpFileRequesterTest {
    @Rule
    public TemporaryFolder outputDirectory = new TemporaryFolder();
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)WireMockConfiguration.options().dynamicPort());
    private File outputFile;
    private static final Log LOG = new SystemStreamLog();
    private static final String OUTPUT_FILE_NAME = "output-file";

    @Before
    public void setUp() throws Exception {
        this.outputFile = new File(this.outputDirectory.getRoot(), OUTPUT_FILE_NAME);
    }

    private HttpFileRequester.Builder createFileRequesterBuilder() throws Exception {
        class MavenSessionStub
        extends MavenSession {
            MavenSessionStub() {
                super(null, (MavenExecutionRequest)Mockito.mock(MavenExecutionRequest.class), null, new LinkedList());
            }
        }
        return new HttpFileRequester.Builder().withProgressReport((ProgressReport)new LoggingProgressReport(LOG)).withConnectTimeout(3000).withSocketTimeout(3000).withUri(new URI(this.wireMock.baseUrl())).withRedirectsEnabled(false).withPreemptiveAuth(false).withCacheDir(null).withLog(LOG).withMavenSession((MavenSession)new MavenSessionStub());
    }

    @Test
    public void testNoAuth() throws Exception {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok().withBody("Hello, world!")));
        this.createFileRequesterBuilder().build().download(this.outputFile, Collections.emptyList());
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputFile.toPath())), (Matcher)Matchers.is((Object)"Hello, world!"));
    }

    @Test
    public void testBasicAuth() throws Exception {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.unauthorized().withHeader("WWW-Authenticate", new String[]{"Basic"})));
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).withBasicAuth("billg", "hunter2").willReturn(WireMock.ok().withBody("Hello, world!")));
        this.createFileRequesterBuilder().withUsername("billg").withPassword("hunter2").build().download(this.outputFile, Collections.emptyList());
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputFile.toPath())), (Matcher)Matchers.is((Object)"Hello, world!"));
    }

    @Test
    public void testBasicAuthPreempt() throws Exception {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).withBasicAuth("billg", "hunter2").willReturn(WireMock.ok().withBody("Hello, world!")));
        this.createFileRequesterBuilder().withUsername("billg").withPassword("hunter2").withPreemptiveAuth(true).build().download(this.outputFile, Collections.emptyList());
        MatcherAssert.assertThat((Object)String.join((CharSequence)"", Files.readAllLines(this.outputFile.toPath())), (Matcher)Matchers.is((Object)"Hello, world!"));
    }

    @Test
    public void testDownloadFailure() {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.forbidden()));
        try {
            this.createFileRequesterBuilder().build().download(this.outputFile, Collections.emptyList());
            Assert.fail((String)"A DownloadFailureException should have been thrown");
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.is((Matcher)Matchers.instanceOf(DownloadFailureException.class)));
        }
    }
}

