/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.templating.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.infrastructurebuilder.templating.AbstractTemplatingEngine;
import org.infrastructurebuilder.util.IBUtils;

public class VelocityExecutionComponent
extends AbstractTemplatingEngine<VelocityEngine> {
    static final VelocityContext createContext(Optional<MavenProject> project, Map<String, Object> properties) {
        VelocityContext context = new VelocityContext();
        context.put("project", project.orElse(null));
        Properties oo = project.isPresent() ? project.get().getProperties() : new Properties();
        for (Map.Entry<Object, Object> e2 : oo.entrySet()) {
            String propName = ((String)e2.getKey()).replace('.', '_');
            String propValue = (String)e2.getValue();
            context.put(propName, (Object)propValue);
        }
        if (properties != null) {
            properties.entrySet().forEach(e -> context.put((String)e.getKey(), e.getValue()));
        }
        return context;
    }

    public VelocityExecutionComponent(Path src, Path sourcePathRoot, boolean includeDotFiles, Optional<Log> log, Optional<Collection<String>> sourceExtensions, Path sourceOutputDir, MavenProject project, boolean includeHiddenFiles, boolean caseSensitive, Optional<Path> prefixPath, Supplier<Map<String, Object>> properties) {
        super(src, sourcePathRoot, includeDotFiles, log, sourceExtensions, sourceOutputDir, project, includeHiddenFiles, caseSensitive, prefixPath, properties);
    }

    public final VelocityEngine createEngine(Path sourcePathRoot) throws Exception {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("resource.default_encoding", (Object)"UTF-8");
        ve.setProperty("velocimacro.inline.replace_global", (Object)"true");
        ve.setProperty("velocimacro.inline.local_scope", (Object)"false");
        ve.setProperty("velocimacro.context.localscope", (Object)"false");
        ve.setProperty("runtime.strict_mode.enable", (Object)"false");
        ve.setProperty("resource.loader.file.path", (Object)sourcePathRoot.toString());
        ve.init();
        return ve;
    }

    public void writeTemplate(VelocityEngine engine, String canoTemplate, Path outFile) throws Exception {
        VelocityContext _context = VelocityExecutionComponent.createContext(this.getProject(), this.getProperties());
        try (StringWriter out = new StringWriter();){
            Path p = this.getSourcePathRoot();
            boolean quoteComments = true;
            String quoted = VelocityExecutionComponent.quoteSharpsInComments((String)IBUtils.readFile((Path)p.resolve(canoTemplate)));
            engine.evaluate((Context)_context, (Writer)out, "velocity", quoted);
            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
            IBUtils.writeString((Path)outFile, (String)VelocityExecutionComponent.unquoteSharpsInComments((String)out.toString()));
        }
    }
}

