/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.configuration.management.impl.ansible;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.infrastructurebuilder.configuration.management.IBRValidator;
import org.infrastructurebuilder.configuration.management.ansible.DefaultAnsibleIBRValidator;
import org.infrastructurebuilder.configuration.management.ansible.DefaultAnsibleValidator;
import org.infrastructurebuilder.ibr.utils.AutomationUtils;
import org.infrastructurebuilder.ibr.utils.AutomationUtilsTesting;
import org.infrastructurebuilder.util.core.IBUtils;
import org.infrastructurebuilder.util.core.TestingPathSupplier;
import org.infrastructurebuilder.util.executor.DefaultVersionedProcessExecutionFactory;
import org.infrastructurebuilder.util.executor.VersionedProcessExecutionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultAnsibleIBRValidator {
    private static final TestingPathSupplier wps = new TestingPathSupplier();
    private VersionedProcessExecutionFactory vpef = new DefaultVersionedProcessExecutionFactory(wps.get(), Optional.empty());
    private AutomationUtils ibr = new AutomationUtilsTesting();
    private Path target;
    private IBRValidator test;
    PlexusContainer container;
    Path fileA;
    Path fileB;
    Path fileC;
    Path fileD;
    Path fileE;
    Path fileF;
    Path fileG;
    Path fileH;
    Path targetEmptyDirectory;
    Path targetEmptySubfolder;
    Path targetPath;
    Path targetSneakyNotDirectory;

    @After
    public void after() {
        this.fileH.toFile().setReadable(true);
        for (Path p : Arrays.asList(this.targetPath, this.targetEmptyDirectory, this.targetEmptySubfolder, this.targetSneakyNotDirectory)) {
            IBUtils.deletePath((Path)p);
        }
    }

    @Before
    public void beforeClass() throws IOException, PlexusContainerException, ComponentLookupException {
        this.target = wps.getRoot();
        this.targetPath = this.vpef.getScratchDir();
        this.targetEmptyDirectory = this.target.resolve(UUID.randomUUID().toString());
        this.targetEmptySubfolder = this.target.resolve(UUID.randomUUID().toString());
        this.targetSneakyNotDirectory = this.target.resolve(UUID.randomUUID().toString());
        Path targetEmptySubfolderAnsible = this.targetEmptySubfolder.resolve("ansible");
        Path ansiblePath = this.targetPath.resolve("ansible");
        Files.createDirectories(ansiblePath, new FileAttribute[0]);
        Path subDir = ansiblePath.resolve("subdir");
        Path subDir2 = subDir.resolve("subdir2");
        Path subDir3 = subDir2.resolve("subdir3");
        this.fileA = ansiblePath.resolve("a.yml");
        this.fileB = ansiblePath.resolve("b.yml");
        this.fileC = Paths.get(ansiblePath.toString(), "/c.yml");
        this.fileD = Paths.get(subDir.toString(), "/d.yml");
        this.fileE = Paths.get(subDir.toString(), "/e.yml");
        this.fileF = Paths.get(subDir3.toString(), "/f.yml");
        this.fileG = Paths.get(subDir3.toString(), "/g.yml");
        this.fileH = Paths.get(subDir3.toString(), "/h.yml");
        Path fileSneakyMasquerader = Paths.get(this.targetSneakyNotDirectory.toString(), new String[0]);
        FileUtils.copyDirectoryToDirectory((File)this.target.resolve("test-classes").resolve("ansible").toFile(), (File)this.targetPath.toFile());
        for (Path p : Arrays.asList(this.targetEmptyDirectory, this.targetEmptySubfolder, targetEmptySubfolderAnsible)) {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        Files.write(fileSneakyMasquerader, "".getBytes(), new OpenOption[0]);
        this.fileH.toFile().setReadable(false);
        this.test = new DefaultAnsibleIBRValidator(this.ibr, new DefaultAnsibleValidator(this.vpef));
    }

    @Test
    public void testDirectoryValidatorAlternate() {
        Map<Path, Optional> result = Arrays.asList(this.fileA, this.fileB, this.fileC, this.fileD, this.fileE, this.fileF, this.fileG, this.fileH).stream().flatMap(t -> this.test.validate(t).stream()).collect(Collectors.toMap(k -> k.getPath(), v -> v.getException()));
        Assert.assertEquals((String)"Map size should be 8", (long)8L, (long)result.size());
        Optional res = result.get(this.fileA);
        if (res.isPresent()) {
            // empty if block
        }
        Assert.assertFalse((String)"Good file should have empty exception list", (boolean)res.isPresent());
        for (Path a : Arrays.asList(this.fileB, this.fileC, this.fileD, this.fileE, this.fileF, this.fileG, this.fileH)) {
            Assert.assertTrue((String)("Bad file should be present in list " + a), (boolean)result.containsKey(a));
            Assert.assertTrue((String)("Bad file should have exception " + a), (boolean)result.get(a).isPresent());
        }
    }

    @Test
    public void testEmptyDirectoryValidator() {
        Set result = this.test.validate(this.targetEmptyDirectory);
        Assert.assertEquals((String)"Result size should be one", (long)1L, (long)result.size());
        result.forEach(output -> Assert.assertFalse((String)"Empty directory should have an exception", (boolean)output.isValid()));
    }

    @Test
    public void testEmptySubfolderValidator() {
        Set result = this.test.validate(this.targetEmptySubfolder);
        Assert.assertEquals((String)"Result size should be one", (long)1L, (long)result.size());
        result.forEach(output -> Assert.assertFalse((String)"Empty directory should have an exception", (boolean)output.isValid()));
    }

    @Test
    public void testFileMasqueradingAsDirectoryFailsValidation() {
        Set result = this.test.validate(this.targetSneakyNotDirectory);
        Assert.assertEquals((String)"Result size should be one", (long)1L, (long)result.size());
        result.forEach(output -> Assert.assertFalse((String)"Empty directory should have an exception", (boolean)output.isValid()));
    }

    @Test
    public void testNonexistentDirectoryValidator() {
        Path nonexistent = Paths.get("/non/existent/path", new String[0]);
        Set result = this.test.validate(nonexistent);
        result.forEach(output -> Assert.assertFalse((String)"Nonexistent directory should fail validation", (boolean)output.isValid()));
    }
}

