/*
 * Decompiled with CFR 0.152.
 */
package org.infrastructurebuilder.configuration.management.ansible;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.infrastructurebuilder.configuration.management.DefaultIBConfigSupplier;
import org.infrastructurebuilder.configuration.management.IBConfigSupplier;
import org.infrastructurebuilder.configuration.management.ansible.AnsibleIBRType;
import org.infrastructurebuilder.configuration.management.ansible.DefaultAnsibleIBRValidator;
import org.infrastructurebuilder.configuration.management.ansible.DefaultAnsibleValidator;
import org.infrastructurebuilder.ibr.utils.AutomationUtils;
import org.infrastructurebuilder.ibr.utils.AutomationUtilsTesting;
import org.infrastructurebuilder.imaging.DefaultFakeImageData;
import org.infrastructurebuilder.util.core.IBUtils;
import org.infrastructurebuilder.util.core.TestingPathSupplier;
import org.infrastructurebuilder.util.executor.DefaultVersionedProcessExecutionFactory;
import org.infrastructurebuilder.util.executor.VersionedProcessExecutionFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class AnsibleIBRTypeTest {
    private static final TestingPathSupplier wps = new TestingPathSupplier();
    private VersionedProcessExecutionFactory vpef = new DefaultVersionedProcessExecutionFactory(wps.get(), Optional.empty());
    private IBConfigSupplier acs;
    private Map<String, String> params;
    private AutomationUtilsTesting rps;
    private AnsibleIBRType t;

    @Before
    public void setUp() throws Exception {
        this.rps = new AutomationUtilsTesting();
        this.acs = new DefaultIBConfigSupplier().setConfig(new HashMap());
        this.t = new AnsibleIBRType((AutomationUtils)this.rps, Arrays.asList(new DefaultAnsibleIBRValidator((AutomationUtils)this.rps, new DefaultAnsibleValidator(this.vpef))));
        this.t.setConfigSupplier(this.acs);
        Assert.assertNotNull((Object)this.t);
    }

    @Test
    public void testGetValidators() {
        Assert.assertFalse((this.t.getValidators().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTransformToProvisionerEntry() throws JSONException, IOException {
        Path p = Paths.get("abc.xml", new String[0]).toAbsolutePath();
        JSONObject j = new JSONObject(IBUtils.readToString((InputStream)this.getClass().getResourceAsStream("/testCMType.json")));
        JSONObject g = this.t.transformToProvisionerEntry("ansible", null, p, null, Collections.emptyList());
        JSONAssert.assertEquals((JSONObject)j, (JSONObject)g, (boolean)true);
    }

    @Test
    public void testTransformToProvisionerEntryWithOverrides() throws JSONException, IOException {
        Path p = Paths.get("abc.xml", new String[0]).toAbsolutePath();
        JSONObject j = new JSONObject("{\"type\":\"ansible\",\"playbook_file\":\"../../abc.xml\",\"override\":{\"test\":{\"user\":\"X\"}}}");
        JSONObject g = this.t.transformToProvisionerEntry("ansible", null, p, null, Arrays.asList(new DefaultFakeImageData("amazon-ebs", Optional.of("X"))));
        JSONAssert.assertEquals((JSONObject)j, (JSONObject)g, (boolean)true);
    }
}

