/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor.tests;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoReserved;
import org.infinispan.protostream.annotations.ProtoReservedStatements;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.protostream.annotations.impl.processor.tests.AllFieldTypesInitializerImpl;
import org.infinispan.protostream.annotations.impl.processor.tests.ImmutableMessageTestInitializerImpl;
import org.infinispan.protostream.annotations.impl.processor.tests.NonNullRepeatedFieldsInitializerImpl;
import org.infinispan.protostream.annotations.impl.processor.tests.ReusableInitializer;
import org.infinispan.protostream.annotations.impl.processor.tests.TestInitializer;
import org.infinispan.protostream.annotations.impl.processor.tests.TestSerializationContextInitializerImpl;
import org.infinispan.protostream.annotations.impl.processor.tests.testdomain.SimpleClass;
import org.infinispan.protostream.annotations.impl.processor.tests.testdomain.SimpleEnum;
import org.junit.Assert;
import org.junit.Test;

public class AutoProtoSchemaBuilderTest {
    @Test
    public void testGeneratedInitializer() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestSerializationContextInitializerImpl serCtxInitializer = new TestSerializationContextInitializerImpl();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)ctx.canMarshall(Note.class));
        Assert.assertTrue((boolean)ctx.canMarshall("firstTestPackage.NoteMsg"));
        ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)new Note());
        Assert.assertTrue((boolean)ctx.canMarshall(SimpleClass.class));
    }

    @Test
    public void testGeneratedService() {
        Object initializer = null;
        for (SerializationContextInitializer sci : ServiceLoader.load(SerializationContextInitializer.class)) {
            if (!(sci instanceof SecondInitializer)) continue;
            initializer = (SecondInitializer)sci;
            break;
        }
        Assert.assertNotNull((String)"SecondInitializer implementation not found by ServiceLoader", initializer);
        Assert.assertEquals((Object)"org.infinispan.protostream.annotations.impl.processor.tests.TestInitializer", (Object)initializer.getClass().getName());
    }

    @Test
    public void testLocalAnnotatedClassesAreSkipped() {
        for (SerializationContextInitializer sci : ServiceLoader.load(SerializationContextInitializer.class)) {
            if (!sci.getClass().getSimpleName().equals("NeverEverGenerated")) continue;
            Assert.fail((String)"Local classes should not be processed by AutoProtoSchemaBuilderAnnotationProcessor.");
        }
    }

    @Test
    public void testNonAbstractInitializer() {
        boolean found = false;
        for (SerializationContextInitializer sci : ServiceLoader.load(SerializationContextInitializer.class)) {
            if (!sci.getClass().getSimpleName().equals("NonAbstractInitializerImpl")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"Non-abstract initializers must be supported", (boolean)found);
    }

    @Test
    public void testDependsOn() throws Exception {
        DependentInitializer dependentInitializer = null;
        for (SerializationContextInitializer sci : ServiceLoader.load(SerializationContextInitializer.class)) {
            if (!(sci instanceof DependentInitializer)) continue;
            dependentInitializer = (DependentInitializer)sci;
            break;
        }
        Assert.assertNotNull((String)"DependentInitializer implementation not found by ServiceLoader", dependentInitializer);
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        dependentInitializer.registerSchema(ctx);
        dependentInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)ctx.canMarshall(ReusableInitializer.A.class));
        Assert.assertTrue((boolean)ctx.canMarshall(ReusableInitializer.B.class));
        Assert.assertTrue((boolean)ctx.canMarshall(DependentInitializer.C.class));
    }

    @Test
    public void testAllFieldTypes() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        AllFieldTypesInitializerImpl serCtxInitializer = new AllFieldTypesInitializerImpl();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)ctx.canMarshall(MessageWithAllFieldTypes.class));
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)new MessageWithAllFieldTypes());
        Object o = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertTrue((boolean)(o instanceof MessageWithAllFieldTypes));
    }

    @Test
    public void testNonNullRepeatedFields() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        NonNullRepeatedFieldsInitializerImpl serCtxInitializer = new NonNullRepeatedFieldsInitializerImpl();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)new MessageWithRepeatedFields());
        MessageWithRepeatedFields o = (MessageWithRepeatedFields)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertNotNull((Object)o);
        Assert.assertNotNull((Object)o.testField1);
        Assert.assertEquals((long)0L, (long)o.testField1.length);
        Assert.assertNotNull((Object)o.testField2);
        Assert.assertEquals((long)0L, (long)o.testField2.length);
        Assert.assertNotNull(o.testField3);
        Assert.assertEquals((long)0L, (long)o.testField3.size());
        Assert.assertNotNull((Object)o.testField4);
        Assert.assertEquals((long)0L, (long)o.testField4.length);
        Assert.assertNotNull(o.testField5);
        Assert.assertEquals((long)0L, (long)o.testField5.size());
        Assert.assertNotNull((Object)o.testField6);
        Assert.assertEquals((long)0L, (long)o.testField6.length);
        Assert.assertNotNull((Object)o.testField7);
        Assert.assertEquals((long)0L, (long)o.testField7.length);
        Assert.assertNotNull(o.testField8);
        Assert.assertEquals((long)0L, (long)o.testField8.size());
        Assert.assertNotNull((Object)o.testField9);
        Assert.assertEquals((long)0L, (long)o.testField9.length);
        Assert.assertNotNull(o.testField10);
        Assert.assertEquals((long)0L, (long)o.testField10.size());
    }

    @Test
    public void testFactoryMethod() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        ImmutableMessageTestInitializerImpl serCtxInitializer = new ImmutableMessageTestInitializerImpl();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)serCtxInitializer.getProtoFile().contains("message RGBColor"));
        Assert.assertTrue((boolean)serCtxInitializer.getProtoFile().contains("message ImmutableColor"));
        RGBColor color = new RGBColor(55, 66, 77);
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)color);
        RGBColor o = (RGBColor)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((long)55L, (long)o.r);
        Assert.assertEquals((long)66L, (long)o.g);
        Assert.assertEquals((long)77L, (long)o.b);
    }

    @Test
    public void testNoAnnotatedFields() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestInitializer serCtxInitializer = new TestInitializer();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)serCtxInitializer.getProtoFile().contains("message NoFields {\n}\n"));
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)new NoProtoFields());
        Object o = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertTrue((boolean)(o instanceof NoProtoFields));
    }

    @Test
    public void testNonStandardPropertyAccessors() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestInitializer serCtxInitializer = new TestInitializer();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)serCtxInitializer.getProtoFile().contains("message NonStandardPropertyAccessors"));
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)new NonStandardPropertyAccessors());
        Object o = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertTrue((boolean)(o instanceof NonStandardPropertyAccessors));
    }

    @Test
    public void testCustomMap() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestInitializer serCtxInitializer = new TestInitializer();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)serCtxInitializer.getProtoFile().contains("message CustomMap"));
        HashMap<CustomMap.CustomKey, String> myMap = new HashMap<CustomMap.CustomKey, String>();
        myMap.put(new CustomMap.CustomKey("k"), "v");
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)new CustomMap(myMap));
        CustomMap o = (CustomMap)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o.getMyMap() instanceof HashMap));
        Assert.assertEquals((Object)"v", (Object)o.getMyMap().get(new CustomMap.CustomKey("k")));
    }

    @Test
    public void testOptional() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        TestInitializer serCtxInitializer = new TestInitializer();
        serCtxInitializer.registerSchema(ctx);
        serCtxInitializer.registerMarshallers(ctx);
        Assert.assertTrue((boolean)serCtxInitializer.getProtoFile().contains("message Optionals"));
        Optionals opt = new Optionals();
        opt.field1 = "abc";
        opt.field2 = new Optionals.OptionalInner();
        ((Optionals)opt).field2.theString = "xyz";
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)opt);
        Optionals o = (Optionals)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)"abc", (Object)o.field1);
        Assert.assertNotNull((Object)o.field2);
        Assert.assertEquals((Object)"xyz", (Object)((Optionals)o).field2.theString);
    }

    @Test
    public void testGenericMessage() throws Exception {
        SerializationContext ctx = ProtobufUtil.newSerializationContext();
        String schema = new ProtoSchemaBuilder().fileName("generic_message.proto").addClass(GenericMessage.class).addClass(GenericMessage.OtherMessage.class).build(ctx);
        Assert.assertTrue((boolean)schema.contains("message GenericMessage"));
        GenericMessage genericMessage = new GenericMessage();
        genericMessage.field1 = new WrappedMessage((Object)3.1415);
        genericMessage.field2 = new WrappedMessage((Object)"qwerty".getBytes());
        genericMessage.field3 = new WrappedMessage((Object)new WrappedMessage((Object)"azerty"));
        genericMessage.field4 = new WrappedMessage((Object)new GenericMessage.OtherMessage("asdfg"));
        byte[] bytes = ProtobufUtil.toWrappedByteArray((ImmutableSerializationContext)ctx, (Object)genericMessage);
        GenericMessage o = (GenericMessage)ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)ctx, (byte[])bytes);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals(Double.class, genericMessage.field1.getValue().getClass());
        Assert.assertEquals((Object)3.1415, (Object)genericMessage.field1.getValue());
        Assert.assertArrayEquals((byte[])"qwerty".getBytes(), (byte[])((byte[])genericMessage.field2.getValue()));
        Assert.assertEquals((Object)"azerty", (Object)((WrappedMessage)genericMessage.field3.getValue()).getValue());
        Assert.assertEquals((Object)"asdfg", (Object)((GenericMessage.OtherMessage)genericMessage.field4.getValue()).field1);
    }

    static final class GenericMessage {
        @ProtoField(number=1)
        WrappedMessage field1;
        @ProtoField(number=2)
        WrappedMessage field2;
        @ProtoField(number=3)
        WrappedMessage field3;
        @ProtoField(number=4)
        WrappedMessage field4;

        GenericMessage() {
        }

        static final class OtherMessage {
            @ProtoField(number=1)
            String field1;

            @ProtoFactory
            public OtherMessage(String field1) {
                this.field1 = field1;
            }
        }
    }

    static class Optionals {
        private String field1;
        private OptionalInner field2;
        private OptionalInner[] field3;
        private List<OptionalInner> field4;

        Optionals() {
        }

        @ProtoField(number=1)
        public Optional<String> getField1() {
            return Optional.ofNullable(this.field1);
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        @ProtoField(number=2)
        public Optional<OptionalInner> getField2() {
            return Optional.ofNullable(this.field2);
        }

        public void setField2(OptionalInner field2) {
            this.field2 = field2;
        }

        @ProtoField(number=3)
        public Optional<OptionalInner[]> getField3() {
            return Optional.ofNullable(this.field3);
        }

        public void setField3(OptionalInner[] field3) {
            this.field3 = field3;
        }

        @ProtoField(number=4)
        public Optional<List<OptionalInner>> getField4() {
            return Optional.ofNullable(this.field4);
        }

        public void setField4(List<OptionalInner> field4) {
            this.field4 = field4;
        }

        static class OptionalInner {
            @ProtoField(number=1)
            String theString;

            OptionalInner() {
            }
        }
    }

    static class CustomMap {
        private Map<CustomKey, String> myMap;

        CustomMap() {
        }

        CustomMap(Map<CustomKey, String> myMap) {
            this.myMap = myMap;
        }

        public Map<CustomKey, String> getMyMap() {
            return this.myMap;
        }

        @ProtoField(number=1)
        public List<KVPair> getMapEntries() {
            if (this.myMap == null) {
                return Collections.emptyList();
            }
            ArrayList<KVPair> pairs = new ArrayList<KVPair>(this.myMap.size());
            for (Map.Entry<CustomKey, String> e : this.myMap.entrySet()) {
                pairs.add(new KVPair(e));
            }
            return pairs;
        }

        public void setMapEntries(List<KVPair> entries) {
            this.myMap = new HashMap<CustomKey, String>();
            entries.forEach(p -> this.myMap.put(p.key, p.value));
        }

        static class KVPair {
            @ProtoField(number=1)
            CustomKey key;
            @ProtoField(number=2)
            String value;

            KVPair() {
            }

            KVPair(Map.Entry<CustomKey, String> entry) {
                this.key = entry.getKey();
                this.value = entry.getValue();
            }
        }

        static class CustomKey {
            @ProtoField(number=1)
            String key;

            CustomKey() {
            }

            CustomKey(String key) {
                this.key = key;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CustomKey customKey = (CustomKey)o;
                return this.key != null ? this.key.equals(customKey.key) : customKey.key == null;
            }

            public int hashCode() {
                return this.key != null ? this.key.hashCode() : 0;
            }
        }
    }

    static class NonStandardPropertyAccessors {
        private long ttl;
        private long timestamp;

        NonStandardPropertyAccessors() {
        }

        @ProtoField(number=1, defaultValue="100")
        public long ttl() {
            return this.ttl;
        }

        public void ttl(long ttl) {
            this.ttl = ttl;
        }

        public long timestamp() {
            return this.timestamp;
        }

        @ProtoField(number=2, defaultValue="0")
        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }

    @ProtoName(value="NoFields")
    static class NoProtoFields {
        NoProtoFields() {
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={RGBColor.class, ImmutableColor.class})
    static interface ImmutableMessageTestInitializer
    extends SerializationContextInitializer {
    }

    static final class ImmutableColor {
        @ProtoField(number=1, defaultValue="1")
        byte r;
        byte g;
        byte[] b;
        @ProtoField(number=12, defaultValue="12")
        List<Integer> i;
        @ProtoField(number=13, defaultValue="13")
        int[] j;

        public void setR(byte r) {
            this.r = r;
        }

        public void setG(byte g) {
            this.g = g;
        }

        public void setB(byte[] b) {
            this.b = b;
        }

        public void setI(List<Integer> i) {
            this.i = i;
        }

        public void setJ(int[] j) {
            this.j = j;
        }

        private ImmutableColor(byte r, byte g, byte[] b, List<Integer> i, int[] j) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.i = i;
            this.j = j;
        }

        @ProtoFactory
        static ImmutableColor make(byte r, byte g, byte[] b, List<Integer> i, int[] j) {
            return new ImmutableColor(r, g, b, i, j);
        }

        @ProtoField(number=2, defaultValue="2")
        byte getG() {
            return this.g;
        }

        @ProtoField(number=3, defaultValue="3")
        byte[] getB() {
            return this.b;
        }
    }

    static final class RGBColor {
        private final int r;
        private final int g;
        private final int b;

        @ProtoFactory
        public RGBColor(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        @ProtoField(number=1, defaultValue="-1")
        public int getR() {
            return this.r;
        }

        @ProtoField(number=2, defaultValue="-1")
        public int getG() {
            return this.g;
        }

        @ProtoField(number=3, defaultValue="-1")
        public int getB() {
            return this.b;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={MessageWithRepeatedFields.class, MessageWithRepeatedFields.Inner.class})
    static interface NonNullRepeatedFieldsInitializer
    extends SerializationContextInitializer {
    }

    static class MessageWithRepeatedFields {
        @ProtoField(number=1001)
        byte[] testField1001;
        @ProtoField(number=1002)
        Byte[] testField1002;
        @ProtoField(number=1003)
        List<Byte> testField1003;
        @ProtoField(number=1)
        int[] testField1;
        @ProtoField(number=2)
        Integer[] testField2;
        @ProtoField(number=3, collectionImplementation=MyArrayList.class)
        List<Integer> testField3;
        @ProtoField(number=4)
        Inner[] testField4;
        @ProtoField(number=5)
        List<Inner> testField5;
        int[] testField6;
        Integer[] testField7;
        List<Integer> testField8;
        Inner[] testField9;
        List<Inner> testField10;

        MessageWithRepeatedFields() {
        }

        @ProtoField(number=6)
        public int[] getTestField6() {
            return this.testField6;
        }

        public void setTestField6(int[] testField6) {
            this.testField6 = testField6;
        }

        @ProtoField(number=7)
        public Integer[] getTestField7() {
            return this.testField7;
        }

        public void setTestField7(Integer[] testField7) {
            this.testField7 = testField7;
        }

        @ProtoField(number=8)
        public List<Integer> getTestField8() {
            return this.testField8;
        }

        public void setTestField8(List<Integer> testField8) {
            this.testField8 = testField8;
        }

        @ProtoField(number=9)
        public Inner[] getTestField9() {
            return this.testField9;
        }

        public void setTestField9(Inner[] testField9) {
            this.testField9 = testField9;
        }

        @ProtoField(number=10)
        public List<Inner> getTestField10() {
            return this.testField10;
        }

        public void setTestField10(List<Inner> testField10) {
            this.testField10 = testField10;
        }

        static class Inner {
            @ProtoField(number=1, required=true)
            int intField;

            Inner() {
            }
        }

        static class MyArrayList
        extends ArrayList {
            MyArrayList() {
            }
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={MessageWithAllFieldTypes.class})
    static interface AllFieldTypesInitializer
    extends SerializationContextInitializer {
    }

    static class MessageWithAllFieldTypes {
        @ProtoField(number=1, defaultValue="A")
        char testField1;
        @ProtoField(number=2, defaultValue="A")
        char[] testField2 = new char[]{'a', 'b'};
        @ProtoField(number=3, defaultValue="A")
        Character testField3 = Character.valueOf('a');
        @ProtoField(number=4, defaultValue="A")
        Character[] testField4 = new Character[]{Character.valueOf('a'), Character.valueOf('b')};
        @ProtoField(number=5, defaultValue="A")
        boolean testField5;
        @ProtoField(number=6, defaultValue="true")
        boolean[] testField6 = new boolean[]{true, true};
        @ProtoField(number=7, defaultValue="true")
        Boolean testField7 = true;
        @ProtoField(number=8, defaultValue="true")
        Boolean[] testField8 = new Boolean[]{true, true};
        @ProtoField(number=9, defaultValue="100")
        short testField9;
        @ProtoField(number=10, defaultValue="100")
        short[] testField10 = new short[]{1, 2};
        @ProtoField(number=11, defaultValue="100")
        Short testField11 = 1;
        @ProtoField(number=12, defaultValue="100")
        Short[] testField12 = new Short[]{(short)1, (short)2};
        @ProtoField(number=13, defaultValue="100.5")
        float testField13;
        @ProtoField(number=14, defaultValue="100.5")
        float[] testField14 = new float[]{3.14f, 3.15f};
        @ProtoField(number=15, defaultValue="100.5")
        Float testField15 = Float.valueOf(3.14f);
        @ProtoField(number=16, defaultValue="100.5")
        Float[] testField16 = new Float[]{Float.valueOf(3.14f), Float.valueOf(3.15f)};
        @ProtoField(number=17, defaultValue="100.5")
        double testField17;
        @ProtoField(number=18, defaultValue="100.5")
        double[] testField18;
        @ProtoField(number=19, defaultValue="100.5")
        Double testField19 = 3.14;
        @ProtoField(number=20, defaultValue="100.5")
        Double[] testField20 = new Double[]{3.14, 3.15};
        @ProtoField(number=21, defaultValue="100")
        int testField21;
        @ProtoField(number=22, defaultValue="100")
        int[] testField22;
        @ProtoField(number=23, defaultValue="100")
        Integer testField23 = 1;
        @ProtoField(number=24, defaultValue="100")
        Integer[] testField24 = new Integer[]{1, 2};
        @ProtoField(number=25, defaultValue="100")
        long testField25;
        @ProtoField(number=26, defaultValue="100")
        long[] testField26 = new long[]{1L, 2L};
        @ProtoField(number=27, defaultValue="100")
        Long testField27 = 1L;
        @ProtoField(number=28, defaultValue="100")
        Long[] testField28 = new Long[]{1L, 2L};
        @ProtoField(number=29, defaultValue="xyz")
        String testField29 = "test";
        @ProtoField(number=30, defaultValue="xyz")
        String[] testField30 = new String[]{"one", "two"};
        @ProtoField(number=31, defaultValue="1")
        Date testField31 = new Date(100L);
        @ProtoField(number=32, defaultValue="1")
        Date[] testField32 = new Date[]{new Date(100L), new Date(200L)};
        @ProtoField(number=33, defaultValue="1")
        Instant testField33 = Instant.ofEpochMilli(100L);
        @ProtoField(number=34, defaultValue="1")
        Instant[] testField34 = new Instant[]{Instant.ofEpochMilli(100L), Instant.ofEpochMilli(200L)};
        @ProtoField(number=35, defaultValue="35")
        byte[] testField35 = new byte[]{1, 2, 3};
        @ProtoField(number=36, defaultValue="36")
        Byte[] testField36 = new Byte[]{(byte)1, (byte)2, (byte)3};
        private char testField51;
        private char[] testField52 = new char[]{'a', 'b'};
        private Character testField53 = Character.valueOf('a');
        private Character[] testField54 = new Character[]{Character.valueOf('a'), Character.valueOf('b')};
        private boolean testField55;
        private boolean[] testField56 = new boolean[]{true, true};
        private Boolean testField57 = true;
        private Boolean[] testField58 = new Boolean[]{true, true};
        private short testField59;
        private short[] testField60 = new short[]{1, 2};
        private Short testField61 = 1;
        private Short[] testField62 = new Short[]{(short)1, (short)2};
        private float testField63;
        private float[] testField64 = new float[]{3.14f, 3.15f};
        private Float testField65 = Float.valueOf(3.14f);
        private Float[] testField66 = new Float[]{Float.valueOf(3.14f), Float.valueOf(3.15f)};
        private double testField67;
        private double[] testField68;
        private Double testField69 = 3.14;
        private Double[] testField70 = new Double[]{3.14, 3.15};
        private int testField71;
        private int[] testField72;
        private Integer testField73 = 1;
        private Integer[] testField74 = new Integer[]{1, 2};
        private long testField75;
        private long[] testField76 = new long[]{1L, 2L};
        private Long testField77 = 1L;
        private Long[] testField78 = new Long[]{1L, 2L};
        private String testField79 = "test";
        private String[] testField80 = new String[]{"one", "two"};
        private Date testField81 = new Date(100L);
        private Date[] testField82 = new Date[]{new Date(100L), new Date(200L)};
        private Instant testField83 = Instant.ofEpochMilli(100L);
        private Instant[] testField84 = new Instant[]{Instant.ofEpochMilli(100L), Instant.ofEpochMilli(200L)};
        private byte[] testField85 = new byte[]{1, 2, 3};
        private Byte[] testField86 = new Byte[]{(byte)1, (byte)2, (byte)3};

        MessageWithAllFieldTypes() {
        }

        @ProtoField(number=51, defaultValue="A")
        public char getTestField51() {
            return this.testField51;
        }

        public void setTestField51(char testField51) {
            this.testField51 = testField51;
        }

        @ProtoField(number=52, defaultValue="A")
        public char[] getTestField52() {
            return this.testField52;
        }

        public void setTestField52(char[] testField52) {
            this.testField52 = testField52;
        }

        @ProtoField(number=53, defaultValue="A")
        public Character getTestField53() {
            return this.testField53;
        }

        public void setTestField53(Character testField53) {
            this.testField53 = testField53;
        }

        @ProtoField(number=54, defaultValue="A")
        public Character[] getTestField54() {
            return this.testField54;
        }

        public void setTestField54(Character[] testField54) {
            this.testField54 = testField54;
        }

        @ProtoField(number=55, defaultValue="A")
        public boolean isTestField55() {
            return this.testField55;
        }

        public void setTestField55(boolean testField55) {
            this.testField55 = testField55;
        }

        @ProtoField(number=56, defaultValue="true")
        public boolean[] getTestField56() {
            return this.testField56;
        }

        public void setTestField56(boolean[] testField56) {
            this.testField56 = testField56;
        }

        @ProtoField(number=57, defaultValue="true")
        public Boolean getTestField57() {
            return this.testField57;
        }

        public void setTestField57(Boolean testField57) {
            this.testField57 = testField57;
        }

        @ProtoField(number=58, defaultValue="true")
        public Boolean[] getTestField58() {
            return this.testField58;
        }

        public void setTestField58(Boolean[] testField58) {
            this.testField58 = testField58;
        }

        @ProtoField(number=59, defaultValue="100")
        public short getTestField59() {
            return this.testField59;
        }

        public void setTestField59(short testField59) {
            this.testField59 = testField59;
        }

        @ProtoField(number=60, defaultValue="100")
        public short[] getTestField60() {
            return this.testField60;
        }

        public void setTestField60(short[] testField60) {
            this.testField60 = testField60;
        }

        @ProtoField(number=61, defaultValue="100")
        public Short getTestField61() {
            return this.testField61;
        }

        public void setTestField61(Short testField61) {
            this.testField61 = testField61;
        }

        @ProtoField(number=62, defaultValue="100")
        public Short[] getTestField62() {
            return this.testField62;
        }

        public void setTestField62(Short[] testField62) {
            this.testField62 = testField62;
        }

        @ProtoField(number=63, defaultValue="100.5")
        public float getTestField63() {
            return this.testField63;
        }

        public void setTestField63(float testField63) {
            this.testField63 = testField63;
        }

        @ProtoField(number=64, defaultValue="100.5")
        public float[] getTestField64() {
            return this.testField64;
        }

        public void setTestField64(float[] testField64) {
            this.testField64 = testField64;
        }

        @ProtoField(number=65, defaultValue="100.5")
        public Float getTestField65() {
            return this.testField65;
        }

        public void setTestField65(Float testField65) {
            this.testField65 = testField65;
        }

        @ProtoField(number=66, defaultValue="100.5")
        public Float[] getTestField66() {
            return this.testField66;
        }

        public void setTestField66(Float[] testField66) {
            this.testField66 = testField66;
        }

        @ProtoField(number=67, defaultValue="100.5")
        public double getTestField67() {
            return this.testField67;
        }

        public void setTestField67(double testField67) {
            this.testField67 = testField67;
        }

        @ProtoField(number=68, defaultValue="100.5")
        public double[] getTestField68() {
            return this.testField68;
        }

        public void setTestField68(double[] testField68) {
            this.testField68 = testField68;
        }

        @ProtoField(number=69, defaultValue="100.5")
        public Double getTestField69() {
            return this.testField69;
        }

        public void setTestField69(Double testField69) {
            this.testField69 = testField69;
        }

        @ProtoField(number=70, defaultValue="100.5")
        public Double[] getTestField70() {
            return this.testField70;
        }

        public void setTestField70(Double[] testField70) {
            this.testField70 = testField70;
        }

        @ProtoField(number=71, defaultValue="100")
        public int getTestField71() {
            return this.testField71;
        }

        public void setTestField71(int testField71) {
            this.testField71 = testField71;
        }

        @ProtoField(number=72, defaultValue="100")
        public int[] getTestField72() {
            return this.testField72;
        }

        public void setTestField72(int[] testField72) {
            this.testField72 = testField72;
        }

        @ProtoField(number=73, defaultValue="100")
        public Integer getTestField73() {
            return this.testField73;
        }

        public void setTestField73(Integer testField73) {
            this.testField73 = testField73;
        }

        @ProtoField(number=74, defaultValue="100")
        public Integer[] getTestField74() {
            return this.testField74;
        }

        public void setTestField74(Integer[] testField74) {
            this.testField74 = testField74;
        }

        @ProtoField(number=75, defaultValue="100")
        public long getTestField75() {
            return this.testField75;
        }

        public void setTestField75(long testField75) {
            this.testField75 = testField75;
        }

        @ProtoField(number=76, defaultValue="100")
        public long[] getTestField76() {
            return this.testField76;
        }

        public void setTestField76(long[] testField76) {
            this.testField76 = testField76;
        }

        @ProtoField(number=77, defaultValue="100")
        public Long getTestField77() {
            return this.testField77;
        }

        public void setTestField77(Long testField77) {
            this.testField77 = testField77;
        }

        @ProtoField(number=78, defaultValue="100")
        public Long[] getTestField78() {
            return this.testField78;
        }

        public void setTestField78(Long[] testField78) {
            this.testField78 = testField78;
        }

        @ProtoField(number=79, defaultValue="xyz")
        public String getTestField79() {
            return this.testField79;
        }

        public void setTestField79(String testField79) {
            this.testField79 = testField79;
        }

        @ProtoField(number=80, defaultValue="xyz")
        public String[] getTestField80() {
            return this.testField80;
        }

        public void setTestField80(String[] testField80) {
            this.testField80 = testField80;
        }

        @ProtoField(number=81, defaultValue="1")
        public Date getTestField81() {
            return this.testField81;
        }

        public void setTestField81(Date testField81) {
            this.testField81 = testField81;
        }

        @ProtoField(number=82, defaultValue="1")
        public Date[] getTestField82() {
            return this.testField82;
        }

        public void setTestField82(Date[] testField82) {
            this.testField82 = testField82;
        }

        @ProtoField(number=83, defaultValue="1")
        public Instant getTestField83() {
            return this.testField83;
        }

        public void setTestField83(Instant testField83) {
            this.testField83 = testField83;
        }

        @ProtoField(number=84, defaultValue="1")
        public Instant[] getTestField84() {
            return this.testField84;
        }

        public void setTestField84(Instant[] testField84) {
            this.testField84 = testField84;
        }

        @ProtoField(number=85, defaultValue="85")
        public byte[] getTestField85() {
            return this.testField85;
        }

        public void setTestField85(byte[] testField85) {
            this.testField85 = testField85;
        }

        @ProtoField(number=86, defaultValue="86")
        public Byte[] getTestField86() {
            return this.testField86;
        }

        public void setTestField86(Byte[] testField86) {
            this.testField86 = testField86;
        }
    }

    @AutoProtoSchemaBuilder(dependsOn={ReusableInitializer.class}, includeClasses={C.class}, service=true)
    public static interface DependentInitializer
    extends SerializationContextInitializer {

        public static class C {
            @ProtoField(number=1, required=true)
            public boolean flag;
            @ProtoField(number=2)
            public ReusableInitializer.A a;
        }
    }

    @AutoProtoSchemaBuilder(className="NonAbstractInitializerImpl", autoImportClasses=true, basePackages={"org.infinispan.protostream.annotations.impl.processor"}, service=true)
    static class NonAbstractInitializer
    implements SerializationContextInitializer {
        NonAbstractInitializer() {
        }

        public String getProtoFileName() {
            return null;
        }

        public String getProtoFile() {
            return null;
        }

        public void registerSchema(SerializationContext serCtx) {
        }

        public void registerMarshallers(SerializationContext serCtx) {
        }
    }

    @AutoProtoSchemaBuilder(schemaFilePath="second_initializer", className="TestInitializer", autoImportClasses=true, basePackages={"org.infinispan.protostream.annotations.impl.processor"}, service=true)
    static abstract class SecondInitializer
    implements SerializationContextInitializer {
        SecondInitializer() {
        }
    }

    @AutoProtoSchemaBuilder(schemaFileName="TestFile.proto", schemaFilePath="org/infinispan/protostream/generated_schemas", schemaPackageName="firstTestPackage", service=true, includeClasses={Note.class, SimpleClass.class, SimpleClass.class, ByteBufferImpl.class, EmbeddedMetadata.EmbeddedLifespanExpirableMetadata.class, SimpleEnum.class, X.class})
    static interface TestSerializationContextInitializer
    extends SerializationContextInitializer {
    }

    public static class EmbeddedMetadata {
        private String version;

        @ProtoField(number=1)
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public static class EmbeddedLifespanExpirableMetadata
        extends EmbeddedMetadata {
            @ProtoField(number=2, defaultValue="-1")
            long lifespan;
        }
    }

    static class X {
        @ProtoField(number=1, name="__someByte")
        public byte[] someBytes;
        @ProtoField(number=2, name="__someShorts")
        public short[] someShorts;
        @ProtoField(number=3, name="__someFloats")
        public float[] someFloats;
        @ProtoField(number=4, name="__someInts")
        public List<Integer> someInts;
        private ByteBufferImpl buffer;

        X() {
        }

        @ProtoField(number=5, name="value", javaType=ByteBufferImpl.class)
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        public void setBuffer(ByteBuffer buffer) {
            this.buffer = (ByteBufferImpl)buffer;
        }
    }

    @ProtoReserved(ranges={@ProtoReserved.Range(from=45, to=54)})
    static class ByteBufferImpl
    implements ByteBuffer {
        private byte[] bytes;

        ByteBufferImpl() {
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }
    }

    @ProtoReservedStatements(value={@ProtoReserved(value={42}), @ProtoReserved(ranges={@ProtoReserved.Range(from=55)}), @ProtoReserved(names={"oldBytes", "ancientByteArray"})})
    static interface ByteBuffer {
        @ProtoField(number=1, name="theBytes")
        public byte[] getBytes();
    }

    @ProtoDoc(value="This is the documentation")
    @ProtoName(value="NoteMsg")
    public static class Note {
        @ProtoField(number=1, required=true)
        boolean flag;
        private String text;

        @ProtoField(number=2)
        public String getText() {
            return this.text;
        }

        void setText(String text) {
            this.text = text;
        }
    }
}

