/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Map;
import java.util.Set;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.AbstractMarshallerCodeGenerator;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.AnnotatedClassScanner;
import org.infinispan.protostream.annotations.impl.processor.AnnotationBasedImportedProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.MarshallerSourceCodeGenerator;
import org.infinispan.protostream.annotations.impl.types.UnifiedTypeFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.descriptors.FileDescriptor;

final class CompileTimeProtoSchemaGenerator
extends BaseProtoSchemaGenerator {
    private final Map<XClass, String> dependencies;
    private final MarshallerSourceCodeGenerator marshallerSourceCodeGenerator;
    private final AnnotatedClassScanner classScanner;

    CompileTimeProtoSchemaGenerator(UnifiedTypeFactory typeFactory, GeneratedFilesWriter generatedFilesWriter, SerializationContext serializationContext, String generator, String fileName, String packageName, Map<XClass, String> dependencies, Set<XClass> classes, boolean autoImportClasses, AnnotatedClassScanner classScanner) {
        super(typeFactory, serializationContext, generator, fileName, packageName, classes, autoImportClasses);
        this.dependencies = dependencies;
        this.marshallerSourceCodeGenerator = new MarshallerSourceCodeGenerator(generatedFilesWriter, typeFactory, packageName);
        this.classScanner = classScanner;
    }

    protected AbstractMarshallerCodeGenerator makeCodeGenerator() {
        return this.marshallerSourceCodeGenerator;
    }

    protected ProtoTypeMetadata importProtoTypeMetadata(XClass javaType) {
        String fileName = this.dependencies.get(javaType);
        if (fileName != null) {
            String packageName = ((FileDescriptor)this.serializationContext.getFileDescriptors().get(fileName)).getPackage();
            return new AnnotationBasedImportedProtoTypeMetadata(this.makeProtoTypeMetadata(javaType), packageName, fileName);
        }
        return null;
    }

    protected boolean isUnknownClass(XClass c) {
        boolean isUnknownClass;
        boolean bl = isUnknownClass = !this.dependencies.containsKey(c) && super.isUnknownClass(c);
        if (isUnknownClass) {
            if (!this.classScanner.isClassIncluded(c.getCanonicalName())) {
                throw new ProtoSchemaBuilderException("Found a reference to class " + c.getName() + " which was not explicitly included by the @AutoProtoSchemaBuilder and the annotation attributes do not allow it to be included.");
            }
            isUnknownClass = false;
        }
        return isUnknownClass;
    }

    public Set<String> getGeneratedMarshallerClasses() {
        return this.marshallerSourceCodeGenerator.getGeneratedClasses();
    }
}

