package org.immutables.generator.processor;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Transformers.generator", "Trees"})
public abstract class TreesTransformer {
  protected TreesTransformer() {}

  public ImmutableTrees.Else toElse(ImmutableTrees.Else value) {
    return value;
  }

  public ImmutableTrees.SimpleAccessExpression toSimpleAccessExpression(ImmutableTrees.SimpleAccessExpression value) {
    return value
        .withPath(asSimpleAccessExpressionPathElements(value, value.path()));
  }

  protected Iterable<Trees.Identifier> asSimpleAccessExpressionPathElements(ImmutableTrees.SimpleAccessExpression value, List<Trees.Identifier> elements) {
    Collection<Trees.Identifier> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.Identifier original : elements) {
      Trees.Identifier changed = asSimpleAccessExpressionPath(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.Identifier asSimpleAccessExpressionPath(ImmutableTrees.SimpleAccessExpression value, Trees.Identifier attribute) {
    if (attribute instanceof ImmutableTrees.Identifier) {
      return asIdentifier((ImmutableTrees.Identifier) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.LetEnd toLetEnd(ImmutableTrees.LetEnd value) {
    return value;
  }

  public ImmutableTrees.LetStatement toLetStatement(ImmutableTrees.LetStatement value) {
    return value
        .withParts(asLetStatementPartsElements(value, value.parts()))
        .withDeclaration(asLetStatementDeclaration(value, value.declaration()));
  }

  protected Iterable<Trees.TemplatePart> asLetStatementPartsElements(ImmutableTrees.LetStatement value, List<Trees.TemplatePart> elements) {
    Collection<Trees.TemplatePart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TemplatePart original : elements) {
      Trees.TemplatePart changed = asLetStatementParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TemplatePart asLetStatementParts(ImmutableTrees.LetStatement value, Trees.TemplatePart attribute) {
    if (attribute instanceof ImmutableTrees.Else) {
      return asTemplatePart((ImmutableTrees.Else) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetEnd) {
      return asTemplatePart((ImmutableTrees.LetEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asTemplatePart((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextLine) {
      return asTemplatePart((ImmutableTrees.TextLine) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asTemplatePart((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Comment) {
      return asTemplatePart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfStatement) {
      return asTemplatePart((ImmutableTrees.IfStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Let) {
      return asTemplatePart((ImmutableTrees.Let) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asTemplatePart((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asTemplatePart((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForEnd) {
      return asTemplatePart((ImmutableTrees.ForEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.ElseIf) {
      return asTemplatePart((ImmutableTrees.ElseIf) attribute);
    }
    if (attribute instanceof ImmutableTrees.If) {
      return asTemplatePart((ImmutableTrees.If) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeString) {
      return asTemplatePart((ImmutableTrees.InvokeString) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeEnd) {
      return asTemplatePart((ImmutableTrees.InvokeEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.TemplateEnd) {
      return asTemplatePart((ImmutableTrees.TemplateEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfEnd) {
      return asTemplatePart((ImmutableTrees.IfEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.Invoke) {
      return asTemplatePart((ImmutableTrees.Invoke) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextBlock) {
      return asTemplatePart((ImmutableTrees.TextBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asTemplatePart((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asTemplatePart((ImmutableTrees.SimpleBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.For) {
      return asTemplatePart((ImmutableTrees.For) attribute);
    }
    return attribute;
  }

  protected Trees.InvokableDeclaration asLetStatementDeclaration(ImmutableTrees.LetStatement value, Trees.InvokableDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.InvokableDeclaration) {
      return asInvokableDeclaration((ImmutableTrees.InvokableDeclaration) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.TextLine toTextLine(ImmutableTrees.TextLine value) {
    return value
        .withFragment(asTextLineFragment(value, value.fragment()))
        .withNewline(asTextLineNewline(value, value.newline()));
  }

  protected Trees.TextFragment asTextLineFragment(ImmutableTrees.TextLine value, Trees.TextFragment attribute) {
    if (attribute instanceof ImmutableTrees.TextFragment) {
      return asTextFragment((ImmutableTrees.TextFragment) attribute);
    }
    return attribute;
  }

  protected boolean asTextLineNewline(ImmutableTrees.TextLine value, boolean attribute) {
    return attribute;
  }

  public ImmutableTrees.TypeDeclaration toTypeDeclaration(ImmutableTrees.TypeDeclaration value) {
    return value
        .withType(asTypeDeclarationType(value, value.type()))
        .withKind(asTypeDeclarationKind(value, value.kind()));
  }

  protected Trees.TypeIdentifier asTypeDeclarationType(ImmutableTrees.TypeDeclaration value, Trees.TypeIdentifier attribute) {
    if (attribute instanceof ImmutableTrees.TypeIdentifier) {
      return asTypeIdentifier((ImmutableTrees.TypeIdentifier) attribute);
    }
    return attribute;
  }

  protected Trees.TypeDeclaration.Kind asTypeDeclarationKind(ImmutableTrees.TypeDeclaration value, Trees.TypeDeclaration.Kind attribute) {
    return attribute;
  }

  public ImmutableTrees.ForStatement toForStatement(ImmutableTrees.ForStatement value) {
    return value
        .withUseForAccess(asForStatementUseForAccess(value, value.useForAccess()))
        .withUseDelimit(asForStatementUseDelimit(value, value.useDelimit()))
        .withDeclaration(asForStatementDeclarationElements(value, value.declaration()))
        .withParts(asForStatementPartsElements(value, value.parts()));
  }

  protected boolean asForStatementUseForAccess(ImmutableTrees.ForStatement value, boolean attribute) {
    return attribute;
  }

  protected boolean asForStatementUseDelimit(ImmutableTrees.ForStatement value, boolean attribute) {
    return attribute;
  }

  protected Iterable<Trees.GeneratorDeclaration> asForStatementDeclarationElements(ImmutableTrees.ForStatement value, List<Trees.GeneratorDeclaration> elements) {
    Collection<Trees.GeneratorDeclaration> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.GeneratorDeclaration original : elements) {
      Trees.GeneratorDeclaration changed = asForStatementDeclaration(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.GeneratorDeclaration asForStatementDeclaration(ImmutableTrees.ForStatement value, Trees.GeneratorDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.IterationGenerator) {
      return asGeneratorDeclaration((ImmutableTrees.IterationGenerator) attribute);
    }
    if (attribute instanceof ImmutableTrees.AssignGenerator) {
      return asGeneratorDeclaration((ImmutableTrees.AssignGenerator) attribute);
    }
    if (attribute instanceof ImmutableTrees.TransformGenerator) {
      return asGeneratorDeclaration((ImmutableTrees.TransformGenerator) attribute);
    }
    return attribute;
  }

  protected Iterable<Trees.TemplatePart> asForStatementPartsElements(ImmutableTrees.ForStatement value, List<Trees.TemplatePart> elements) {
    Collection<Trees.TemplatePart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TemplatePart original : elements) {
      Trees.TemplatePart changed = asForStatementParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TemplatePart asForStatementParts(ImmutableTrees.ForStatement value, Trees.TemplatePart attribute) {
    if (attribute instanceof ImmutableTrees.Else) {
      return asTemplatePart((ImmutableTrees.Else) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetEnd) {
      return asTemplatePart((ImmutableTrees.LetEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asTemplatePart((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextLine) {
      return asTemplatePart((ImmutableTrees.TextLine) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asTemplatePart((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Comment) {
      return asTemplatePart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfStatement) {
      return asTemplatePart((ImmutableTrees.IfStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Let) {
      return asTemplatePart((ImmutableTrees.Let) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asTemplatePart((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asTemplatePart((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForEnd) {
      return asTemplatePart((ImmutableTrees.ForEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.ElseIf) {
      return asTemplatePart((ImmutableTrees.ElseIf) attribute);
    }
    if (attribute instanceof ImmutableTrees.If) {
      return asTemplatePart((ImmutableTrees.If) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeString) {
      return asTemplatePart((ImmutableTrees.InvokeString) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeEnd) {
      return asTemplatePart((ImmutableTrees.InvokeEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.TemplateEnd) {
      return asTemplatePart((ImmutableTrees.TemplateEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfEnd) {
      return asTemplatePart((ImmutableTrees.IfEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.Invoke) {
      return asTemplatePart((ImmutableTrees.Invoke) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextBlock) {
      return asTemplatePart((ImmutableTrees.TextBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asTemplatePart((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asTemplatePart((ImmutableTrees.SimpleBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.For) {
      return asTemplatePart((ImmutableTrees.For) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.InvokableDeclaration toInvokableDeclaration(ImmutableTrees.InvokableDeclaration value) {
    return value
        .withParameters(asInvokableDeclarationParametersElements(value, value.parameters()))
        .withName(asInvokableDeclarationName(value, value.name()));
  }

  protected Iterable<Trees.Parameter> asInvokableDeclarationParametersElements(ImmutableTrees.InvokableDeclaration value, List<Trees.Parameter> elements) {
    Collection<Trees.Parameter> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.Parameter original : elements) {
      Trees.Parameter changed = asInvokableDeclarationParameters(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.Parameter asInvokableDeclarationParameters(ImmutableTrees.InvokableDeclaration value, Trees.Parameter attribute) {
    if (attribute instanceof ImmutableTrees.Parameter) {
      return asParameter((ImmutableTrees.Parameter) attribute);
    }
    return attribute;
  }

  protected Trees.Identifier asInvokableDeclarationName(ImmutableTrees.InvokableDeclaration value, Trees.Identifier attribute) {
    if (attribute instanceof ImmutableTrees.Identifier) {
      return asIdentifier((ImmutableTrees.Identifier) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.ValueDeclaration toValueDeclaration(ImmutableTrees.ValueDeclaration value) {
    return value
        .withType(asValueDeclarationTypeOptional(value, value.type()))
        .withContainedType(asValueDeclarationContainedTypeOptional(value, value.containedType()))
        .withName(asValueDeclarationName(value, value.name()));
  }

  protected Optional<Trees.TypeReference> asValueDeclarationTypeOptional(ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
    if (optional.isPresent()) {
      Trees.TypeReference original = optional.get();
      Trees.TypeReference changed = asValueDeclarationType(value, original);
      return changed != original ? Optional.of(changed) : optional;
    }
    return Optional.absent();
  }

  protected Trees.TypeReference asValueDeclarationType(ImmutableTrees.ValueDeclaration value, Trees.TypeReference attribute) {
    if (attribute instanceof ImmutableTrees.TypeDeclaration) {
      return asTypeReference((ImmutableTrees.TypeDeclaration) attribute);
    }
    if (attribute instanceof ImmutableTrees.ResolvedType) {
      return asTypeReference((ImmutableTrees.ResolvedType) attribute);
    }
    return attribute;
  }

  protected Optional<Trees.TypeReference> asValueDeclarationContainedTypeOptional(ImmutableTrees.ValueDeclaration value, Optional<Trees.TypeReference> optional) {
    if (optional.isPresent()) {
      Trees.TypeReference original = optional.get();
      Trees.TypeReference changed = asValueDeclarationContainedType(value, original);
      return changed != original ? Optional.of(changed) : optional;
    }
    return Optional.absent();
  }

  protected Trees.TypeReference asValueDeclarationContainedType(ImmutableTrees.ValueDeclaration value, Trees.TypeReference attribute) {
    if (attribute instanceof ImmutableTrees.TypeDeclaration) {
      return asTypeReference((ImmutableTrees.TypeDeclaration) attribute);
    }
    if (attribute instanceof ImmutableTrees.ResolvedType) {
      return asTypeReference((ImmutableTrees.ResolvedType) attribute);
    }
    return attribute;
  }

  protected Trees.Identifier asValueDeclarationName(ImmutableTrees.ValueDeclaration value, Trees.Identifier attribute) {
    if (attribute instanceof ImmutableTrees.Identifier) {
      return asIdentifier((ImmutableTrees.Identifier) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.Comment toComment(ImmutableTrees.Comment value) {
    return value;
  }

  public ImmutableTrees.IfStatement toIfStatement(ImmutableTrees.IfStatement value) {
    return value
        .withThen(asIfStatementThen(value, value.then()))
        .withOtherwiseIf(asIfStatementOtherwiseIfElements(value, value.otherwiseIf()))
        .withOtherwise(asIfStatementOtherwiseOptional(value, value.otherwise()));
  }

  protected Trees.ConditionalBlock asIfStatementThen(ImmutableTrees.IfStatement value, Trees.ConditionalBlock attribute) {
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asConditionalBlock((ImmutableTrees.ConditionalBlock) attribute);
    }
    return attribute;
  }

  protected Iterable<Trees.ConditionalBlock> asIfStatementOtherwiseIfElements(ImmutableTrees.IfStatement value, List<Trees.ConditionalBlock> elements) {
    Collection<Trees.ConditionalBlock> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.ConditionalBlock original : elements) {
      Trees.ConditionalBlock changed = asIfStatementOtherwiseIf(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.ConditionalBlock asIfStatementOtherwiseIf(ImmutableTrees.IfStatement value, Trees.ConditionalBlock attribute) {
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asConditionalBlock((ImmutableTrees.ConditionalBlock) attribute);
    }
    return attribute;
  }

  protected Optional<Trees.Block> asIfStatementOtherwiseOptional(ImmutableTrees.IfStatement value, Optional<Trees.Block> optional) {
    if (optional.isPresent()) {
      Trees.Block original = optional.get();
      Trees.Block changed = asIfStatementOtherwise(value, original);
      return changed != original ? Optional.of(changed) : optional;
    }
    return Optional.absent();
  }

  protected Trees.Block asIfStatementOtherwise(ImmutableTrees.IfStatement value, Trees.Block attribute) {
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asBlock((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asBlock((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asBlock((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asBlock((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asBlock((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asBlock((ImmutableTrees.SimpleBlock) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.Parameter toParameter(ImmutableTrees.Parameter value) {
    return value
        .withName(asParameterName(value, value.name()))
        .withType(asParameterType(value, value.type()));
  }

  protected Trees.Identifier asParameterName(ImmutableTrees.Parameter value, Trees.Identifier attribute) {
    if (attribute instanceof ImmutableTrees.Identifier) {
      return asIdentifier((ImmutableTrees.Identifier) attribute);
    }
    return attribute;
  }

  protected Trees.TypeReference asParameterType(ImmutableTrees.Parameter value, Trees.TypeReference attribute) {
    if (attribute instanceof ImmutableTrees.TypeDeclaration) {
      return asTypeReference((ImmutableTrees.TypeDeclaration) attribute);
    }
    if (attribute instanceof ImmutableTrees.ResolvedType) {
      return asTypeReference((ImmutableTrees.ResolvedType) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.TextFragment toTextFragment(ImmutableTrees.TextFragment value) {
    return value
        .withValue(asTextFragmentValue(value, value.value()));
  }

  protected String asTextFragmentValue(ImmutableTrees.TextFragment value, String attribute) {
    return attribute;
  }

  public ImmutableTrees.BoundAccessExpression toBoundAccessExpression(ImmutableTrees.BoundAccessExpression value) {
    return value
        .withAccessor(asBoundAccessExpressionAccessorElements(value, value.accessor()))
        .withPath(asBoundAccessExpressionPathElements(value, value.path()));
  }

  protected Iterable<Object> asBoundAccessExpressionAccessorElements(ImmutableTrees.BoundAccessExpression value, List<Object> elements) {
    Collection<Object> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Object original : elements) {
      Object changed = asBoundAccessExpressionAccessor(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Object asBoundAccessExpressionAccessor(ImmutableTrees.BoundAccessExpression value, Object attribute) {
    return attribute;
  }

  protected Iterable<Trees.Identifier> asBoundAccessExpressionPathElements(ImmutableTrees.BoundAccessExpression value, List<Trees.Identifier> elements) {
    Collection<Trees.Identifier> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.Identifier original : elements) {
      Trees.Identifier changed = asBoundAccessExpressionPath(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.Identifier asBoundAccessExpressionPath(ImmutableTrees.BoundAccessExpression value, Trees.Identifier attribute) {
    if (attribute instanceof ImmutableTrees.Identifier) {
      return asIdentifier((ImmutableTrees.Identifier) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.Let toLet(ImmutableTrees.Let value) {
    return value
        .withDeclaration(asLetDeclaration(value, value.declaration()));
  }

  protected Trees.InvokableDeclaration asLetDeclaration(ImmutableTrees.Let value, Trees.InvokableDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.InvokableDeclaration) {
      return asInvokableDeclaration((ImmutableTrees.InvokableDeclaration) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.Template toTemplate(ImmutableTrees.Template value) {
    return value
        .withIsPublic(asTemplateIsPublic(value, value.isPublic()))
        .withParts(asTemplatePartsElements(value, value.parts()))
        .withDeclaration(asTemplateDeclaration(value, value.declaration()));
  }

  protected boolean asTemplateIsPublic(ImmutableTrees.Template value, boolean attribute) {
    return attribute;
  }

  protected Iterable<Trees.TemplatePart> asTemplatePartsElements(ImmutableTrees.Template value, List<Trees.TemplatePart> elements) {
    Collection<Trees.TemplatePart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TemplatePart original : elements) {
      Trees.TemplatePart changed = asTemplateParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TemplatePart asTemplateParts(ImmutableTrees.Template value, Trees.TemplatePart attribute) {
    if (attribute instanceof ImmutableTrees.Else) {
      return asTemplatePart((ImmutableTrees.Else) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetEnd) {
      return asTemplatePart((ImmutableTrees.LetEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asTemplatePart((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextLine) {
      return asTemplatePart((ImmutableTrees.TextLine) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asTemplatePart((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Comment) {
      return asTemplatePart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfStatement) {
      return asTemplatePart((ImmutableTrees.IfStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Let) {
      return asTemplatePart((ImmutableTrees.Let) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asTemplatePart((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asTemplatePart((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForEnd) {
      return asTemplatePart((ImmutableTrees.ForEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.ElseIf) {
      return asTemplatePart((ImmutableTrees.ElseIf) attribute);
    }
    if (attribute instanceof ImmutableTrees.If) {
      return asTemplatePart((ImmutableTrees.If) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeString) {
      return asTemplatePart((ImmutableTrees.InvokeString) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeEnd) {
      return asTemplatePart((ImmutableTrees.InvokeEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.TemplateEnd) {
      return asTemplatePart((ImmutableTrees.TemplateEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfEnd) {
      return asTemplatePart((ImmutableTrees.IfEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.Invoke) {
      return asTemplatePart((ImmutableTrees.Invoke) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextBlock) {
      return asTemplatePart((ImmutableTrees.TextBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asTemplatePart((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asTemplatePart((ImmutableTrees.SimpleBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.For) {
      return asTemplatePart((ImmutableTrees.For) attribute);
    }
    return attribute;
  }

  protected Trees.InvokableDeclaration asTemplateDeclaration(ImmutableTrees.Template value, Trees.InvokableDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.InvokableDeclaration) {
      return asInvokableDeclaration((ImmutableTrees.InvokableDeclaration) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.TypeIdentifier toTypeIdentifier(ImmutableTrees.TypeIdentifier value) {
    return value
        .withValue(asTypeIdentifierValue(value, value.value()));
  }

  protected String asTypeIdentifierValue(ImmutableTrees.TypeIdentifier value, String attribute) {
    return attribute;
  }

  public ImmutableTrees.ConditionalBlock toConditionalBlock(ImmutableTrees.ConditionalBlock value) {
    return value
        .withCondition(asConditionalBlockCondition(value, value.condition()))
        .withParts(asConditionalBlockPartsElements(value, value.parts()));
  }

  protected Trees.Expression asConditionalBlockCondition(ImmutableTrees.ConditionalBlock value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  protected Iterable<Trees.TemplatePart> asConditionalBlockPartsElements(ImmutableTrees.ConditionalBlock value, List<Trees.TemplatePart> elements) {
    Collection<Trees.TemplatePart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TemplatePart original : elements) {
      Trees.TemplatePart changed = asConditionalBlockParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TemplatePart asConditionalBlockParts(ImmutableTrees.ConditionalBlock value, Trees.TemplatePart attribute) {
    if (attribute instanceof ImmutableTrees.Else) {
      return asTemplatePart((ImmutableTrees.Else) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetEnd) {
      return asTemplatePart((ImmutableTrees.LetEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asTemplatePart((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextLine) {
      return asTemplatePart((ImmutableTrees.TextLine) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asTemplatePart((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Comment) {
      return asTemplatePart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfStatement) {
      return asTemplatePart((ImmutableTrees.IfStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Let) {
      return asTemplatePart((ImmutableTrees.Let) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asTemplatePart((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asTemplatePart((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForEnd) {
      return asTemplatePart((ImmutableTrees.ForEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.ElseIf) {
      return asTemplatePart((ImmutableTrees.ElseIf) attribute);
    }
    if (attribute instanceof ImmutableTrees.If) {
      return asTemplatePart((ImmutableTrees.If) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeString) {
      return asTemplatePart((ImmutableTrees.InvokeString) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeEnd) {
      return asTemplatePart((ImmutableTrees.InvokeEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.TemplateEnd) {
      return asTemplatePart((ImmutableTrees.TemplateEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfEnd) {
      return asTemplatePart((ImmutableTrees.IfEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.Invoke) {
      return asTemplatePart((ImmutableTrees.Invoke) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextBlock) {
      return asTemplatePart((ImmutableTrees.TextBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asTemplatePart((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asTemplatePart((ImmutableTrees.SimpleBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.For) {
      return asTemplatePart((ImmutableTrees.For) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.ForEnd toForEnd(ImmutableTrees.ForEnd value) {
    return value;
  }

  public ImmutableTrees.Identifier toIdentifier(ImmutableTrees.Identifier value) {
    return value
        .withValue(asIdentifierValue(value, value.value()));
  }

  protected String asIdentifierValue(ImmutableTrees.Identifier value, String attribute) {
    return attribute;
  }

  public ImmutableTrees.IterationGenerator toIterationGenerator(ImmutableTrees.IterationGenerator value) {
    return value
        .withCondition(asIterationGeneratorConditionOptional(value, value.condition()))
        .withDeclaration(asIterationGeneratorDeclaration(value, value.declaration()))
        .withFrom(asIterationGeneratorFrom(value, value.from()));
  }

  protected Optional<Trees.Expression> asIterationGeneratorConditionOptional(ImmutableTrees.IterationGenerator value, Optional<Trees.Expression> optional) {
    if (optional.isPresent()) {
      Trees.Expression original = optional.get();
      Trees.Expression changed = asIterationGeneratorCondition(value, original);
      return changed != original ? Optional.of(changed) : optional;
    }
    return Optional.absent();
  }

  protected Trees.Expression asIterationGeneratorCondition(ImmutableTrees.IterationGenerator value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  protected Trees.ValueDeclaration asIterationGeneratorDeclaration(ImmutableTrees.IterationGenerator value, Trees.ValueDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.ValueDeclaration) {
      return asValueDeclaration((ImmutableTrees.ValueDeclaration) attribute);
    }
    return attribute;
  }

  protected Trees.Expression asIterationGeneratorFrom(ImmutableTrees.IterationGenerator value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.ElseIf toElseIf(ImmutableTrees.ElseIf value) {
    return value
        .withCondition(asElseIfCondition(value, value.condition()));
  }

  protected Trees.Expression asElseIfCondition(ImmutableTrees.ElseIf value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.If toIf(ImmutableTrees.If value) {
    return value
        .withCondition(asIfCondition(value, value.condition()));
  }

  protected Trees.Expression asIfCondition(ImmutableTrees.If value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.ResolvedType toResolvedType(ImmutableTrees.ResolvedType value) {
    return value
        .withType(asResolvedTypeType(value, value.type()));
  }

  protected Object asResolvedTypeType(ImmutableTrees.ResolvedType value, Object attribute) {
    return attribute;
  }

  public ImmutableTrees.ForIterationAccessExpression toForIterationAccessExpression(ImmutableTrees.ForIterationAccessExpression value) {
    return value
        .withAccess(asForIterationAccessExpressionAccess(value, value.access()))
        .withPath(asForIterationAccessExpressionPathElements(value, value.path()));
  }

  protected Trees.AccessExpression asForIterationAccessExpressionAccess(ImmutableTrees.ForIterationAccessExpression value, Trees.AccessExpression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asAccessExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asAccessExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asAccessExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    return attribute;
  }

  protected Iterable<Trees.Identifier> asForIterationAccessExpressionPathElements(ImmutableTrees.ForIterationAccessExpression value, List<Trees.Identifier> elements) {
    Collection<Trees.Identifier> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.Identifier original : elements) {
      Trees.Identifier changed = asForIterationAccessExpressionPath(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.Identifier asForIterationAccessExpressionPath(ImmutableTrees.ForIterationAccessExpression value, Trees.Identifier attribute) {
    if (attribute instanceof ImmutableTrees.Identifier) {
      return asIdentifier((ImmutableTrees.Identifier) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.InvokeString toInvokeString(ImmutableTrees.InvokeString value) {
    return value
        .withLiteral(asInvokeStringLiteral(value, value.literal()));
  }

  protected Trees.StringLiteral asInvokeStringLiteral(ImmutableTrees.InvokeString value, Trees.StringLiteral attribute) {
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asStringLiteral((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.AssignGenerator toAssignGenerator(ImmutableTrees.AssignGenerator value) {
    return value
        .withDeclaration(asAssignGeneratorDeclaration(value, value.declaration()))
        .withFrom(asAssignGeneratorFrom(value, value.from()));
  }

  protected Trees.ValueDeclaration asAssignGeneratorDeclaration(ImmutableTrees.AssignGenerator value, Trees.ValueDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.ValueDeclaration) {
      return asValueDeclaration((ImmutableTrees.ValueDeclaration) attribute);
    }
    return attribute;
  }

  protected Trees.Expression asAssignGeneratorFrom(ImmutableTrees.AssignGenerator value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.InvokeEnd toInvokeEnd(ImmutableTrees.InvokeEnd value) {
    return value
        .withAccess(asInvokeEndAccess(value, value.access()));
  }

  protected Trees.AccessExpression asInvokeEndAccess(ImmutableTrees.InvokeEnd value, Trees.AccessExpression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asAccessExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asAccessExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asAccessExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.TemplateEnd toTemplateEnd(ImmutableTrees.TemplateEnd value) {
    return value;
  }

  public ImmutableTrees.Unit toUnit(ImmutableTrees.Unit value) {
    return value
        .withParts(asUnitPartsElements(value, value.parts()));
  }

  protected Iterable<Trees.UnitPart> asUnitPartsElements(ImmutableTrees.Unit value, List<Trees.UnitPart> elements) {
    Collection<Trees.UnitPart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.UnitPart original : elements) {
      Trees.UnitPart changed = asUnitParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.UnitPart asUnitParts(ImmutableTrees.Unit value, Trees.UnitPart attribute) {
    if (attribute instanceof ImmutableTrees.Comment) {
      return asUnitPart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asUnitPart((ImmutableTrees.Template) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.IfEnd toIfEnd(ImmutableTrees.IfEnd value) {
    return value;
  }

  public ImmutableTrees.Invoke toInvoke(ImmutableTrees.Invoke value) {
    return value
        .withAccess(asInvokeAccess(value, value.access()))
        .withInvoke(asInvokeInvokeOptional(value, value.invoke()));
  }

  protected Trees.AccessExpression asInvokeAccess(ImmutableTrees.Invoke value, Trees.AccessExpression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asAccessExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asAccessExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asAccessExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    return attribute;
  }

  protected Optional<Trees.ApplyExpression> asInvokeInvokeOptional(ImmutableTrees.Invoke value, Optional<Trees.ApplyExpression> optional) {
    if (optional.isPresent()) {
      Trees.ApplyExpression original = optional.get();
      Trees.ApplyExpression changed = asInvokeInvoke(value, original);
      return changed != original ? Optional.of(changed) : optional;
    }
    return Optional.absent();
  }

  protected Trees.ApplyExpression asInvokeInvoke(ImmutableTrees.Invoke value, Trees.ApplyExpression attribute) {
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asApplyExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.Newline toNewline(ImmutableTrees.Newline value) {
    return value;
  }

  public ImmutableTrees.TextBlock toTextBlock(ImmutableTrees.TextBlock value) {
    return value
        .withParts(asTextBlockPartsElements(value, value.parts()));
  }

  protected Iterable<Trees.TextPart> asTextBlockPartsElements(ImmutableTrees.TextBlock value, List<Trees.TextPart> elements) {
    Collection<Trees.TextPart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TextPart original : elements) {
      Trees.TextPart changed = asTextBlockParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TextPart asTextBlockParts(ImmutableTrees.TextBlock value, Trees.TextPart attribute) {
    if (attribute instanceof ImmutableTrees.TextFragment) {
      return asTextPart((ImmutableTrees.TextFragment) attribute);
    }
    if (attribute instanceof ImmutableTrees.Newline) {
      return asTextPart((ImmutableTrees.Newline) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.InvokeStatement toInvokeStatement(ImmutableTrees.InvokeStatement value) {
    return value
        .withAccess(asInvokeStatementAccess(value, value.access()))
        .withParams(asInvokeStatementParamsElements(value, value.params()))
        .withParts(asInvokeStatementPartsElements(value, value.parts()));
  }

  protected Trees.Expression asInvokeStatementAccess(ImmutableTrees.InvokeStatement value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  protected Iterable<Trees.Expression> asInvokeStatementParamsElements(ImmutableTrees.InvokeStatement value, List<Trees.Expression> elements) {
    Collection<Trees.Expression> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.Expression original : elements) {
      Trees.Expression changed = asInvokeStatementParams(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.Expression asInvokeStatementParams(ImmutableTrees.InvokeStatement value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  protected Iterable<Trees.TemplatePart> asInvokeStatementPartsElements(ImmutableTrees.InvokeStatement value, List<Trees.TemplatePart> elements) {
    Collection<Trees.TemplatePart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TemplatePart original : elements) {
      Trees.TemplatePart changed = asInvokeStatementParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TemplatePart asInvokeStatementParts(ImmutableTrees.InvokeStatement value, Trees.TemplatePart attribute) {
    if (attribute instanceof ImmutableTrees.Else) {
      return asTemplatePart((ImmutableTrees.Else) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetEnd) {
      return asTemplatePart((ImmutableTrees.LetEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asTemplatePart((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextLine) {
      return asTemplatePart((ImmutableTrees.TextLine) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asTemplatePart((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Comment) {
      return asTemplatePart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfStatement) {
      return asTemplatePart((ImmutableTrees.IfStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Let) {
      return asTemplatePart((ImmutableTrees.Let) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asTemplatePart((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asTemplatePart((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForEnd) {
      return asTemplatePart((ImmutableTrees.ForEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.ElseIf) {
      return asTemplatePart((ImmutableTrees.ElseIf) attribute);
    }
    if (attribute instanceof ImmutableTrees.If) {
      return asTemplatePart((ImmutableTrees.If) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeString) {
      return asTemplatePart((ImmutableTrees.InvokeString) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeEnd) {
      return asTemplatePart((ImmutableTrees.InvokeEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.TemplateEnd) {
      return asTemplatePart((ImmutableTrees.TemplateEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfEnd) {
      return asTemplatePart((ImmutableTrees.IfEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.Invoke) {
      return asTemplatePart((ImmutableTrees.Invoke) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextBlock) {
      return asTemplatePart((ImmutableTrees.TextBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asTemplatePart((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asTemplatePart((ImmutableTrees.SimpleBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.For) {
      return asTemplatePart((ImmutableTrees.For) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.ApplyExpression toApplyExpression(ImmutableTrees.ApplyExpression value) {
    return value
        .withParams(asApplyExpressionParamsElements(value, value.params()));
  }

  protected Iterable<Trees.Expression> asApplyExpressionParamsElements(ImmutableTrees.ApplyExpression value, List<Trees.Expression> elements) {
    Collection<Trees.Expression> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.Expression original : elements) {
      Trees.Expression changed = asApplyExpressionParams(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.Expression asApplyExpressionParams(ImmutableTrees.ApplyExpression value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.SimpleBlock toSimpleBlock(ImmutableTrees.SimpleBlock value) {
    return value
        .withParts(asSimpleBlockPartsElements(value, value.parts()));
  }

  protected Iterable<Trees.TemplatePart> asSimpleBlockPartsElements(ImmutableTrees.SimpleBlock value, List<Trees.TemplatePart> elements) {
    Collection<Trees.TemplatePart> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.TemplatePart original : elements) {
      Trees.TemplatePart changed = asSimpleBlockParts(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.TemplatePart asSimpleBlockParts(ImmutableTrees.SimpleBlock value, Trees.TemplatePart attribute) {
    if (attribute instanceof ImmutableTrees.Else) {
      return asTemplatePart((ImmutableTrees.Else) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetEnd) {
      return asTemplatePart((ImmutableTrees.LetEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.LetStatement) {
      return asTemplatePart((ImmutableTrees.LetStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextLine) {
      return asTemplatePart((ImmutableTrees.TextLine) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForStatement) {
      return asTemplatePart((ImmutableTrees.ForStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Comment) {
      return asTemplatePart((ImmutableTrees.Comment) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfStatement) {
      return asTemplatePart((ImmutableTrees.IfStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.Let) {
      return asTemplatePart((ImmutableTrees.Let) attribute);
    }
    if (attribute instanceof ImmutableTrees.Template) {
      return asTemplatePart((ImmutableTrees.Template) attribute);
    }
    if (attribute instanceof ImmutableTrees.ConditionalBlock) {
      return asTemplatePart((ImmutableTrees.ConditionalBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForEnd) {
      return asTemplatePart((ImmutableTrees.ForEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.ElseIf) {
      return asTemplatePart((ImmutableTrees.ElseIf) attribute);
    }
    if (attribute instanceof ImmutableTrees.If) {
      return asTemplatePart((ImmutableTrees.If) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeString) {
      return asTemplatePart((ImmutableTrees.InvokeString) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeEnd) {
      return asTemplatePart((ImmutableTrees.InvokeEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.TemplateEnd) {
      return asTemplatePart((ImmutableTrees.TemplateEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.IfEnd) {
      return asTemplatePart((ImmutableTrees.IfEnd) attribute);
    }
    if (attribute instanceof ImmutableTrees.Invoke) {
      return asTemplatePart((ImmutableTrees.Invoke) attribute);
    }
    if (attribute instanceof ImmutableTrees.TextBlock) {
      return asTemplatePart((ImmutableTrees.TextBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.InvokeStatement) {
      return asTemplatePart((ImmutableTrees.InvokeStatement) attribute);
    }
    if (attribute instanceof ImmutableTrees.SimpleBlock) {
      return asTemplatePart((ImmutableTrees.SimpleBlock) attribute);
    }
    if (attribute instanceof ImmutableTrees.For) {
      return asTemplatePart((ImmutableTrees.For) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.TransformGenerator toTransformGenerator(ImmutableTrees.TransformGenerator value) {
    return value
        .withTransform(asTransformGeneratorTransform(value, value.transform()))
        .withVarDeclaration(asTransformGeneratorVarDeclaration(value, value.varDeclaration()))
        .withCondition(asTransformGeneratorConditionOptional(value, value.condition()))
        .withDeclaration(asTransformGeneratorDeclaration(value, value.declaration()))
        .withFrom(asTransformGeneratorFrom(value, value.from()));
  }

  protected Trees.Expression asTransformGeneratorTransform(ImmutableTrees.TransformGenerator value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  protected Trees.ValueDeclaration asTransformGeneratorVarDeclaration(ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.ValueDeclaration) {
      return asValueDeclaration((ImmutableTrees.ValueDeclaration) attribute);
    }
    return attribute;
  }

  protected Optional<Trees.Expression> asTransformGeneratorConditionOptional(ImmutableTrees.TransformGenerator value, Optional<Trees.Expression> optional) {
    if (optional.isPresent()) {
      Trees.Expression original = optional.get();
      Trees.Expression changed = asTransformGeneratorCondition(value, original);
      return changed != original ? Optional.of(changed) : optional;
    }
    return Optional.absent();
  }

  protected Trees.Expression asTransformGeneratorCondition(ImmutableTrees.TransformGenerator value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  protected Trees.ValueDeclaration asTransformGeneratorDeclaration(ImmutableTrees.TransformGenerator value, Trees.ValueDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.ValueDeclaration) {
      return asValueDeclaration((ImmutableTrees.ValueDeclaration) attribute);
    }
    return attribute;
  }

  protected Trees.Expression asTransformGeneratorFrom(ImmutableTrees.TransformGenerator value, Trees.Expression attribute) {
    if (attribute instanceof ImmutableTrees.SimpleAccessExpression) {
      return asExpression((ImmutableTrees.SimpleAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.BoundAccessExpression) {
      return asExpression((ImmutableTrees.BoundAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ForIterationAccessExpression) {
      return asExpression((ImmutableTrees.ForIterationAccessExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.ApplyExpression) {
      return asExpression((ImmutableTrees.ApplyExpression) attribute);
    }
    if (attribute instanceof ImmutableTrees.StringLiteral) {
      return asExpression((ImmutableTrees.StringLiteral) attribute);
    }
    return attribute;
  }

  public ImmutableTrees.StringLiteral toStringLiteral(ImmutableTrees.StringLiteral value) {
    return value
        .withValue(asStringLiteralValue(value, value.value()));
  }

  protected String asStringLiteralValue(ImmutableTrees.StringLiteral value, String attribute) {
    return attribute;
  }

  public ImmutableTrees.For toFor(ImmutableTrees.For value) {
    return value
        .withDeclaration(asForDeclarationElements(value, value.declaration()));
  }

  protected Iterable<Trees.GeneratorDeclaration> asForDeclarationElements(ImmutableTrees.For value, List<Trees.GeneratorDeclaration> elements) {
    Collection<Trees.GeneratorDeclaration> changedElements = new ArrayList<>(elements.size());
    boolean haveChanged = false;
    for (Trees.GeneratorDeclaration original : elements) {
      Trees.GeneratorDeclaration changed = asForDeclaration(value, original);
      if (changed != original) {
        haveChanged = true;
      }
      changedElements.add(changed);
    }
    return haveChanged ? changedElements : elements;
  }

  protected Trees.GeneratorDeclaration asForDeclaration(ImmutableTrees.For value, Trees.GeneratorDeclaration attribute) {
    if (attribute instanceof ImmutableTrees.IterationGenerator) {
      return asGeneratorDeclaration((ImmutableTrees.IterationGenerator) attribute);
    }
    if (attribute instanceof ImmutableTrees.AssignGenerator) {
      return asGeneratorDeclaration((ImmutableTrees.AssignGenerator) attribute);
    }
    if (attribute instanceof ImmutableTrees.TransformGenerator) {
      return asGeneratorDeclaration((ImmutableTrees.TransformGenerator) attribute);
    }
    return attribute;
  }

  protected Trees.TypeIdentifier asTypeIdentifier(ImmutableTrees.TypeIdentifier value) {
    return toTypeIdentifier(value);
  }

  protected Trees.StringLiteral asStringLiteral(ImmutableTrees.StringLiteral value) {
    return toStringLiteral(value);
  }

  protected Trees.TextPart asTextPart(ImmutableTrees.TextFragment value) {
    return toTextFragment(value);
  }

  protected Trees.TextPart asTextPart(ImmutableTrees.Newline value) {
    return toNewline(value);
  }

  protected Trees.ApplyExpression asApplyExpression(ImmutableTrees.ApplyExpression value) {
    return toApplyExpression(value);
  }

  protected Trees.Identifier asIdentifier(ImmutableTrees.Identifier value) {
    return toIdentifier(value);
  }

  protected Trees.Expression asExpression(ImmutableTrees.BoundAccessExpression value) {
    return toBoundAccessExpression(value);
  }

  protected Trees.Expression asExpression(ImmutableTrees.StringLiteral value) {
    return toStringLiteral(value);
  }

  protected Trees.Expression asExpression(ImmutableTrees.SimpleAccessExpression value) {
    return toSimpleAccessExpression(value);
  }

  protected Trees.Expression asExpression(ImmutableTrees.ApplyExpression value) {
    return toApplyExpression(value);
  }

  protected Trees.Expression asExpression(ImmutableTrees.ForIterationAccessExpression value) {
    return toForIterationAccessExpression(value);
  }

  protected Trees.ConditionalBlock asConditionalBlock(ImmutableTrees.ConditionalBlock value) {
    return toConditionalBlock(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ForEnd value) {
    return toForEnd(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.TextBlock value) {
    return toTextBlock(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.LetEnd value) {
    return toLetEnd(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.TemplateEnd value) {
    return toTemplateEnd(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Else value) {
    return toElse(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.SimpleBlock value) {
    return toSimpleBlock(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeString value) {
    return toInvokeString(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ConditionalBlock value) {
    return toConditionalBlock(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Template value) {
    return toTemplate(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.IfEnd value) {
    return toIfEnd(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ElseIf value) {
    return toElseIf(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Invoke value) {
    return toInvoke(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeStatement value) {
    return toInvokeStatement(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.ForStatement value) {
    return toForStatement(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Comment value) {
    return toComment(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.If value) {
    return toIf(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.IfStatement value) {
    return toIfStatement(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.Let value) {
    return toLet(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.For value) {
    return toFor(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.TextLine value) {
    return toTextLine(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.InvokeEnd value) {
    return toInvokeEnd(value);
  }

  protected Trees.TemplatePart asTemplatePart(ImmutableTrees.LetStatement value) {
    return toLetStatement(value);
  }

  protected Trees.GeneratorDeclaration asGeneratorDeclaration(ImmutableTrees.TransformGenerator value) {
    return toTransformGenerator(value);
  }

  protected Trees.GeneratorDeclaration asGeneratorDeclaration(ImmutableTrees.AssignGenerator value) {
    return toAssignGenerator(value);
  }

  protected Trees.GeneratorDeclaration asGeneratorDeclaration(ImmutableTrees.IterationGenerator value) {
    return toIterationGenerator(value);
  }

  protected Trees.TextFragment asTextFragment(ImmutableTrees.TextFragment value) {
    return toTextFragment(value);
  }

  protected Trees.ValueDeclaration asValueDeclaration(ImmutableTrees.ValueDeclaration value) {
    return toValueDeclaration(value);
  }

  protected Trees.Parameter asParameter(ImmutableTrees.Parameter value) {
    return toParameter(value);
  }

  protected Trees.TypeReference asTypeReference(ImmutableTrees.ResolvedType value) {
    return toResolvedType(value);
  }

  protected Trees.TypeReference asTypeReference(ImmutableTrees.TypeDeclaration value) {
    return toTypeDeclaration(value);
  }

  protected Trees.UnitPart asUnitPart(ImmutableTrees.Template value) {
    return toTemplate(value);
  }

  protected Trees.UnitPart asUnitPart(ImmutableTrees.Comment value) {
    return toComment(value);
  }

  protected Trees.InvokableDeclaration asInvokableDeclaration(ImmutableTrees.InvokableDeclaration value) {
    return toInvokableDeclaration(value);
  }

  protected Trees.Block asBlock(ImmutableTrees.ConditionalBlock value) {
    return toConditionalBlock(value);
  }

  protected Trees.Block asBlock(ImmutableTrees.InvokeStatement value) {
    return toInvokeStatement(value);
  }

  protected Trees.Block asBlock(ImmutableTrees.ForStatement value) {
    return toForStatement(value);
  }

  protected Trees.Block asBlock(ImmutableTrees.Template value) {
    return toTemplate(value);
  }

  protected Trees.Block asBlock(ImmutableTrees.LetStatement value) {
    return toLetStatement(value);
  }

  protected Trees.Block asBlock(ImmutableTrees.SimpleBlock value) {
    return toSimpleBlock(value);
  }

  protected Trees.AccessExpression asAccessExpression(ImmutableTrees.BoundAccessExpression value) {
    return toBoundAccessExpression(value);
  }

  protected Trees.AccessExpression asAccessExpression(ImmutableTrees.SimpleAccessExpression value) {
    return toSimpleAccessExpression(value);
  }

  protected Trees.AccessExpression asAccessExpression(ImmutableTrees.ForIterationAccessExpression value) {
    return toForIterationAccessExpression(value);
  }
}
