package org.immutables.generator.processor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * {@code ImmutableTrees} contains immutable implementation classes generated from
 * abstract value types defined as nested inside {@link Trees}.
 * @see ImmutableTrees.SimpleAccessExpression
 * @see ImmutableTrees.AssignGenerator
 * @see ImmutableTrees.Invoke
 * @see ImmutableTrees.TextFragment
 * @see ImmutableTrees.ForEnd
 * @see ImmutableTrees.TypeDeclaration
 * @see ImmutableTrees.TemplateEnd
 * @see ImmutableTrees.InvokableDeclaration
 * @see ImmutableTrees.ApplyExpression
 * @see ImmutableTrees.Else
 * @see ImmutableTrees.BoundAccessExpression
 * @see ImmutableTrees.InvokeEnd
 * @see ImmutableTrees.LetEnd
 * @see ImmutableTrees.IterationGenerator
 * @see ImmutableTrees.IfStatement
 * @see ImmutableTrees.Unit
 * @see ImmutableTrees.Parameter
 * @see ImmutableTrees.For
 * @see ImmutableTrees.StringLiteral
 * @see ImmutableTrees.Identifier
 * @see ImmutableTrees.InvokeString
 * @see ImmutableTrees.ForStatement
 * @see ImmutableTrees.If
 * @see ImmutableTrees.Template
 * @see ImmutableTrees.TextLine
 * @see ImmutableTrees.Comment
 * @see ImmutableTrees.TextBlock
 * @see ImmutableTrees.LetStatement
 * @see ImmutableTrees.ConditionalBlock
 * @see ImmutableTrees.ElseIf
 * @see ImmutableTrees.ResolvedType
 * @see ImmutableTrees.TypeIdentifier
 * @see ImmutableTrees.InvokeStatement
 * @see ImmutableTrees.Newline
 * @see ImmutableTrees.SimpleBlock
 * @see ImmutableTrees.ValueDeclaration
 * @see ImmutableTrees.IfEnd
 * @see ImmutableTrees.ForIterationAccessExpression
 * @see ImmutableTrees.TransformGenerator
 * @see ImmutableTrees.Let
 */
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "Trees"})
public final class ImmutableTrees {
  private ImmutableTrees() {}

  /**
   * Immutable implementation of {@link Trees.SimpleAccessExpression}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.SimpleAccessExpression.builder()}.
   */
  @Immutable
  public static final class SimpleAccessExpression
      implements Trees.SimpleAccessExpression {
    private final ImmutableList<Trees.Identifier> path;

    private SimpleAccessExpression(ImmutableList<Trees.Identifier> path) {
      this.path = path;
    }

    /**
     * @return The value of the {@code path} attribute
     */
    @Override
    public ImmutableList<Trees.Identifier> path() {
      return path;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.SimpleAccessExpression#path() path}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.SimpleAccessExpression withPath(Trees.Identifier... elements) {
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.SimpleAccessExpression(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.SimpleAccessExpression#path() path}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of path elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.SimpleAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
      if (this.path == elements) return this;
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.SimpleAccessExpression(newValue);
    }

    /**
     * This instance is equal to all instances of {@code SimpleAccessExpression} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.SimpleAccessExpression
          && equalTo((ImmutableTrees.SimpleAccessExpression) another);
    }

    private boolean equalTo(ImmutableTrees.SimpleAccessExpression another) {
      return path.equals(another.path);
    }

    /**
     * Computes a hash code from attributes: {@code path}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + path.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code SimpleAccessExpression} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("SimpleAccessExpression")
          .omitNullValues()
          .add("path", path)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.SimpleAccessExpression} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable SimpleAccessExpression instance
     */
    public static ImmutableTrees.SimpleAccessExpression copyOf(Trees.SimpleAccessExpression instance) {
      if (instance instanceof ImmutableTrees.SimpleAccessExpression) {
        return (ImmutableTrees.SimpleAccessExpression) instance;
      }
      return ImmutableTrees.SimpleAccessExpression.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.SimpleAccessExpression SimpleAccessExpression}.
     * @return A new SimpleAccessExpression builder
     */
    public static ImmutableTrees.SimpleAccessExpression.Builder builder() {
      return new ImmutableTrees.SimpleAccessExpression.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.SimpleAccessExpression SimpleAccessExpression}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Trees.Identifier> path = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.AccessExpression} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.AccessExpression instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.SimpleAccessExpression} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.SimpleAccessExpression instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.AccessExpression) {
          Trees.AccessExpression instance = (Trees.AccessExpression) object;
          addAllPath(instance.path());
        }
      }

      /**
       * Adds one element to {@link Trees.SimpleAccessExpression#path() path} list.
       * @param element A path element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addPath(Trees.Identifier element) {
        this.path.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.SimpleAccessExpression#path() path} list.
       * @param elements An array of path elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addPath(Trees.Identifier... elements) {
        this.path.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.SimpleAccessExpression#path() path} list.
       * @param elements An iterable of path elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder path(Iterable<? extends Trees.Identifier> elements) {
        this.path = ImmutableList.builder();
        return addAllPath(elements);
      }

      /**
       * Adds elements to {@link Trees.SimpleAccessExpression#path() path} list.
       * @param elements An iterable of path elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
        this.path.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.SimpleAccessExpression SimpleAccessExpression}.
       * @return An immutable instance of SimpleAccessExpression
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.SimpleAccessExpression build() {
        return new ImmutableTrees.SimpleAccessExpression(path.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.AssignGenerator}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.AssignGenerator.builder()}.
   */
  @Immutable
  public static final class AssignGenerator implements Trees.AssignGenerator {
    private final Trees.ValueDeclaration declaration;
    private final Trees.Expression from;

    private AssignGenerator(
        Trees.ValueDeclaration declaration,
        Trees.Expression from) {
      this.declaration = declaration;
      this.from = from;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public Trees.ValueDeclaration declaration() {
      return declaration;
    }

    /**
     * @return The value of the {@code from} attribute
     */
    @Override
    public Trees.Expression from() {
      return from;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.AssignGenerator#declaration() declaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for declaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.AssignGenerator withDeclaration(Trees.ValueDeclaration value) {
      if (this.declaration == value) return this;
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value, "declaration");
      return new ImmutableTrees.AssignGenerator(newValue, this.from);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.AssignGenerator#from() from} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for from
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.AssignGenerator withFrom(Trees.Expression value) {
      if (this.from == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "from");
      return new ImmutableTrees.AssignGenerator(this.declaration, newValue);
    }

    /**
     * This instance is equal to all instances of {@code AssignGenerator} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.AssignGenerator
          && equalTo((ImmutableTrees.AssignGenerator) another);
    }

    private boolean equalTo(ImmutableTrees.AssignGenerator another) {
      return declaration.equals(another.declaration)
          && from.equals(another.from);
    }

    /**
     * Computes a hash code from attributes: {@code declaration}, {@code from}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + declaration.hashCode();
      h += (h << 5) + from.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code AssignGenerator} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("AssignGenerator")
          .omitNullValues()
          .add("declaration", declaration)
          .add("from", from)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.AssignGenerator} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AssignGenerator instance
     */
    public static ImmutableTrees.AssignGenerator copyOf(Trees.AssignGenerator instance) {
      if (instance instanceof ImmutableTrees.AssignGenerator) {
        return (ImmutableTrees.AssignGenerator) instance;
      }
      return ImmutableTrees.AssignGenerator.builder()
          .declaration(instance.declaration())
          .from(instance.from())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.AssignGenerator AssignGenerator}.
     * @return A new AssignGenerator builder
     */
    public static ImmutableTrees.AssignGenerator.Builder builder() {
      return new ImmutableTrees.AssignGenerator.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.AssignGenerator AssignGenerator}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_DECLARATION = 0x1L;
      private static final long INIT_BIT_FROM = 0x2L;
      private long initBits = 0x3L;

      private @Nullable Trees.ValueDeclaration declaration;
      private @Nullable Trees.Expression from;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Trees.AssignGenerator#declaration() declaration} attribute.
       * @param declaration The value for declaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Trees.ValueDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration, "declaration");
        initBits &= ~INIT_BIT_DECLARATION;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.AssignGenerator#from() from} attribute.
       * @param from The value for from 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Expression from) {
        this.from = Preconditions.checkNotNull(from, "from");
        initBits &= ~INIT_BIT_FROM;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.AssignGenerator AssignGenerator}.
       * @return An immutable instance of AssignGenerator
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.AssignGenerator build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.AssignGenerator(declaration, from);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_DECLARATION) != 0) attributes.add("declaration");
        if ((initBits & INIT_BIT_FROM) != 0) attributes.add("from");
        return "Cannot build AssignGenerator, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Invoke}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.Invoke.builder()}.
   */
  @Immutable
  public static final class Invoke implements Trees.Invoke {
    private final Trees.AccessExpression access;
    private final Optional<Trees.ApplyExpression> invoke;

    private Invoke(
        Trees.AccessExpression access,
        Optional<Trees.ApplyExpression> invoke) {
      this.access = access;
      this.invoke = invoke;
    }

    /**
     * @return The value of the {@code access} attribute
     */
    @Override
    public Trees.AccessExpression access() {
      return access;
    }

    /**
     * @return The value of the {@code invoke} attribute
     */
    @Override
    public Optional<Trees.ApplyExpression> invoke() {
      return invoke;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Invoke#access() access} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for access
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Invoke withAccess(Trees.AccessExpression value) {
      if (this.access == value) return this;
      Trees.AccessExpression newValue = Preconditions.checkNotNull(value, "access");
      return new ImmutableTrees.Invoke(newValue, this.invoke);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Trees.Invoke#invoke() invoke} attribute.
     * @param value The value for invoke
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.Invoke withInvoke(Trees.ApplyExpression value) {
      Optional<Trees.ApplyExpression> newValue = Optional.of(value);
      if (this.invoke.isPresent() && this.invoke.get() == value) return this;
      return new ImmutableTrees.Invoke(this.access, newValue);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Trees.Invoke#invoke() invoke} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for invoke
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableTrees.Invoke withInvoke(Optional<? extends Trees.ApplyExpression> optional) {
      Optional<Trees.ApplyExpression> value = (Optional<Trees.ApplyExpression>) optional;
      if (!this.invoke.isPresent() && !value.isPresent()) return this;
      if (this.invoke.isPresent() && value.isPresent() && this.invoke.get() == value.get()) return this;
      return new ImmutableTrees.Invoke(this.access, value);
    }

    /**
     * This instance is equal to all instances of {@code Invoke} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.Invoke
          && equalTo((ImmutableTrees.Invoke) another);
    }

    private boolean equalTo(ImmutableTrees.Invoke another) {
      return access.equals(another.access)
          && invoke.equals(another.invoke);
    }

    /**
     * Computes a hash code from attributes: {@code access}, {@code invoke}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + access.hashCode();
      h += (h << 5) + invoke.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Invoke} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Invoke")
          .omitNullValues()
          .add("access", access)
          .add("invoke", invoke.orNull())
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.Invoke} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Invoke instance
     */
    public static ImmutableTrees.Invoke copyOf(Trees.Invoke instance) {
      if (instance instanceof ImmutableTrees.Invoke) {
        return (ImmutableTrees.Invoke) instance;
      }
      return ImmutableTrees.Invoke.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.Invoke Invoke}.
     * @return A new Invoke builder
     */
    public static ImmutableTrees.Invoke.Builder builder() {
      return new ImmutableTrees.Invoke.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.Invoke Invoke}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ACCESS = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.AccessExpression access;
      private Optional<Trees.ApplyExpression> invoke = Optional.absent();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.InvokeDeclaration} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.InvokeDeclaration instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Invoke} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Invoke instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.InvokeDeclaration) {
          Trees.InvokeDeclaration instance = (Trees.InvokeDeclaration) object;
          Optional<Trees.ApplyExpression> invokeOptional = instance.invoke();
          if (invokeOptional.isPresent()) {
            invoke(invokeOptional);
          }
          access(instance.access());
        }
      }

      /**
       * Initializes the value for the {@link Trees.Invoke#access() access} attribute.
       * @param access The value for access 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder access(Trees.AccessExpression access) {
        this.access = Preconditions.checkNotNull(access, "access");
        initBits &= ~INIT_BIT_ACCESS;
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.Invoke#invoke() invoke} to invoke.
       * @param invoke The value for invoke
       * @return {@code this} builder for chained invocation
       */
      public final Builder invoke(Trees.ApplyExpression invoke) {
        this.invoke = Optional.of(invoke);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.Invoke#invoke() invoke} to invoke.
       * @param invoke The value for invoke
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder invoke(Optional<? extends Trees.ApplyExpression> invoke) {
        this.invoke = (Optional<Trees.ApplyExpression>) invoke;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.Invoke Invoke}.
       * @return An immutable instance of Invoke
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.Invoke build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.Invoke(access, invoke);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_ACCESS) != 0) attributes.add("access");
        return "Cannot build Invoke, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.TextFragment}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.TextFragment.of()}.
   */
  @Immutable
  public static final class TextFragment extends Trees.TextFragment {
    private final String value;

    private TextFragment(String value) {
      this.value = Preconditions.checkNotNull(value, "value");
    }

    private TextFragment(TextFragment original, String value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TextFragment#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TextFragment withValue(String value) {
      if (this.value.equals(value)) return this;
      String newValue = Preconditions.checkNotNull(value, "value");
      return new ImmutableTrees.TextFragment(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TextFragment} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.TextFragment
          && equalTo((ImmutableTrees.TextFragment) another);
    }

    private boolean equalTo(ImmutableTrees.TextFragment another) {
      return value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Construct a new immutable {@code TextFragment} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable TextFragment instance
     */
    public static ImmutableTrees.TextFragment of(String value) {
      return new ImmutableTrees.TextFragment(value);
    }

    /**
     * Creates an immutable copy of a {@link Trees.TextFragment} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TextFragment instance
     */
    public static ImmutableTrees.TextFragment copyOf(Trees.TextFragment instance) {
      if (instance instanceof ImmutableTrees.TextFragment) {
        return (ImmutableTrees.TextFragment) instance;
      }
      return ImmutableTrees.TextFragment.of(instance.value());
    }
  }

  /**
   * Immutable implementation of {@link Trees.ForEnd}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.ForEnd.of()}.
   */
  @Immutable
  public static final class ForEnd implements Trees.ForEnd {

    private ForEnd() {}

    /**
     * This instance is equal to all instances of {@code ForEnd} that have equal attribute values.
     * As instances of the {@code ForEnd} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 1796548500;
    }

    /**
     * Prints the immutable value {@code ForEnd}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "ForEnd{}";
    }

    private static final ImmutableTrees.ForEnd INSTANCE = new ImmutableTrees.ForEnd();

    /**
     * Returns the default immutable singleton value of {@code ForEnd}
     * @return An immutable instance of ForEnd
     */
    public static ImmutableTrees.ForEnd of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.TypeDeclaration}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.TypeDeclaration.builder()}.
   */
  @Immutable
  public static final class TypeDeclaration extends Trees.TypeDeclaration {
    private final Trees.TypeIdentifier type;
    private final Trees.TypeDeclaration.Kind kind;

    private TypeDeclaration(ImmutableTrees.TypeDeclaration.Builder builder) {
      this.type = builder.type;
      this.kind = builder.kind != null
          ? builder.kind
          : Preconditions.checkNotNull(super.kind(), "kind");
    }

    private TypeDeclaration(
        Trees.TypeIdentifier type,
        Trees.TypeDeclaration.Kind kind) {
      this.type = type;
      this.kind = kind;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    public Trees.TypeIdentifier type() {
      return type;
    }

    /**
     * @return The value of the {@code kind} attribute
     */
    @Override
    public Trees.TypeDeclaration.Kind kind() {
      return kind;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TypeDeclaration#type() type} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TypeDeclaration withType(Trees.TypeIdentifier value) {
      if (this.type == value) return this;
      Trees.TypeIdentifier newValue = Preconditions.checkNotNull(value, "type");
      return new ImmutableTrees.TypeDeclaration(newValue, this.kind);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TypeDeclaration#kind() kind} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for kind
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TypeDeclaration withKind(Trees.TypeDeclaration.Kind value) {
      if (this.kind == value) return this;
      Trees.TypeDeclaration.Kind newValue = Preconditions.checkNotNull(value, "kind");
      return new ImmutableTrees.TypeDeclaration(this.type, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TypeDeclaration} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.TypeDeclaration
          && equalTo((ImmutableTrees.TypeDeclaration) another);
    }

    private boolean equalTo(ImmutableTrees.TypeDeclaration another) {
      return type.equals(another.type)
          && kind.equals(another.kind);
    }

    /**
     * Computes a hash code from attributes: {@code type}, {@code kind}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + type.hashCode();
      h += (h << 5) + kind.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code TypeDeclaration} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TypeDeclaration")
          .omitNullValues()
          .add("type", type)
          .add("kind", kind)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.TypeDeclaration} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TypeDeclaration instance
     */
    public static ImmutableTrees.TypeDeclaration copyOf(Trees.TypeDeclaration instance) {
      if (instance instanceof ImmutableTrees.TypeDeclaration) {
        return (ImmutableTrees.TypeDeclaration) instance;
      }
      return ImmutableTrees.TypeDeclaration.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.TypeDeclaration TypeDeclaration}.
     * @return A new TypeDeclaration builder
     */
    public static ImmutableTrees.TypeDeclaration.Builder builder() {
      return new ImmutableTrees.TypeDeclaration.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.TypeDeclaration TypeDeclaration}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TYPE = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.TypeIdentifier type;
      private @Nullable Trees.TypeDeclaration.Kind kind;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code TypeDeclaration} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.TypeDeclaration instance) {
        Preconditions.checkNotNull(instance, "instance");
        type(instance.type());
        kind(instance.kind());
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TypeDeclaration#type() type} attribute.
       * @param type The value for type 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder type(Trees.TypeIdentifier type) {
        this.type = Preconditions.checkNotNull(type, "type");
        initBits &= ~INIT_BIT_TYPE;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TypeDeclaration#kind() kind} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Trees.TypeDeclaration#kind() kind}.</em>
       * @param kind The value for kind 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder kind(Trees.TypeDeclaration.Kind kind) {
        this.kind = Preconditions.checkNotNull(kind, "kind");
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.TypeDeclaration TypeDeclaration}.
       * @return An immutable instance of TypeDeclaration
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.TypeDeclaration build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.TypeDeclaration(this);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
        return "Cannot build TypeDeclaration, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.TemplateEnd}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.TemplateEnd.of()}.
   */
  @Immutable
  public static final class TemplateEnd implements Trees.TemplateEnd {

    private TemplateEnd() {}

    /**
     * This instance is equal to all instances of {@code TemplateEnd} that have equal attribute values.
     * As instances of the {@code TemplateEnd} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 1299747805;
    }

    /**
     * Prints the immutable value {@code TemplateEnd}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "TemplateEnd{}";
    }

    private static final ImmutableTrees.TemplateEnd INSTANCE = new ImmutableTrees.TemplateEnd();

    /**
     * Returns the default immutable singleton value of {@code TemplateEnd}
     * @return An immutable instance of TemplateEnd
     */
    public static ImmutableTrees.TemplateEnd of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokableDeclaration}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.InvokableDeclaration.builder()}.
   */
  @Immutable
  public static final class InvokableDeclaration
      implements Trees.InvokableDeclaration {
    private final ImmutableList<Trees.Parameter> parameters;
    private final Trees.Identifier name;

    private InvokableDeclaration(
        ImmutableList<Trees.Parameter> parameters,
        Trees.Identifier name) {
      this.parameters = parameters;
      this.name = name;
    }

    /**
     * @return The value of the {@code parameters} attribute
     */
    @Override
    public ImmutableList<Trees.Parameter> parameters() {
      return parameters;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public Trees.Identifier name() {
      return name;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.InvokableDeclaration#parameters() parameters}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.InvokableDeclaration withParameters(Trees.Parameter... elements) {
      ImmutableList<Trees.Parameter> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.InvokableDeclaration(newValue, this.name);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.InvokableDeclaration#parameters() parameters}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parameters elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.InvokableDeclaration withParameters(Iterable<? extends Trees.Parameter> elements) {
      if (this.parameters == elements) return this;
      ImmutableList<Trees.Parameter> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.InvokableDeclaration(newValue, this.name);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.InvokableDeclaration#name() name} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.InvokableDeclaration withName(Trees.Identifier value) {
      if (this.name == value) return this;
      Trees.Identifier newValue = Preconditions.checkNotNull(value, "name");
      return new ImmutableTrees.InvokableDeclaration(this.parameters, newValue);
    }

    /**
     * This instance is equal to all instances of {@code InvokableDeclaration} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.InvokableDeclaration
          && equalTo((ImmutableTrees.InvokableDeclaration) another);
    }

    private boolean equalTo(ImmutableTrees.InvokableDeclaration another) {
      return parameters.equals(another.parameters)
          && name.equals(another.name);
    }

    /**
     * Computes a hash code from attributes: {@code parameters}, {@code name}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + parameters.hashCode();
      h += (h << 5) + name.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code InvokableDeclaration} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokableDeclaration")
          .omitNullValues()
          .add("parameters", parameters)
          .add("name", name)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.InvokableDeclaration} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable InvokableDeclaration instance
     */
    public static ImmutableTrees.InvokableDeclaration copyOf(Trees.InvokableDeclaration instance) {
      if (instance instanceof ImmutableTrees.InvokableDeclaration) {
        return (ImmutableTrees.InvokableDeclaration) instance;
      }
      return ImmutableTrees.InvokableDeclaration.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.InvokableDeclaration InvokableDeclaration}.
     * @return A new InvokableDeclaration builder
     */
    public static ImmutableTrees.InvokableDeclaration.Builder builder() {
      return new ImmutableTrees.InvokableDeclaration.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.InvokableDeclaration InvokableDeclaration}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private long initBits = 0x1L;

      private ImmutableList.Builder<Trees.Parameter> parameters = ImmutableList.builder();
      private @Nullable Trees.Identifier name;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.InvokableDeclaration} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.InvokableDeclaration instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Named} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Named instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.InvokableDeclaration) {
          Trees.InvokableDeclaration instance = (Trees.InvokableDeclaration) object;
          addAllParameters(instance.parameters());
        }
        if (object instanceof Trees.Named) {
          Trees.Named instance = (Trees.Named) object;
          name(instance.name());
        }
      }

      /**
       * Adds one element to {@link Trees.InvokableDeclaration#parameters() parameters} list.
       * @param element A parameters element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParameters(Trees.Parameter element) {
        this.parameters.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.InvokableDeclaration#parameters() parameters} list.
       * @param elements An array of parameters elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParameters(Trees.Parameter... elements) {
        this.parameters.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.InvokableDeclaration#parameters() parameters} list.
       * @param elements An iterable of parameters elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parameters(Iterable<? extends Trees.Parameter> elements) {
        this.parameters = ImmutableList.builder();
        return addAllParameters(elements);
      }

      /**
       * Adds elements to {@link Trees.InvokableDeclaration#parameters() parameters} list.
       * @param elements An iterable of parameters elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParameters(Iterable<? extends Trees.Parameter> elements) {
        this.parameters.addAll(elements);
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.InvokableDeclaration#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder name(Trees.Identifier name) {
        this.name = Preconditions.checkNotNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.InvokableDeclaration InvokableDeclaration}.
       * @return An immutable instance of InvokableDeclaration
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.InvokableDeclaration build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.InvokableDeclaration(parameters.build(), name);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        return "Cannot build InvokableDeclaration, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ApplyExpression}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.ApplyExpression.builder()}.
   */
  @Immutable
  public static final class ApplyExpression implements Trees.ApplyExpression {
    private final ImmutableList<Trees.Expression> params;

    private ApplyExpression(
        ImmutableList<Trees.Expression> params) {
      this.params = params;
    }

    /**
     * @return The value of the {@code params} attribute
     */
    @Override
    public ImmutableList<Trees.Expression> params() {
      return params;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ApplyExpression#params() params}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ApplyExpression withParams(Trees.Expression... elements) {
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ApplyExpression(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ApplyExpression#params() params}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of params elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ApplyExpression withParams(Iterable<? extends Trees.Expression> elements) {
      if (this.params == elements) return this;
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ApplyExpression(newValue);
    }

    /**
     * This instance is equal to all instances of {@code ApplyExpression} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ApplyExpression
          && equalTo((ImmutableTrees.ApplyExpression) another);
    }

    private boolean equalTo(ImmutableTrees.ApplyExpression another) {
      return params.equals(another.params);
    }

    /**
     * Computes a hash code from attributes: {@code params}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + params.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ApplyExpression} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ApplyExpression")
          .omitNullValues()
          .add("params", params)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.ApplyExpression} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ApplyExpression instance
     */
    public static ImmutableTrees.ApplyExpression copyOf(Trees.ApplyExpression instance) {
      if (instance instanceof ImmutableTrees.ApplyExpression) {
        return (ImmutableTrees.ApplyExpression) instance;
      }
      return ImmutableTrees.ApplyExpression.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.ApplyExpression ApplyExpression}.
     * @return A new ApplyExpression builder
     */
    public static ImmutableTrees.ApplyExpression.Builder builder() {
      return new ImmutableTrees.ApplyExpression.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.ApplyExpression ApplyExpression}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Trees.Expression> params = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ApplyExpression} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.ApplyExpression instance) {
        Preconditions.checkNotNull(instance, "instance");
        addAllParams(instance.params());
        return this;
      }

      /**
       * Adds one element to {@link Trees.ApplyExpression#params() params} list.
       * @param element A params element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParams(Trees.Expression element) {
        this.params.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ApplyExpression#params() params} list.
       * @param elements An array of params elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParams(Trees.Expression... elements) {
        this.params.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.ApplyExpression#params() params} list.
       * @param elements An iterable of params elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder params(Iterable<? extends Trees.Expression> elements) {
        this.params = ImmutableList.builder();
        return addAllParams(elements);
      }

      /**
       * Adds elements to {@link Trees.ApplyExpression#params() params} list.
       * @param elements An iterable of params elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
        this.params.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.ApplyExpression ApplyExpression}.
       * @return An immutable instance of ApplyExpression
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.ApplyExpression build() {
        return new ImmutableTrees.ApplyExpression(params.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Else}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.Else.of()}.
   */
  @Immutable
  public static final class Else implements Trees.Else {

    private Else() {}

    /**
     * This instance is equal to all instances of {@code Else} that have equal attribute values.
     * As instances of the {@code Else} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return -1598161349;
    }

    /**
     * Prints the immutable value {@code Else}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Else{}";
    }

    private static final ImmutableTrees.Else INSTANCE = new ImmutableTrees.Else();

    /**
     * Returns the default immutable singleton value of {@code Else}
     * @return An immutable instance of Else
     */
    public static ImmutableTrees.Else of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.BoundAccessExpression}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.BoundAccessExpression.builder()}.
   */
  @Immutable
  public static final class BoundAccessExpression
      extends Trees.BoundAccessExpression {
    private final ImmutableList<Object> accessor;
    private final ImmutableList<Trees.Identifier> path;

    private BoundAccessExpression(
        ImmutableList<Object> accessor,
        ImmutableList<Trees.Identifier> path) {
      this.accessor = accessor;
      this.path = path;
    }

    /**
     * @return The value of the {@code accessor} attribute
     */
    @Override
    public ImmutableList<Object> accessor() {
      return accessor;
    }

    /**
     * @return The value of the {@code path} attribute
     */
    @Override
    public ImmutableList<Trees.Identifier> path() {
      return path;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.BoundAccessExpression#accessor() accessor}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.BoundAccessExpression withAccessor(Object... elements) {
      ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.BoundAccessExpression(newValue, this.path);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.BoundAccessExpression#accessor() accessor}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of accessor elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.BoundAccessExpression withAccessor(Iterable<? extends Object> elements) {
      if (this.accessor == elements) return this;
      ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.BoundAccessExpression(newValue, this.path);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.BoundAccessExpression#path() path}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.BoundAccessExpression withPath(Trees.Identifier... elements) {
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.BoundAccessExpression(this.accessor, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.BoundAccessExpression#path() path}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of path elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.BoundAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
      if (this.path == elements) return this;
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.BoundAccessExpression(this.accessor, newValue);
    }

    /**
     * This instance is equal to all instances of {@code BoundAccessExpression} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.BoundAccessExpression
          && equalTo((ImmutableTrees.BoundAccessExpression) another);
    }

    private boolean equalTo(ImmutableTrees.BoundAccessExpression another) {
      return accessor.equals(another.accessor)
          && path.equals(another.path);
    }

    /**
     * Computes a hash code from attributes: {@code accessor}, {@code path}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + accessor.hashCode();
      h += (h << 5) + path.hashCode();
      return h;
    }

    /**
     * Creates an immutable copy of a {@link Trees.BoundAccessExpression} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable BoundAccessExpression instance
     */
    public static ImmutableTrees.BoundAccessExpression copyOf(Trees.BoundAccessExpression instance) {
      if (instance instanceof ImmutableTrees.BoundAccessExpression) {
        return (ImmutableTrees.BoundAccessExpression) instance;
      }
      return ImmutableTrees.BoundAccessExpression.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.BoundAccessExpression BoundAccessExpression}.
     * @return A new BoundAccessExpression builder
     */
    public static ImmutableTrees.BoundAccessExpression.Builder builder() {
      return new ImmutableTrees.BoundAccessExpression.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.BoundAccessExpression BoundAccessExpression}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Object> accessor = ImmutableList.builder();
      private ImmutableList.Builder<Trees.Identifier> path = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.BoundAccessExpression} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.BoundAccessExpression instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.AccessExpression} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.AccessExpression instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.BoundAccessExpression) {
          Trees.BoundAccessExpression instance = (Trees.BoundAccessExpression) object;
          addAllAccessor(instance.accessor());
        }
        if (object instanceof Trees.AccessExpression) {
          Trees.AccessExpression instance = (Trees.AccessExpression) object;
          addAllPath(instance.path());
        }
      }

      /**
       * Adds one element to {@link Trees.BoundAccessExpression#accessor() accessor} list.
       * @param element A accessor element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAccessor(Object element) {
        this.accessor.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.BoundAccessExpression#accessor() accessor} list.
       * @param elements An array of accessor elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAccessor(Object... elements) {
        this.accessor.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.BoundAccessExpression#accessor() accessor} list.
       * @param elements An iterable of accessor elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder accessor(Iterable<? extends Object> elements) {
        this.accessor = ImmutableList.builder();
        return addAllAccessor(elements);
      }

      /**
       * Adds elements to {@link Trees.BoundAccessExpression#accessor() accessor} list.
       * @param elements An iterable of accessor elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllAccessor(Iterable<? extends Object> elements) {
        this.accessor.addAll(elements);
        return this;
      }

      /**
       * Adds one element to {@link Trees.BoundAccessExpression#path() path} list.
       * @param element A path element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addPath(Trees.Identifier element) {
        this.path.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.BoundAccessExpression#path() path} list.
       * @param elements An array of path elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addPath(Trees.Identifier... elements) {
        this.path.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.BoundAccessExpression#path() path} list.
       * @param elements An iterable of path elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder path(Iterable<? extends Trees.Identifier> elements) {
        this.path = ImmutableList.builder();
        return addAllPath(elements);
      }

      /**
       * Adds elements to {@link Trees.BoundAccessExpression#path() path} list.
       * @param elements An iterable of path elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllPath(Iterable<? extends Trees.Identifier> elements) {
        this.path.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.BoundAccessExpression BoundAccessExpression}.
       * @return An immutable instance of BoundAccessExpression
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.BoundAccessExpression build() {
        return new ImmutableTrees.BoundAccessExpression(accessor.build(), path.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokeEnd}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.InvokeEnd.of()}.
   */
  @Immutable
  public static final class InvokeEnd implements Trees.InvokeEnd {
    private final Trees.AccessExpression access;

    private InvokeEnd(Trees.AccessExpression access) {
      this.access = Preconditions.checkNotNull(access, "access");
    }

    private InvokeEnd(InvokeEnd original, Trees.AccessExpression access) {
      this.access = access;
    }

    /**
     * @return The value of the {@code access} attribute
     */
    @Override
    public Trees.AccessExpression access() {
      return access;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.InvokeEnd#access() access} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for access
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.InvokeEnd withAccess(Trees.AccessExpression value) {
      if (this.access == value) return this;
      Trees.AccessExpression newValue = Preconditions.checkNotNull(value, "access");
      return new ImmutableTrees.InvokeEnd(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code InvokeEnd} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.InvokeEnd
          && equalTo((ImmutableTrees.InvokeEnd) another);
    }

    private boolean equalTo(ImmutableTrees.InvokeEnd another) {
      return access.equals(another.access);
    }

    /**
     * Computes a hash code from attributes: {@code access}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + access.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code InvokeEnd} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokeEnd")
          .omitNullValues()
          .add("access", access)
          .toString();
    }

    /**
     * Construct a new immutable {@code InvokeEnd} instance.
     * @param access The value for the {@code access} attribute
     * @return An immutable InvokeEnd instance
     */
    public static ImmutableTrees.InvokeEnd of(Trees.AccessExpression access) {
      return new ImmutableTrees.InvokeEnd(access);
    }

    /**
     * Creates an immutable copy of a {@link Trees.InvokeEnd} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable InvokeEnd instance
     */
    public static ImmutableTrees.InvokeEnd copyOf(Trees.InvokeEnd instance) {
      if (instance instanceof ImmutableTrees.InvokeEnd) {
        return (ImmutableTrees.InvokeEnd) instance;
      }
      return ImmutableTrees.InvokeEnd.of(instance.access());
    }
  }

  /**
   * Immutable implementation of {@link Trees.LetEnd}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.LetEnd.of()}.
   */
  @Immutable
  public static final class LetEnd implements Trees.LetEnd {

    private LetEnd() {}

    /**
     * This instance is equal to all instances of {@code LetEnd} that have equal attribute values.
     * As instances of the {@code LetEnd} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 1959147778;
    }

    /**
     * Prints the immutable value {@code LetEnd}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "LetEnd{}";
    }

    private static final ImmutableTrees.LetEnd INSTANCE = new ImmutableTrees.LetEnd();

    /**
     * Returns the default immutable singleton value of {@code LetEnd}
     * @return An immutable instance of LetEnd
     */
    public static ImmutableTrees.LetEnd of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.IterationGenerator}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.IterationGenerator.builder()}.
   */
  @Immutable
  public static final class IterationGenerator implements Trees.IterationGenerator {
    private final Optional<Trees.Expression> condition;
    private final Trees.ValueDeclaration declaration;
    private final Trees.Expression from;

    private IterationGenerator(
        Optional<Trees.Expression> condition,
        Trees.ValueDeclaration declaration,
        Trees.Expression from) {
      this.condition = condition;
      this.declaration = declaration;
      this.from = from;
    }

    /**
     * @return The value of the {@code condition} attribute
     */
    @Override
    public Optional<Trees.Expression> condition() {
      return condition;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public Trees.ValueDeclaration declaration() {
      return declaration;
    }

    /**
     * @return The value of the {@code from} attribute
     */
    @Override
    public Trees.Expression from() {
      return from;
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Trees.IterationGenerator#condition() condition} attribute.
     * @param value The value for condition
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.IterationGenerator withCondition(Trees.Expression value) {
      Optional<Trees.Expression> newValue = Optional.of(value);
      if (this.condition.isPresent() && this.condition.get() == value) return this;
      return new ImmutableTrees.IterationGenerator(newValue, this.declaration, this.from);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Trees.IterationGenerator#condition() condition} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for condition
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableTrees.IterationGenerator withCondition(Optional<? extends Trees.Expression> optional) {
      Optional<Trees.Expression> value = (Optional<Trees.Expression>) optional;
      if (!this.condition.isPresent() && !value.isPresent()) return this;
      if (this.condition.isPresent() && value.isPresent() && this.condition.get() == value.get()) return this;
      return new ImmutableTrees.IterationGenerator(value, this.declaration, this.from);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.IterationGenerator#declaration() declaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for declaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.IterationGenerator withDeclaration(Trees.ValueDeclaration value) {
      if (this.declaration == value) return this;
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value, "declaration");
      return new ImmutableTrees.IterationGenerator(this.condition, newValue, this.from);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.IterationGenerator#from() from} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for from
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.IterationGenerator withFrom(Trees.Expression value) {
      if (this.from == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "from");
      return new ImmutableTrees.IterationGenerator(this.condition, this.declaration, newValue);
    }

    /**
     * This instance is equal to all instances of {@code IterationGenerator} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.IterationGenerator
          && equalTo((ImmutableTrees.IterationGenerator) another);
    }

    private boolean equalTo(ImmutableTrees.IterationGenerator another) {
      return condition.equals(another.condition)
          && declaration.equals(another.declaration)
          && from.equals(another.from);
    }

    /**
     * Computes a hash code from attributes: {@code condition}, {@code declaration}, {@code from}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + condition.hashCode();
      h += (h << 5) + declaration.hashCode();
      h += (h << 5) + from.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IterationGenerator} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IterationGenerator")
          .omitNullValues()
          .add("condition", condition.orNull())
          .add("declaration", declaration)
          .add("from", from)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.IterationGenerator} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IterationGenerator instance
     */
    public static ImmutableTrees.IterationGenerator copyOf(Trees.IterationGenerator instance) {
      if (instance instanceof ImmutableTrees.IterationGenerator) {
        return (ImmutableTrees.IterationGenerator) instance;
      }
      return ImmutableTrees.IterationGenerator.builder()
          .condition(instance.condition())
          .declaration(instance.declaration())
          .from(instance.from())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.IterationGenerator IterationGenerator}.
     * @return A new IterationGenerator builder
     */
    public static ImmutableTrees.IterationGenerator.Builder builder() {
      return new ImmutableTrees.IterationGenerator.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.IterationGenerator IterationGenerator}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_DECLARATION = 0x1L;
      private static final long INIT_BIT_FROM = 0x2L;
      private long initBits = 0x3L;

      private Optional<Trees.Expression> condition = Optional.absent();
      private @Nullable Trees.ValueDeclaration declaration;
      private @Nullable Trees.Expression from;

      private Builder() {
      }

      /**
       * Initializes the optional value {@link Trees.IterationGenerator#condition() condition} to condition.
       * @param condition The value for condition
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Optional.of(condition);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.IterationGenerator#condition() condition} to condition.
       * @param condition The value for condition
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder condition(Optional<? extends Trees.Expression> condition) {
        this.condition = (Optional<Trees.Expression>) condition;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.IterationGenerator#declaration() declaration} attribute.
       * @param declaration The value for declaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Trees.ValueDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration, "declaration");
        initBits &= ~INIT_BIT_DECLARATION;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.IterationGenerator#from() from} attribute.
       * @param from The value for from 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Expression from) {
        this.from = Preconditions.checkNotNull(from, "from");
        initBits &= ~INIT_BIT_FROM;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.IterationGenerator IterationGenerator}.
       * @return An immutable instance of IterationGenerator
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.IterationGenerator build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.IterationGenerator(condition, declaration, from);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_DECLARATION) != 0) attributes.add("declaration");
        if ((initBits & INIT_BIT_FROM) != 0) attributes.add("from");
        return "Cannot build IterationGenerator, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.IfStatement}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.IfStatement.builder()}.
   */
  @Immutable
  public static final class IfStatement implements Trees.IfStatement {
    private final Trees.ConditionalBlock then;
    private final ImmutableList<Trees.ConditionalBlock> otherwiseIf;
    private final Optional<Trees.Block> otherwise;

    private IfStatement(
        Trees.ConditionalBlock then,
        ImmutableList<Trees.ConditionalBlock> otherwiseIf,
        Optional<Trees.Block> otherwise) {
      this.then = then;
      this.otherwiseIf = otherwiseIf;
      this.otherwise = otherwise;
    }

    /**
     * @return The value of the {@code then} attribute
     */
    @Override
    public Trees.ConditionalBlock then() {
      return then;
    }

    /**
     * @return The value of the {@code otherwiseIf} attribute
     */
    @Override
    public ImmutableList<Trees.ConditionalBlock> otherwiseIf() {
      return otherwiseIf;
    }

    /**
     * @return The value of the {@code otherwise} attribute
     */
    @Override
    public Optional<Trees.Block> otherwise() {
      return otherwise;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.IfStatement#then() then} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for then
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.IfStatement withThen(Trees.ConditionalBlock value) {
      if (this.then == value) return this;
      Trees.ConditionalBlock newValue = Preconditions.checkNotNull(value, "then");
      return new ImmutableTrees.IfStatement(newValue, this.otherwiseIf, this.otherwise);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.IfStatement#otherwiseIf() otherwiseIf}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.IfStatement withOtherwiseIf(Trees.ConditionalBlock... elements) {
      ImmutableList<Trees.ConditionalBlock> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.IfStatement(this.then, newValue, this.otherwise);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.IfStatement#otherwiseIf() otherwiseIf}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of otherwiseIf elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.IfStatement withOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
      if (this.otherwiseIf == elements) return this;
      ImmutableList<Trees.ConditionalBlock> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.IfStatement(this.then, newValue, this.otherwise);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Trees.IfStatement#otherwise() otherwise} attribute.
     * @param value The value for otherwise
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.IfStatement withOtherwise(Trees.Block value) {
      Optional<Trees.Block> newValue = Optional.of(value);
      if (this.otherwise.isPresent() && this.otherwise.get() == value) return this;
      return new ImmutableTrees.IfStatement(this.then, this.otherwiseIf, newValue);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Trees.IfStatement#otherwise() otherwise} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for otherwise
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableTrees.IfStatement withOtherwise(Optional<? extends Trees.Block> optional) {
      Optional<Trees.Block> value = (Optional<Trees.Block>) optional;
      if (!this.otherwise.isPresent() && !value.isPresent()) return this;
      if (this.otherwise.isPresent() && value.isPresent() && this.otherwise.get() == value.get()) return this;
      return new ImmutableTrees.IfStatement(this.then, this.otherwiseIf, value);
    }

    /**
     * This instance is equal to all instances of {@code IfStatement} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.IfStatement
          && equalTo((ImmutableTrees.IfStatement) another);
    }

    private boolean equalTo(ImmutableTrees.IfStatement another) {
      return then.equals(another.then)
          && otherwiseIf.equals(another.otherwiseIf)
          && otherwise.equals(another.otherwise);
    }

    /**
     * Computes a hash code from attributes: {@code then}, {@code otherwiseIf}, {@code otherwise}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + then.hashCode();
      h += (h << 5) + otherwiseIf.hashCode();
      h += (h << 5) + otherwise.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code IfStatement} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("IfStatement")
          .omitNullValues()
          .add("then", then)
          .add("otherwiseIf", otherwiseIf)
          .add("otherwise", otherwise.orNull())
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.IfStatement} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable IfStatement instance
     */
    public static ImmutableTrees.IfStatement copyOf(Trees.IfStatement instance) {
      if (instance instanceof ImmutableTrees.IfStatement) {
        return (ImmutableTrees.IfStatement) instance;
      }
      return ImmutableTrees.IfStatement.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.IfStatement IfStatement}.
     * @return A new IfStatement builder
     */
    public static ImmutableTrees.IfStatement.Builder builder() {
      return new ImmutableTrees.IfStatement.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.IfStatement IfStatement}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_THEN = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.ConditionalBlock then;
      private ImmutableList.Builder<Trees.ConditionalBlock> otherwiseIf = ImmutableList.builder();
      private Optional<Trees.Block> otherwise = Optional.absent();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code IfStatement} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.IfStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        then(instance.then());
        addAllOtherwiseIf(instance.otherwiseIf());
        Optional<Trees.Block> otherwiseOptional = instance.otherwise();
        if (otherwiseOptional.isPresent()) {
          otherwise(otherwiseOptional);
        }
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.IfStatement#then() then} attribute.
       * @param then The value for then 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder then(Trees.ConditionalBlock then) {
        this.then = Preconditions.checkNotNull(then, "then");
        initBits &= ~INIT_BIT_THEN;
        return this;
      }

      /**
       * Adds one element to {@link Trees.IfStatement#otherwiseIf() otherwiseIf} list.
       * @param element A otherwiseIf element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addOtherwiseIf(Trees.ConditionalBlock element) {
        this.otherwiseIf.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.IfStatement#otherwiseIf() otherwiseIf} list.
       * @param elements An array of otherwiseIf elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addOtherwiseIf(Trees.ConditionalBlock... elements) {
        this.otherwiseIf.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.IfStatement#otherwiseIf() otherwiseIf} list.
       * @param elements An iterable of otherwiseIf elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder otherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
        this.otherwiseIf = ImmutableList.builder();
        return addAllOtherwiseIf(elements);
      }

      /**
       * Adds elements to {@link Trees.IfStatement#otherwiseIf() otherwiseIf} list.
       * @param elements An iterable of otherwiseIf elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllOtherwiseIf(Iterable<? extends Trees.ConditionalBlock> elements) {
        this.otherwiseIf.addAll(elements);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.IfStatement#otherwise() otherwise} to otherwise.
       * @param otherwise The value for otherwise
       * @return {@code this} builder for chained invocation
       */
      public final Builder otherwise(Trees.Block otherwise) {
        this.otherwise = Optional.of(otherwise);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.IfStatement#otherwise() otherwise} to otherwise.
       * @param otherwise The value for otherwise
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder otherwise(Optional<? extends Trees.Block> otherwise) {
        this.otherwise = (Optional<Trees.Block>) otherwise;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.IfStatement IfStatement}.
       * @return An immutable instance of IfStatement
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.IfStatement build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.IfStatement(then, otherwiseIf.build(), otherwise);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_THEN) != 0) attributes.add("then");
        return "Cannot build IfStatement, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Unit}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.Unit.builder()}.
   */
  @Immutable
  public static final class Unit implements Trees.Unit {
    private final ImmutableList<Trees.UnitPart> parts;

    private Unit(ImmutableList<Trees.UnitPart> parts) {
      this.parts = parts;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.UnitPart> parts() {
      return parts;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.Unit#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.Unit withParts(Trees.UnitPart... elements) {
      ImmutableList<Trees.UnitPart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.Unit(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.Unit#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.Unit withParts(Iterable<? extends Trees.UnitPart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.UnitPart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.Unit(newValue);
    }

    /**
     * This instance is equal to all instances of {@code Unit} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.Unit
          && equalTo((ImmutableTrees.Unit) another);
    }

    private boolean equalTo(ImmutableTrees.Unit another) {
      return parts.equals(another.parts);
    }

    /**
     * Computes a hash code from attributes: {@code parts}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + parts.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Unit} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Unit")
          .omitNullValues()
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.Unit} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Unit instance
     */
    public static ImmutableTrees.Unit copyOf(Trees.Unit instance) {
      if (instance instanceof ImmutableTrees.Unit) {
        return (ImmutableTrees.Unit) instance;
      }
      return ImmutableTrees.Unit.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.Unit Unit}.
     * @return A new Unit builder
     */
    public static ImmutableTrees.Unit.Builder builder() {
      return new ImmutableTrees.Unit.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.Unit Unit}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Trees.UnitPart> parts = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code Unit} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Unit instance) {
        Preconditions.checkNotNull(instance, "instance");
        addAllParts(instance.parts());
        return this;
      }

      /**
       * Adds one element to {@link Trees.Unit#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.UnitPart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.Unit#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.UnitPart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.Unit#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.UnitPart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.Unit#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.UnitPart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.Unit Unit}.
       * @return An immutable instance of Unit
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.Unit build() {
        return new ImmutableTrees.Unit(parts.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Parameter}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.Parameter.builder()}.
   */
  @Immutable
  public static final class Parameter implements Trees.Parameter {
    private final Trees.Identifier name;
    private final Trees.TypeReference type;

    private Parameter(
        Trees.Identifier name,
        Trees.TypeReference type) {
      this.name = name;
      this.type = type;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public Trees.Identifier name() {
      return name;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    public Trees.TypeReference type() {
      return type;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Parameter#name() name} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Parameter withName(Trees.Identifier value) {
      if (this.name == value) return this;
      Trees.Identifier newValue = Preconditions.checkNotNull(value, "name");
      return new ImmutableTrees.Parameter(newValue, this.type);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Parameter#type() type} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Parameter withType(Trees.TypeReference value) {
      if (this.type == value) return this;
      Trees.TypeReference newValue = Preconditions.checkNotNull(value, "type");
      return new ImmutableTrees.Parameter(this.name, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Parameter} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.Parameter
          && equalTo((ImmutableTrees.Parameter) another);
    }

    private boolean equalTo(ImmutableTrees.Parameter another) {
      return name.equals(another.name)
          && type.equals(another.type);
    }

    /**
     * Computes a hash code from attributes: {@code name}, {@code type}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + name.hashCode();
      h += (h << 5) + type.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Parameter} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Parameter")
          .omitNullValues()
          .add("name", name)
          .add("type", type)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.Parameter} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Parameter instance
     */
    public static ImmutableTrees.Parameter copyOf(Trees.Parameter instance) {
      if (instance instanceof ImmutableTrees.Parameter) {
        return (ImmutableTrees.Parameter) instance;
      }
      return ImmutableTrees.Parameter.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.Parameter Parameter}.
     * @return A new Parameter builder
     */
    public static ImmutableTrees.Parameter.Builder builder() {
      return new ImmutableTrees.Parameter.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.Parameter Parameter}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private static final long INIT_BIT_TYPE = 0x2L;
      private long initBits = 0x3L;

      private @Nullable Trees.Identifier name;
      private @Nullable Trees.TypeReference type;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Typed} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Typed instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Named} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Named instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Parameter} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Parameter instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Typed) {
          Trees.Typed instance = (Trees.Typed) object;
          type(instance.type());
        }
        if (object instanceof Trees.Named) {
          Trees.Named instance = (Trees.Named) object;
          name(instance.name());
        }
      }

      /**
       * Initializes the value for the {@link Trees.Parameter#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder name(Trees.Identifier name) {
        this.name = Preconditions.checkNotNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.Parameter#type() type} attribute.
       * @param type The value for type 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder type(Trees.TypeReference type) {
        this.type = Preconditions.checkNotNull(type, "type");
        initBits &= ~INIT_BIT_TYPE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.Parameter Parameter}.
       * @return An immutable instance of Parameter
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.Parameter build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.Parameter(name, type);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
        return "Cannot build Parameter, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.For}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.For.builder()}.
   */
  @Immutable
  public static final class For implements Trees.For {
    private final ImmutableList<Trees.GeneratorDeclaration> declaration;

    private For(
        ImmutableList<Trees.GeneratorDeclaration> declaration) {
      this.declaration = declaration;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public ImmutableList<Trees.GeneratorDeclaration> declaration() {
      return declaration;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.For#declaration() declaration}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.For withDeclaration(Trees.GeneratorDeclaration... elements) {
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.For(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.For#declaration() declaration}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of declaration elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.For withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
      if (this.declaration == elements) return this;
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.For(newValue);
    }

    /**
     * This instance is equal to all instances of {@code For} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.For
          && equalTo((ImmutableTrees.For) another);
    }

    private boolean equalTo(ImmutableTrees.For another) {
      return declaration.equals(another.declaration);
    }

    /**
     * Computes a hash code from attributes: {@code declaration}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + declaration.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code For} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("For")
          .omitNullValues()
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.For} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable For instance
     */
    public static ImmutableTrees.For copyOf(Trees.For instance) {
      if (instance instanceof ImmutableTrees.For) {
        return (ImmutableTrees.For) instance;
      }
      return ImmutableTrees.For.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.For For}.
     * @return A new For builder
     */
    public static ImmutableTrees.For.Builder builder() {
      return new ImmutableTrees.For.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.For For}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Trees.GeneratorDeclaration> declaration = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code For} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.For instance) {
        Preconditions.checkNotNull(instance, "instance");
        addAllDeclaration(instance.declaration());
        return this;
      }

      /**
       * Adds one element to {@link Trees.For#declaration() declaration} list.
       * @param element A declaration element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
        this.declaration.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.For#declaration() declaration} list.
       * @param elements An array of declaration elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration... elements) {
        this.declaration.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.For#declaration() declaration} list.
       * @param elements An iterable of declaration elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
        this.declaration = ImmutableList.builder();
        return addAllDeclaration(elements);
      }

      /**
       * Adds elements to {@link Trees.For#declaration() declaration} list.
       * @param elements An iterable of declaration elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
        this.declaration.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.For For}.
       * @return An immutable instance of For
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.For build() {
        return new ImmutableTrees.For(declaration.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.StringLiteral}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.StringLiteral.of()}.
   */
  @Immutable
  public static final class StringLiteral extends Trees.StringLiteral {
    private final String value;

    private StringLiteral(String value) {
      this.value = Preconditions.checkNotNull(value, "value");
    }

    private StringLiteral(StringLiteral original, String value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.StringLiteral#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.StringLiteral withValue(String value) {
      if (this.value.equals(value)) return this;
      String newValue = Preconditions.checkNotNull(value, "value");
      return new ImmutableTrees.StringLiteral(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code StringLiteral} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.StringLiteral
          && equalTo((ImmutableTrees.StringLiteral) another);
    }

    private boolean equalTo(ImmutableTrees.StringLiteral another) {
      return value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Construct a new immutable {@code StringLiteral} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable StringLiteral instance
     */
    public static ImmutableTrees.StringLiteral of(String value) {
      return new ImmutableTrees.StringLiteral(value);
    }

    /**
     * Creates an immutable copy of a {@link Trees.StringLiteral} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable StringLiteral instance
     */
    public static ImmutableTrees.StringLiteral copyOf(Trees.StringLiteral instance) {
      if (instance instanceof ImmutableTrees.StringLiteral) {
        return (ImmutableTrees.StringLiteral) instance;
      }
      return ImmutableTrees.StringLiteral.of(instance.value());
    }
  }

  /**
   * Immutable implementation of {@link Trees.Identifier}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.Identifier.of()}.
   */
  @Immutable
  public static final class Identifier extends Trees.Identifier {
    private final String value;

    private Identifier(String value) {
      this.value = Preconditions.checkNotNull(value, "value");
    }

    private Identifier(Identifier original, String value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Identifier#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Identifier withValue(String value) {
      if (this.value.equals(value)) return this;
      String newValue = Preconditions.checkNotNull(value, "value");
      return new ImmutableTrees.Identifier(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Identifier} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.Identifier
          && equalTo((ImmutableTrees.Identifier) another);
    }

    private boolean equalTo(ImmutableTrees.Identifier another) {
      return value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Construct a new immutable {@code Identifier} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable Identifier instance
     */
    public static ImmutableTrees.Identifier of(String value) {
      return new ImmutableTrees.Identifier(value);
    }

    /**
     * Creates an immutable copy of a {@link Trees.Identifier} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Identifier instance
     */
    public static ImmutableTrees.Identifier copyOf(Trees.Identifier instance) {
      if (instance instanceof ImmutableTrees.Identifier) {
        return (ImmutableTrees.Identifier) instance;
      }
      return ImmutableTrees.Identifier.of(instance.value());
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokeString}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.InvokeString.of()}.
   */
  @Immutable
  public static final class InvokeString implements Trees.InvokeString {
    private final Trees.StringLiteral literal;

    private InvokeString(Trees.StringLiteral literal) {
      this.literal = Preconditions.checkNotNull(literal, "literal");
    }

    private InvokeString(InvokeString original, Trees.StringLiteral literal) {
      this.literal = literal;
    }

    /**
     * @return The value of the {@code literal} attribute
     */
    @Override
    public Trees.StringLiteral literal() {
      return literal;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.InvokeString#literal() literal} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for literal
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.InvokeString withLiteral(Trees.StringLiteral value) {
      if (this.literal == value) return this;
      Trees.StringLiteral newValue = Preconditions.checkNotNull(value, "literal");
      return new ImmutableTrees.InvokeString(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code InvokeString} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.InvokeString
          && equalTo((ImmutableTrees.InvokeString) another);
    }

    private boolean equalTo(ImmutableTrees.InvokeString another) {
      return literal.equals(another.literal);
    }

    /**
     * Computes a hash code from attributes: {@code literal}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + literal.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code InvokeString} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokeString")
          .omitNullValues()
          .add("literal", literal)
          .toString();
    }

    /**
     * Construct a new immutable {@code InvokeString} instance.
     * @param literal The value for the {@code literal} attribute
     * @return An immutable InvokeString instance
     */
    public static ImmutableTrees.InvokeString of(Trees.StringLiteral literal) {
      return new ImmutableTrees.InvokeString(literal);
    }

    /**
     * Creates an immutable copy of a {@link Trees.InvokeString} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable InvokeString instance
     */
    public static ImmutableTrees.InvokeString copyOf(Trees.InvokeString instance) {
      if (instance instanceof ImmutableTrees.InvokeString) {
        return (ImmutableTrees.InvokeString) instance;
      }
      return ImmutableTrees.InvokeString.of(instance.literal());
    }
  }

  /**
   * Immutable implementation of {@link Trees.ForStatement}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.ForStatement.builder()}.
   */
  @Immutable
  public static final class ForStatement extends Trees.ForStatement {
    private final boolean useForAccess;
    private final boolean useDelimit;
    private final ImmutableList<Trees.GeneratorDeclaration> declaration;
    private final ImmutableList<Trees.TemplatePart> parts;

    private ForStatement(ImmutableTrees.ForStatement.Builder builder) {
      this.declaration = builder.declaration.build();
      this.parts = builder.parts.build();
      if (builder.useForAccessIsSet()) {
        initShim.useForAccess(builder.useForAccess);
      }
      if (builder.useDelimitIsSet()) {
        initShim.useDelimit(builder.useDelimit);
      }
      this.useForAccess = initShim.useForAccess();
      this.useDelimit = initShim.useDelimit();
      this.initShim = null;
    }

    private ForStatement(
        boolean useForAccess,
        boolean useDelimit,
        ImmutableList<Trees.GeneratorDeclaration> declaration,
        ImmutableList<Trees.TemplatePart> parts) {
      this.useForAccess = useForAccess;
      this.useDelimit = useDelimit;
      this.declaration = declaration;
      this.parts = parts;
      this.initShim = null;
    }

    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private transient volatile InitShim initShim = new InitShim();

    private final class InitShim {
      private boolean useForAccess;
      private int useForAccessBuildStage;

      boolean useForAccess() {
        if (useForAccessBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (useForAccessBuildStage == STAGE_UNINITIALIZED) {
          useForAccessBuildStage = STAGE_INITIALIZING;
          this.useForAccess = ForStatement.super.useForAccess();
          useForAccessBuildStage = STAGE_INITIALIZED;
        }
        return this.useForAccess;
      }

      void useForAccess(boolean useForAccess) {
        this.useForAccess = useForAccess;
        useForAccessBuildStage = STAGE_INITIALIZED;
      }
      private boolean useDelimit;
      private int useDelimitBuildStage;

      boolean useDelimit() {
        if (useDelimitBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
        if (useDelimitBuildStage == STAGE_UNINITIALIZED) {
          useDelimitBuildStage = STAGE_INITIALIZING;
          this.useDelimit = ForStatement.super.useDelimit();
          useDelimitBuildStage = STAGE_INITIALIZED;
        }
        return this.useDelimit;
      }

      void useDelimit(boolean useDelimit) {
        this.useDelimit = useDelimit;
        useDelimitBuildStage = STAGE_INITIALIZED;
      }

      private String formatInitCycleMessage() {
        ArrayList<String> attributes = Lists.newArrayList();
        if (useForAccessBuildStage == STAGE_INITIALIZING) attributes.add("useForAccess");
        if (useDelimitBuildStage == STAGE_INITIALIZING) attributes.add("useDelimit");
        return "Cannot build ForStatement, attribute initializers form cycle" + attributes;
      }
    }

    /**
     * @return The value of the {@code useForAccess} attribute
     */
    @Override
    public boolean useForAccess() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.useForAccess()
          : this.useForAccess;
    }

    /**
     * @return The value of the {@code useDelimit} attribute
     */
    @Override
    public boolean useDelimit() {
      InitShim shim = this.initShim;
      return shim != null
          ? shim.useDelimit()
          : this.useDelimit;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public ImmutableList<Trees.GeneratorDeclaration> declaration() {
      return declaration;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ForStatement#useForAccess() useForAccess} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for useForAccess
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ForStatement withUseForAccess(boolean value) {
      if (this.useForAccess == value) return this;
      return new ImmutableTrees.ForStatement(value, this.useDelimit, this.declaration, this.parts);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ForStatement#useDelimit() useDelimit} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for useDelimit
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ForStatement withUseDelimit(boolean value) {
      if (this.useDelimit == value) return this;
      return new ImmutableTrees.ForStatement(this.useForAccess, value, this.declaration, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ForStatement#declaration() declaration}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ForStatement withDeclaration(Trees.GeneratorDeclaration... elements) {
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ForStatement(this.useForAccess, this.useDelimit, newValue, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ForStatement#declaration() declaration}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of declaration elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ForStatement withDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
      if (this.declaration == elements) return this;
      ImmutableList<Trees.GeneratorDeclaration> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ForStatement(this.useForAccess, this.useDelimit, newValue, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ForStatement#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ForStatement withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ForStatement(this.useForAccess, this.useDelimit, this.declaration, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ForStatement#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ForStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ForStatement(this.useForAccess, this.useDelimit, this.declaration, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ForStatement} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ForStatement
          && equalTo((ImmutableTrees.ForStatement) another);
    }

    private boolean equalTo(ImmutableTrees.ForStatement another) {
      return useForAccess == another.useForAccess
          && useDelimit == another.useDelimit
          && declaration.equals(another.declaration)
          && parts.equals(another.parts);
    }

    /**
     * Computes a hash code from attributes: {@code useForAccess}, {@code useDelimit}, {@code declaration}, {@code parts}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Booleans.hashCode(useForAccess);
      h += (h << 5) + Booleans.hashCode(useDelimit);
      h += (h << 5) + declaration.hashCode();
      h += (h << 5) + parts.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ForStatement} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ForStatement")
          .omitNullValues()
          .add("useForAccess", useForAccess)
          .add("useDelimit", useDelimit)
          .add("declaration", declaration)
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.ForStatement} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ForStatement instance
     */
    public static ImmutableTrees.ForStatement copyOf(Trees.ForStatement instance) {
      if (instance instanceof ImmutableTrees.ForStatement) {
        return (ImmutableTrees.ForStatement) instance;
      }
      return ImmutableTrees.ForStatement.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.ForStatement ForStatement}.
     * @return A new ForStatement builder
     */
    public static ImmutableTrees.ForStatement.Builder builder() {
      return new ImmutableTrees.ForStatement.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.ForStatement ForStatement}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long OPT_BIT_USE_FOR_ACCESS = 0x1L;
      private static final long OPT_BIT_USE_DELIMIT = 0x2L;
      private long optBits;

      private boolean useForAccess;
      private boolean useDelimit;
      private ImmutableList.Builder<Trees.GeneratorDeclaration> declaration = ImmutableList.builder();
      private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.ForStatement} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.ForStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Block} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Block instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.ForStatement) {
          Trees.ForStatement instance = (Trees.ForStatement) object;
          useForAccess(instance.useForAccess());
          addAllDeclaration(instance.declaration());
          useDelimit(instance.useDelimit());
        }
        if (object instanceof Trees.Block) {
          Trees.Block instance = (Trees.Block) object;
          addAllParts(instance.parts());
        }
      }

      /**
       * Initializes the value for the {@link Trees.ForStatement#useForAccess() useForAccess} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Trees.ForStatement#useForAccess() useForAccess}.</em>
       * @param useForAccess The value for useForAccess 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder useForAccess(boolean useForAccess) {
        this.useForAccess = useForAccess;
        optBits |= OPT_BIT_USE_FOR_ACCESS;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.ForStatement#useDelimit() useDelimit} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Trees.ForStatement#useDelimit() useDelimit}.</em>
       * @param useDelimit The value for useDelimit 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder useDelimit(boolean useDelimit) {
        this.useDelimit = useDelimit;
        optBits |= OPT_BIT_USE_DELIMIT;
        return this;
      }

      /**
       * Adds one element to {@link Trees.ForStatement#declaration() declaration} list.
       * @param element A declaration element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration element) {
        this.declaration.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ForStatement#declaration() declaration} list.
       * @param elements An array of declaration elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addDeclaration(Trees.GeneratorDeclaration... elements) {
        this.declaration.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.ForStatement#declaration() declaration} list.
       * @param elements An iterable of declaration elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
        this.declaration = ImmutableList.builder();
        return addAllDeclaration(elements);
      }

      /**
       * Adds elements to {@link Trees.ForStatement#declaration() declaration} list.
       * @param elements An iterable of declaration elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllDeclaration(Iterable<? extends Trees.GeneratorDeclaration> elements) {
        this.declaration.addAll(elements);
        return this;
      }

      /**
       * Adds one element to {@link Trees.ForStatement#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ForStatement#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.ForStatement#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.ForStatement#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.ForStatement ForStatement}.
       * @return An immutable instance of ForStatement
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.ForStatement build() {
        return new ImmutableTrees.ForStatement(this);
      }

      private boolean useForAccessIsSet() {
        return (optBits & OPT_BIT_USE_FOR_ACCESS) != 0;
      }

      private boolean useDelimitIsSet() {
        return (optBits & OPT_BIT_USE_DELIMIT) != 0;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.If}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.If.builder()}.
   */
  @Immutable
  public static final class If implements Trees.If {
    private final Trees.Expression condition;

    private If(Trees.Expression condition) {
      this.condition = condition;
    }

    /**
     * @return The value of the {@code condition} attribute
     */
    @Override
    public Trees.Expression condition() {
      return condition;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.If#condition() condition} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for condition
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.If withCondition(Trees.Expression value) {
      if (this.condition == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "condition");
      return new ImmutableTrees.If(newValue);
    }

    /**
     * This instance is equal to all instances of {@code If} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.If
          && equalTo((ImmutableTrees.If) another);
    }

    private boolean equalTo(ImmutableTrees.If another) {
      return condition.equals(another.condition);
    }

    /**
     * Computes a hash code from attributes: {@code condition}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + condition.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code If} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("If")
          .omitNullValues()
          .add("condition", condition)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.If} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable If instance
     */
    public static ImmutableTrees.If copyOf(Trees.If instance) {
      if (instance instanceof ImmutableTrees.If) {
        return (ImmutableTrees.If) instance;
      }
      return ImmutableTrees.If.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.If If}.
     * @return A new If builder
     */
    public static ImmutableTrees.If.Builder builder() {
      return new ImmutableTrees.If.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.If If}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_CONDITION = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.Expression condition;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Conditional} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Conditional instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.If} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.If instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Conditional) {
          Trees.Conditional instance = (Trees.Conditional) object;
          condition(instance.condition());
        }
      }

      /**
       * Initializes the value for the {@link Trees.If#condition() condition} attribute.
       * @param condition The value for condition 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Preconditions.checkNotNull(condition, "condition");
        initBits &= ~INIT_BIT_CONDITION;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.If If}.
       * @return An immutable instance of If
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.If build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.If(condition);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_CONDITION) != 0) attributes.add("condition");
        return "Cannot build If, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Template}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.Template.builder()}.
   */
  @Immutable
  public static final class Template extends Trees.Template {
    private final boolean isPublic;
    private final ImmutableList<Trees.TemplatePart> parts;
    private final Trees.InvokableDeclaration declaration;

    private Template(ImmutableTrees.Template.Builder builder) {
      this.parts = builder.parts.build();
      this.declaration = builder.declaration;
      this.isPublic = builder.isPublicIsSet()
          ? builder.isPublic
          : super.isPublic();
    }

    private Template(
        boolean isPublic,
        ImmutableList<Trees.TemplatePart> parts,
        Trees.InvokableDeclaration declaration) {
      this.isPublic = isPublic;
      this.parts = parts;
      this.declaration = declaration;
    }

    /**
     * @return The value of the {@code isPublic} attribute
     */
    @Override
    public boolean isPublic() {
      return isPublic;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public Trees.InvokableDeclaration declaration() {
      return declaration;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Template#isPublic() isPublic} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for isPublic
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Template withIsPublic(boolean value) {
      if (this.isPublic == value) return this;
      return new ImmutableTrees.Template(value, this.parts, this.declaration);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.Template#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.Template withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.Template(this.isPublic, newValue, this.declaration);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.Template#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.Template withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.Template(this.isPublic, newValue, this.declaration);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Template#declaration() declaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for declaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Template withDeclaration(Trees.InvokableDeclaration value) {
      if (this.declaration == value) return this;
      Trees.InvokableDeclaration newValue = Preconditions.checkNotNull(value, "declaration");
      return new ImmutableTrees.Template(this.isPublic, this.parts, newValue);
    }

    /**
     * This instance is equal to all instances of {@code Template} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.Template
          && equalTo((ImmutableTrees.Template) another);
    }

    private boolean equalTo(ImmutableTrees.Template another) {
      return isPublic == another.isPublic
          && parts.equals(another.parts)
          && declaration.equals(another.declaration);
    }

    /**
     * Computes a hash code from attributes: {@code isPublic}, {@code parts}, {@code declaration}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + Booleans.hashCode(isPublic);
      h += (h << 5) + parts.hashCode();
      h += (h << 5) + declaration.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Template} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Template")
          .omitNullValues()
          .add("isPublic", isPublic)
          .add("parts", parts)
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.Template} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Template instance
     */
    public static ImmutableTrees.Template copyOf(Trees.Template instance) {
      if (instance instanceof ImmutableTrees.Template) {
        return (ImmutableTrees.Template) instance;
      }
      return ImmutableTrees.Template.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.Template Template}.
     * @return A new Template builder
     */
    public static ImmutableTrees.Template.Builder builder() {
      return new ImmutableTrees.Template.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.Template Template}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_DECLARATION = 0x1L;
      private static final long OPT_BIT_IS_PUBLIC = 0x1L;
      private long initBits = 0x1L;
      private long optBits;

      private boolean isPublic;
      private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();
      private @Nullable Trees.InvokableDeclaration declaration;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Block} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Block instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Template} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Template instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.InvokableStatement} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.InvokableStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Block) {
          Trees.Block instance = (Trees.Block) object;
          addAllParts(instance.parts());
        }
        if (object instanceof Trees.Template) {
          Trees.Template instance = (Trees.Template) object;
          isPublic(instance.isPublic());
        }
        if (object instanceof Trees.InvokableStatement) {
          Trees.InvokableStatement instance = (Trees.InvokableStatement) object;
          declaration(instance.declaration());
        }
      }

      /**
       * Initializes the value for the {@link Trees.Template#isPublic() isPublic} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Trees.Template#isPublic() isPublic}.</em>
       * @param isPublic The value for isPublic 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder isPublic(boolean isPublic) {
        this.isPublic = isPublic;
        optBits |= OPT_BIT_IS_PUBLIC;
        return this;
      }

      /**
       * Adds one element to {@link Trees.Template#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.Template#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.Template#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.Template#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.Template#declaration() declaration} attribute.
       * @param declaration The value for declaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Trees.InvokableDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration, "declaration");
        initBits &= ~INIT_BIT_DECLARATION;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.Template Template}.
       * @return An immutable instance of Template
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.Template build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.Template(this);
      }

      private boolean isPublicIsSet() {
        return (optBits & OPT_BIT_IS_PUBLIC) != 0;
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_DECLARATION) != 0) attributes.add("declaration");
        return "Cannot build Template, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.TextLine}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.TextLine.builder()}.
   */
  @Immutable
  public static final class TextLine extends Trees.TextLine {
    private final Trees.TextFragment fragment;
    private final boolean newline;

    private TextLine(ImmutableTrees.TextLine.Builder builder) {
      this.fragment = builder.fragment;
      this.newline = builder.newlineIsSet()
          ? builder.newline
          : super.newline();
    }

    private TextLine(Trees.TextFragment fragment, boolean newline) {
      this.fragment = fragment;
      this.newline = newline;
    }

    /**
     * @return The value of the {@code fragment} attribute
     */
    @Override
    public Trees.TextFragment fragment() {
      return fragment;
    }

    /**
     * @return The value of the {@code newline} attribute
     */
    @Override
    public boolean newline() {
      return newline;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TextLine#fragment() fragment} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for fragment
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TextLine withFragment(Trees.TextFragment value) {
      if (this.fragment == value) return this;
      Trees.TextFragment newValue = Preconditions.checkNotNull(value, "fragment");
      return new ImmutableTrees.TextLine(newValue, this.newline);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TextLine#newline() newline} attribute.
     * A value equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for newline
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TextLine withNewline(boolean value) {
      if (this.newline == value) return this;
      return new ImmutableTrees.TextLine(this.fragment, value);
    }

    /**
     * This instance is equal to all instances of {@code TextLine} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.TextLine
          && equalTo((ImmutableTrees.TextLine) another);
    }

    private boolean equalTo(ImmutableTrees.TextLine another) {
      return fragment.equals(another.fragment)
          && newline == another.newline;
    }

    /**
     * Computes a hash code from attributes: {@code fragment}, {@code newline}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + fragment.hashCode();
      h += (h << 5) + Booleans.hashCode(newline);
      return h;
    }

    /**
     * Creates an immutable copy of a {@link Trees.TextLine} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TextLine instance
     */
    public static ImmutableTrees.TextLine copyOf(Trees.TextLine instance) {
      if (instance instanceof ImmutableTrees.TextLine) {
        return (ImmutableTrees.TextLine) instance;
      }
      return ImmutableTrees.TextLine.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.TextLine TextLine}.
     * @return A new TextLine builder
     */
    public static ImmutableTrees.TextLine.Builder builder() {
      return new ImmutableTrees.TextLine.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.TextLine TextLine}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_FRAGMENT = 0x1L;
      private static final long OPT_BIT_NEWLINE = 0x1L;
      private long initBits = 0x1L;
      private long optBits;

      private @Nullable Trees.TextFragment fragment;
      private boolean newline;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code TextLine} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.TextLine instance) {
        Preconditions.checkNotNull(instance, "instance");
        fragment(instance.fragment());
        newline(instance.newline());
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TextLine#fragment() fragment} attribute.
       * @param fragment The value for fragment 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder fragment(Trees.TextFragment fragment) {
        this.fragment = Preconditions.checkNotNull(fragment, "fragment");
        initBits &= ~INIT_BIT_FRAGMENT;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TextLine#newline() newline} attribute.
       * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Trees.TextLine#newline() newline}.</em>
       * @param newline The value for newline 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder newline(boolean newline) {
        this.newline = newline;
        optBits |= OPT_BIT_NEWLINE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.TextLine TextLine}.
       * @return An immutable instance of TextLine
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.TextLine build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.TextLine(this);
      }

      private boolean newlineIsSet() {
        return (optBits & OPT_BIT_NEWLINE) != 0;
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_FRAGMENT) != 0) attributes.add("fragment");
        return "Cannot build TextLine, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Comment}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.Comment.of()}.
   */
  @Immutable
  public static final class Comment implements Trees.Comment {

    private Comment() {}

    /**
     * This instance is equal to all instances of {@code Comment} that have equal attribute values.
     * As instances of the {@code Comment} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 1487449787;
    }

    /**
     * Prints the immutable value {@code Comment}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "Comment{}";
    }

    private static final ImmutableTrees.Comment INSTANCE = new ImmutableTrees.Comment();

    /**
     * Returns the default immutable singleton value of {@code Comment}
     * @return An immutable instance of Comment
     */
    public static ImmutableTrees.Comment of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.TextBlock}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.TextBlock.builder()}.
   */
  @Immutable
  public static final class TextBlock implements Trees.TextBlock {
    private final ImmutableList<Trees.TextPart> parts;

    private TextBlock(ImmutableList<Trees.TextPart> parts) {
      this.parts = parts;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TextPart> parts() {
      return parts;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.TextBlock#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.TextBlock withParts(Trees.TextPart... elements) {
      ImmutableList<Trees.TextPart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.TextBlock(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.TextBlock#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.TextBlock withParts(Iterable<? extends Trees.TextPart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TextPart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.TextBlock(newValue);
    }

    /**
     * This instance is equal to all instances of {@code TextBlock} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.TextBlock
          && equalTo((ImmutableTrees.TextBlock) another);
    }

    private boolean equalTo(ImmutableTrees.TextBlock another) {
      return parts.equals(another.parts);
    }

    /**
     * Computes a hash code from attributes: {@code parts}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + parts.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code TextBlock} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TextBlock")
          .omitNullValues()
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.TextBlock} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TextBlock instance
     */
    public static ImmutableTrees.TextBlock copyOf(Trees.TextBlock instance) {
      if (instance instanceof ImmutableTrees.TextBlock) {
        return (ImmutableTrees.TextBlock) instance;
      }
      return ImmutableTrees.TextBlock.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.TextBlock TextBlock}.
     * @return A new TextBlock builder
     */
    public static ImmutableTrees.TextBlock.Builder builder() {
      return new ImmutableTrees.TextBlock.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.TextBlock TextBlock}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Trees.TextPart> parts = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code TextBlock} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * Collection elements and entries will be added, not replaced.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.TextBlock instance) {
        Preconditions.checkNotNull(instance, "instance");
        addAllParts(instance.parts());
        return this;
      }

      /**
       * Adds one element to {@link Trees.TextBlock#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TextPart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.TextBlock#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TextPart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.TextBlock#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TextPart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.TextBlock#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TextPart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.TextBlock TextBlock}.
       * @return An immutable instance of TextBlock
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.TextBlock build() {
        return new ImmutableTrees.TextBlock(parts.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.LetStatement}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.LetStatement.builder()}.
   */
  @Immutable
  public static final class LetStatement implements Trees.LetStatement {
    private final ImmutableList<Trees.TemplatePart> parts;
    private final Trees.InvokableDeclaration declaration;

    private LetStatement(
        ImmutableList<Trees.TemplatePart> parts,
        Trees.InvokableDeclaration declaration) {
      this.parts = parts;
      this.declaration = declaration;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public Trees.InvokableDeclaration declaration() {
      return declaration;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.LetStatement#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.LetStatement withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.LetStatement(newValue, this.declaration);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.LetStatement#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.LetStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.LetStatement(newValue, this.declaration);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.LetStatement#declaration() declaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for declaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.LetStatement withDeclaration(Trees.InvokableDeclaration value) {
      if (this.declaration == value) return this;
      Trees.InvokableDeclaration newValue = Preconditions.checkNotNull(value, "declaration");
      return new ImmutableTrees.LetStatement(this.parts, newValue);
    }

    /**
     * This instance is equal to all instances of {@code LetStatement} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.LetStatement
          && equalTo((ImmutableTrees.LetStatement) another);
    }

    private boolean equalTo(ImmutableTrees.LetStatement another) {
      return parts.equals(another.parts)
          && declaration.equals(another.declaration);
    }

    /**
     * Computes a hash code from attributes: {@code parts}, {@code declaration}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + parts.hashCode();
      h += (h << 5) + declaration.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code LetStatement} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("LetStatement")
          .omitNullValues()
          .add("parts", parts)
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.LetStatement} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable LetStatement instance
     */
    public static ImmutableTrees.LetStatement copyOf(Trees.LetStatement instance) {
      if (instance instanceof ImmutableTrees.LetStatement) {
        return (ImmutableTrees.LetStatement) instance;
      }
      return ImmutableTrees.LetStatement.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.LetStatement LetStatement}.
     * @return A new LetStatement builder
     */
    public static ImmutableTrees.LetStatement.Builder builder() {
      return new ImmutableTrees.LetStatement.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.LetStatement LetStatement}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_DECLARATION = 0x1L;
      private long initBits = 0x1L;

      private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();
      private @Nullable Trees.InvokableDeclaration declaration;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Block} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Block instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.InvokableStatement} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.InvokableStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.LetStatement} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.LetStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Block) {
          Trees.Block instance = (Trees.Block) object;
          addAllParts(instance.parts());
        }
        if (object instanceof Trees.InvokableStatement) {
          Trees.InvokableStatement instance = (Trees.InvokableStatement) object;
          declaration(instance.declaration());
        }
      }

      /**
       * Adds one element to {@link Trees.LetStatement#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.LetStatement#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.LetStatement#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.LetStatement#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.LetStatement#declaration() declaration} attribute.
       * @param declaration The value for declaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Trees.InvokableDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration, "declaration");
        initBits &= ~INIT_BIT_DECLARATION;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.LetStatement LetStatement}.
       * @return An immutable instance of LetStatement
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.LetStatement build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.LetStatement(parts.build(), declaration);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_DECLARATION) != 0) attributes.add("declaration");
        return "Cannot build LetStatement, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ConditionalBlock}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.ConditionalBlock.builder()}.
   */
  @Immutable
  public static final class ConditionalBlock implements Trees.ConditionalBlock {
    private final Trees.Expression condition;
    private final ImmutableList<Trees.TemplatePart> parts;

    private ConditionalBlock(
        Trees.Expression condition,
        ImmutableList<Trees.TemplatePart> parts) {
      this.condition = condition;
      this.parts = parts;
    }

    /**
     * @return The value of the {@code condition} attribute
     */
    @Override
    public Trees.Expression condition() {
      return condition;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ConditionalBlock#condition() condition} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for condition
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ConditionalBlock withCondition(Trees.Expression value) {
      if (this.condition == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "condition");
      return new ImmutableTrees.ConditionalBlock(newValue, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ConditionalBlock#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ConditionalBlock withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ConditionalBlock(this.condition, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ConditionalBlock#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ConditionalBlock withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ConditionalBlock(this.condition, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ConditionalBlock} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ConditionalBlock
          && equalTo((ImmutableTrees.ConditionalBlock) another);
    }

    private boolean equalTo(ImmutableTrees.ConditionalBlock another) {
      return condition.equals(another.condition)
          && parts.equals(another.parts);
    }

    /**
     * Computes a hash code from attributes: {@code condition}, {@code parts}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + condition.hashCode();
      h += (h << 5) + parts.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ConditionalBlock} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ConditionalBlock")
          .omitNullValues()
          .add("condition", condition)
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.ConditionalBlock} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ConditionalBlock instance
     */
    public static ImmutableTrees.ConditionalBlock copyOf(Trees.ConditionalBlock instance) {
      if (instance instanceof ImmutableTrees.ConditionalBlock) {
        return (ImmutableTrees.ConditionalBlock) instance;
      }
      return ImmutableTrees.ConditionalBlock.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.ConditionalBlock ConditionalBlock}.
     * @return A new ConditionalBlock builder
     */
    public static ImmutableTrees.ConditionalBlock.Builder builder() {
      return new ImmutableTrees.ConditionalBlock.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.ConditionalBlock ConditionalBlock}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_CONDITION = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.Expression condition;
      private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Conditional} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Conditional instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Block} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Block instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.ConditionalBlock} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.ConditionalBlock instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Conditional) {
          Trees.Conditional instance = (Trees.Conditional) object;
          condition(instance.condition());
        }
        if (object instanceof Trees.Block) {
          Trees.Block instance = (Trees.Block) object;
          addAllParts(instance.parts());
        }
      }

      /**
       * Initializes the value for the {@link Trees.ConditionalBlock#condition() condition} attribute.
       * @param condition The value for condition 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Preconditions.checkNotNull(condition, "condition");
        initBits &= ~INIT_BIT_CONDITION;
        return this;
      }

      /**
       * Adds one element to {@link Trees.ConditionalBlock#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.ConditionalBlock#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.ConditionalBlock#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.ConditionalBlock#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.ConditionalBlock ConditionalBlock}.
       * @return An immutable instance of ConditionalBlock
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.ConditionalBlock build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.ConditionalBlock(condition, parts.build());
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_CONDITION) != 0) attributes.add("condition");
        return "Cannot build ConditionalBlock, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ElseIf}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.ElseIf.builder()}.
   */
  @Immutable
  public static final class ElseIf implements Trees.ElseIf {
    private final Trees.Expression condition;

    private ElseIf(Trees.Expression condition) {
      this.condition = condition;
    }

    /**
     * @return The value of the {@code condition} attribute
     */
    @Override
    public Trees.Expression condition() {
      return condition;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ElseIf#condition() condition} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for condition
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ElseIf withCondition(Trees.Expression value) {
      if (this.condition == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "condition");
      return new ImmutableTrees.ElseIf(newValue);
    }

    /**
     * This instance is equal to all instances of {@code ElseIf} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ElseIf
          && equalTo((ImmutableTrees.ElseIf) another);
    }

    private boolean equalTo(ImmutableTrees.ElseIf another) {
      return condition.equals(another.condition);
    }

    /**
     * Computes a hash code from attributes: {@code condition}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + condition.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ElseIf} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ElseIf")
          .omitNullValues()
          .add("condition", condition)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.ElseIf} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ElseIf instance
     */
    public static ImmutableTrees.ElseIf copyOf(Trees.ElseIf instance) {
      if (instance instanceof ImmutableTrees.ElseIf) {
        return (ImmutableTrees.ElseIf) instance;
      }
      return ImmutableTrees.ElseIf.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.ElseIf ElseIf}.
     * @return A new ElseIf builder
     */
    public static ImmutableTrees.ElseIf.Builder builder() {
      return new ImmutableTrees.ElseIf.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.ElseIf ElseIf}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_CONDITION = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.Expression condition;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Conditional} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Conditional instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.ElseIf} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.ElseIf instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Conditional) {
          Trees.Conditional instance = (Trees.Conditional) object;
          condition(instance.condition());
        }
      }

      /**
       * Initializes the value for the {@link Trees.ElseIf#condition() condition} attribute.
       * @param condition The value for condition 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Preconditions.checkNotNull(condition, "condition");
        initBits &= ~INIT_BIT_CONDITION;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.ElseIf ElseIf}.
       * @return An immutable instance of ElseIf
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.ElseIf build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.ElseIf(condition);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_CONDITION) != 0) attributes.add("condition");
        return "Cannot build ElseIf, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ResolvedType}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.ResolvedType.builder()}.
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.ResolvedType.of()}.
   */
  @Immutable
  public static final class ResolvedType extends Trees.ResolvedType {
    private final Object type;

    private ResolvedType(Object type) {
      this.type = Preconditions.checkNotNull(type, "type");
    }

    private ResolvedType(ResolvedType original, Object type) {
      this.type = type;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    public Object type() {
      return type;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ResolvedType#type() type} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for type
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ResolvedType withType(Object value) {
      if (this.type == value) return this;
      Object newValue = Preconditions.checkNotNull(value, "type");
      return new ImmutableTrees.ResolvedType(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ResolvedType} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ResolvedType
          && equalTo((ImmutableTrees.ResolvedType) another);
    }

    private boolean equalTo(ImmutableTrees.ResolvedType another) {
      return type.equals(another.type);
    }

    /**
     * Computes a hash code from attributes: {@code type}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + type.hashCode();
      return h;
    }

    /**
     * Construct a new immutable {@code ResolvedType} instance.
     * @param type The value for the {@code type} attribute
     * @return An immutable ResolvedType instance
     */
    public static ImmutableTrees.ResolvedType of(Object type) {
      return new ImmutableTrees.ResolvedType(type);
    }

    /**
     * Creates an immutable copy of a {@link Trees.ResolvedType} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ResolvedType instance
     */
    public static ImmutableTrees.ResolvedType copyOf(Trees.ResolvedType instance) {
      if (instance instanceof ImmutableTrees.ResolvedType) {
        return (ImmutableTrees.ResolvedType) instance;
      }
      return ImmutableTrees.ResolvedType.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.ResolvedType ResolvedType}.
     * @return A new ResolvedType builder
     */
    public static ImmutableTrees.ResolvedType.Builder builder() {
      return new ImmutableTrees.ResolvedType.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.ResolvedType ResolvedType}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TYPE = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Object type;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code ResolvedType} instance.
       * Regular attribute values will be replaced with those from the given instance.
       * Absent optional values will not replace present values.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.ResolvedType instance) {
        Preconditions.checkNotNull(instance, "instance");
        type(instance.type());
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.ResolvedType#type() type} attribute.
       * @param type The value for type 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder type(Object type) {
        this.type = Preconditions.checkNotNull(type, "type");
        initBits &= ~INIT_BIT_TYPE;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.ResolvedType ResolvedType}.
       * @return An immutable instance of ResolvedType
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.ResolvedType build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.ResolvedType(null, type);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
        return "Cannot build ResolvedType, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.TypeIdentifier}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.TypeIdentifier.of()}.
   */
  @Immutable
  public static final class TypeIdentifier extends Trees.TypeIdentifier {
    private final String value;

    private TypeIdentifier(String value) {
      this.value = Preconditions.checkNotNull(value, "value");
    }

    private TypeIdentifier(TypeIdentifier original, String value) {
      this.value = value;
    }

    /**
     * @return The value of the {@code value} attribute
     */
    @Override
    public String value() {
      return value;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TypeIdentifier#value() value} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for value
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TypeIdentifier withValue(String value) {
      if (this.value.equals(value)) return this;
      String newValue = Preconditions.checkNotNull(value, "value");
      return new ImmutableTrees.TypeIdentifier(this, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TypeIdentifier} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.TypeIdentifier
          && equalTo((ImmutableTrees.TypeIdentifier) another);
    }

    private boolean equalTo(ImmutableTrees.TypeIdentifier another) {
      return value.equals(another.value);
    }

    /**
     * Computes a hash code from attributes: {@code value}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + value.hashCode();
      return h;
    }

    /**
     * Construct a new immutable {@code TypeIdentifier} instance.
     * @param value The value for the {@code value} attribute
     * @return An immutable TypeIdentifier instance
     */
    public static ImmutableTrees.TypeIdentifier of(String value) {
      return new ImmutableTrees.TypeIdentifier(value);
    }

    /**
     * Creates an immutable copy of a {@link Trees.TypeIdentifier} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TypeIdentifier instance
     */
    public static ImmutableTrees.TypeIdentifier copyOf(Trees.TypeIdentifier instance) {
      if (instance instanceof ImmutableTrees.TypeIdentifier) {
        return (ImmutableTrees.TypeIdentifier) instance;
      }
      return ImmutableTrees.TypeIdentifier.of(instance.value());
    }
  }

  /**
   * Immutable implementation of {@link Trees.InvokeStatement}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.InvokeStatement.builder()}.
   */
  @Immutable
  public static final class InvokeStatement implements Trees.InvokeStatement {
    private final Trees.Expression access;
    private final ImmutableList<Trees.Expression> params;
    private final ImmutableList<Trees.TemplatePart> parts;

    private InvokeStatement(
        Trees.Expression access,
        ImmutableList<Trees.Expression> params,
        ImmutableList<Trees.TemplatePart> parts) {
      this.access = access;
      this.params = params;
      this.parts = parts;
    }

    /**
     * @return The value of the {@code access} attribute
     */
    @Override
    public Trees.Expression access() {
      return access;
    }

    /**
     * @return The value of the {@code params} attribute
     */
    @Override
    public ImmutableList<Trees.Expression> params() {
      return params;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.InvokeStatement#access() access} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for access
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.InvokeStatement withAccess(Trees.Expression value) {
      if (this.access == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "access");
      return new ImmutableTrees.InvokeStatement(newValue, this.params, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.InvokeStatement#params() params}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.InvokeStatement withParams(Trees.Expression... elements) {
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.InvokeStatement(this.access, newValue, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.InvokeStatement#params() params}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of params elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.InvokeStatement withParams(Iterable<? extends Trees.Expression> elements) {
      if (this.params == elements) return this;
      ImmutableList<Trees.Expression> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.InvokeStatement(this.access, newValue, this.parts);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.InvokeStatement#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.InvokeStatement withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.InvokeStatement(this.access, this.params, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.InvokeStatement#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.InvokeStatement withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.InvokeStatement(this.access, this.params, newValue);
    }

    /**
     * This instance is equal to all instances of {@code InvokeStatement} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.InvokeStatement
          && equalTo((ImmutableTrees.InvokeStatement) another);
    }

    private boolean equalTo(ImmutableTrees.InvokeStatement another) {
      return access.equals(another.access)
          && params.equals(another.params)
          && parts.equals(another.parts);
    }

    /**
     * Computes a hash code from attributes: {@code access}, {@code params}, {@code parts}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + access.hashCode();
      h += (h << 5) + params.hashCode();
      h += (h << 5) + parts.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code InvokeStatement} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("InvokeStatement")
          .omitNullValues()
          .add("access", access)
          .add("params", params)
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.InvokeStatement} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable InvokeStatement instance
     */
    public static ImmutableTrees.InvokeStatement copyOf(Trees.InvokeStatement instance) {
      if (instance instanceof ImmutableTrees.InvokeStatement) {
        return (ImmutableTrees.InvokeStatement) instance;
      }
      return ImmutableTrees.InvokeStatement.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.InvokeStatement InvokeStatement}.
     * @return A new InvokeStatement builder
     */
    public static ImmutableTrees.InvokeStatement.Builder builder() {
      return new ImmutableTrees.InvokeStatement.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.InvokeStatement InvokeStatement}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_ACCESS = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.Expression access;
      private ImmutableList.Builder<Trees.Expression> params = ImmutableList.builder();
      private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.InvokeStatement} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.InvokeStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Block} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Block instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.InvokeStatement) {
          Trees.InvokeStatement instance = (Trees.InvokeStatement) object;
          addAllParams(instance.params());
          access(instance.access());
        }
        if (object instanceof Trees.Block) {
          Trees.Block instance = (Trees.Block) object;
          addAllParts(instance.parts());
        }
      }

      /**
       * Initializes the value for the {@link Trees.InvokeStatement#access() access} attribute.
       * @param access The value for access 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder access(Trees.Expression access) {
        this.access = Preconditions.checkNotNull(access, "access");
        initBits &= ~INIT_BIT_ACCESS;
        return this;
      }

      /**
       * Adds one element to {@link Trees.InvokeStatement#params() params} list.
       * @param element A params element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParams(Trees.Expression element) {
        this.params.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.InvokeStatement#params() params} list.
       * @param elements An array of params elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParams(Trees.Expression... elements) {
        this.params.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.InvokeStatement#params() params} list.
       * @param elements An iterable of params elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder params(Iterable<? extends Trees.Expression> elements) {
        this.params = ImmutableList.builder();
        return addAllParams(elements);
      }

      /**
       * Adds elements to {@link Trees.InvokeStatement#params() params} list.
       * @param elements An iterable of params elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParams(Iterable<? extends Trees.Expression> elements) {
        this.params.addAll(elements);
        return this;
      }

      /**
       * Adds one element to {@link Trees.InvokeStatement#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.InvokeStatement#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.InvokeStatement#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.InvokeStatement#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.InvokeStatement InvokeStatement}.
       * @return An immutable instance of InvokeStatement
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.InvokeStatement build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.InvokeStatement(access, params.build(), parts.build());
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_ACCESS) != 0) attributes.add("access");
        return "Cannot build InvokeStatement, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Newline}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.Newline.of()}.
   */
  @Immutable
  public static final class Newline extends Trees.Newline {

    private Newline() {}

    /**
     * This instance is equal to all instances of {@code Newline} that have equal attribute values.
     * As instances of the {@code Newline} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return -1911993872;
    }

    private static final ImmutableTrees.Newline INSTANCE = new ImmutableTrees.Newline();

    /**
     * Returns the default immutable singleton value of {@code Newline}
     * @return An immutable instance of Newline
     */
    public static ImmutableTrees.Newline of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.SimpleBlock}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.SimpleBlock.builder()}.
   */
  @Immutable
  public static final class SimpleBlock implements Trees.SimpleBlock {
    private final ImmutableList<Trees.TemplatePart> parts;

    private SimpleBlock(
        ImmutableList<Trees.TemplatePart> parts) {
      this.parts = parts;
    }

    /**
     * @return The value of the {@code parts} attribute
     */
    @Override
    public ImmutableList<Trees.TemplatePart> parts() {
      return parts;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.SimpleBlock#parts() parts}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.SimpleBlock withParts(Trees.TemplatePart... elements) {
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.SimpleBlock(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.SimpleBlock#parts() parts}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of parts elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.SimpleBlock withParts(Iterable<? extends Trees.TemplatePart> elements) {
      if (this.parts == elements) return this;
      ImmutableList<Trees.TemplatePart> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.SimpleBlock(newValue);
    }

    /**
     * This instance is equal to all instances of {@code SimpleBlock} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.SimpleBlock
          && equalTo((ImmutableTrees.SimpleBlock) another);
    }

    private boolean equalTo(ImmutableTrees.SimpleBlock another) {
      return parts.equals(another.parts);
    }

    /**
     * Computes a hash code from attributes: {@code parts}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + parts.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code SimpleBlock} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("SimpleBlock")
          .omitNullValues()
          .add("parts", parts)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.SimpleBlock} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable SimpleBlock instance
     */
    public static ImmutableTrees.SimpleBlock copyOf(Trees.SimpleBlock instance) {
      if (instance instanceof ImmutableTrees.SimpleBlock) {
        return (ImmutableTrees.SimpleBlock) instance;
      }
      return ImmutableTrees.SimpleBlock.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.SimpleBlock SimpleBlock}.
     * @return A new SimpleBlock builder
     */
    public static ImmutableTrees.SimpleBlock.Builder builder() {
      return new ImmutableTrees.SimpleBlock.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.SimpleBlock SimpleBlock}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private ImmutableList.Builder<Trees.TemplatePart> parts = ImmutableList.builder();

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Block} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Block instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.SimpleBlock} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.SimpleBlock instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.Block) {
          Trees.Block instance = (Trees.Block) object;
          addAllParts(instance.parts());
        }
      }

      /**
       * Adds one element to {@link Trees.SimpleBlock#parts() parts} list.
       * @param element A parts element
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart element) {
        this.parts.add(element);
        return this;
      }

      /**
       * Adds elements to {@link Trees.SimpleBlock#parts() parts} list.
       * @param elements An array of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addParts(Trees.TemplatePart... elements) {
        this.parts.add(elements);
        return this;
      }

      /**
       * Sets or replaces all elements for {@link Trees.SimpleBlock#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder parts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts = ImmutableList.builder();
        return addAllParts(elements);
      }

      /**
       * Adds elements to {@link Trees.SimpleBlock#parts() parts} list.
       * @param elements An iterable of parts elements
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder addAllParts(Iterable<? extends Trees.TemplatePart> elements) {
        this.parts.addAll(elements);
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.SimpleBlock SimpleBlock}.
       * @return An immutable instance of SimpleBlock
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.SimpleBlock build() {
        return new ImmutableTrees.SimpleBlock(parts.build());
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.ValueDeclaration}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.ValueDeclaration.builder()}.
   */
  @Immutable
  public static final class ValueDeclaration implements Trees.ValueDeclaration {
    private final Optional<Trees.TypeReference> type;
    private final Optional<Trees.TypeReference> containedType;
    private final Trees.Identifier name;

    private ValueDeclaration(
        Optional<Trees.TypeReference> type,
        Optional<Trees.TypeReference> containedType,
        Trees.Identifier name) {
      this.type = type;
      this.containedType = containedType;
      this.name = name;
    }

    /**
     * @return The value of the {@code type} attribute
     */
    @Override
    public Optional<Trees.TypeReference> type() {
      return type;
    }

    /**
     * @return The value of the {@code containedType} attribute
     */
    @Override
    public Optional<Trees.TypeReference> containedType() {
      return containedType;
    }

    /**
     * @return The value of the {@code name} attribute
     */
    @Override
    public Trees.Identifier name() {
      return name;
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Trees.ValueDeclaration#type() type} attribute.
     * @param value The value for type
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ValueDeclaration withType(Trees.TypeReference value) {
      Optional<Trees.TypeReference> newValue = Optional.of(value);
      if (this.type.isPresent() && this.type.get() == value) return this;
      return new ImmutableTrees.ValueDeclaration(newValue, this.containedType, this.name);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Trees.ValueDeclaration#type() type} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for type
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableTrees.ValueDeclaration withType(Optional<? extends Trees.TypeReference> optional) {
      Optional<Trees.TypeReference> value = (Optional<Trees.TypeReference>) optional;
      if (!this.type.isPresent() && !value.isPresent()) return this;
      if (this.type.isPresent() && value.isPresent() && this.type.get() == value.get()) return this;
      return new ImmutableTrees.ValueDeclaration(value, this.containedType, this.name);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Trees.ValueDeclaration#containedType() containedType} attribute.
     * @param value The value for containedType
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ValueDeclaration withContainedType(Trees.TypeReference value) {
      Optional<Trees.TypeReference> newValue = Optional.of(value);
      if (this.containedType.isPresent() && this.containedType.get() == value) return this;
      return new ImmutableTrees.ValueDeclaration(this.type, newValue, this.name);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Trees.ValueDeclaration#containedType() containedType} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for containedType
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableTrees.ValueDeclaration withContainedType(Optional<? extends Trees.TypeReference> optional) {
      Optional<Trees.TypeReference> value = (Optional<Trees.TypeReference>) optional;
      if (!this.containedType.isPresent() && !value.isPresent()) return this;
      if (this.containedType.isPresent() && value.isPresent() && this.containedType.get() == value.get()) return this;
      return new ImmutableTrees.ValueDeclaration(this.type, value, this.name);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ValueDeclaration#name() name} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for name
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ValueDeclaration withName(Trees.Identifier value) {
      if (this.name == value) return this;
      Trees.Identifier newValue = Preconditions.checkNotNull(value, "name");
      return new ImmutableTrees.ValueDeclaration(this.type, this.containedType, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ValueDeclaration} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ValueDeclaration
          && equalTo((ImmutableTrees.ValueDeclaration) another);
    }

    private boolean equalTo(ImmutableTrees.ValueDeclaration another) {
      return type.equals(another.type)
          && containedType.equals(another.containedType)
          && name.equals(another.name);
    }

    /**
     * Computes a hash code from attributes: {@code type}, {@code containedType}, {@code name}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + type.hashCode();
      h += (h << 5) + containedType.hashCode();
      h += (h << 5) + name.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ValueDeclaration} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ValueDeclaration")
          .omitNullValues()
          .add("type", type.orNull())
          .add("containedType", containedType.orNull())
          .add("name", name)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.ValueDeclaration} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ValueDeclaration instance
     */
    public static ImmutableTrees.ValueDeclaration copyOf(Trees.ValueDeclaration instance) {
      if (instance instanceof ImmutableTrees.ValueDeclaration) {
        return (ImmutableTrees.ValueDeclaration) instance;
      }
      return ImmutableTrees.ValueDeclaration.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.ValueDeclaration ValueDeclaration}.
     * @return A new ValueDeclaration builder
     */
    public static ImmutableTrees.ValueDeclaration.Builder builder() {
      return new ImmutableTrees.ValueDeclaration.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.ValueDeclaration ValueDeclaration}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_NAME = 0x1L;
      private long initBits = 0x1L;

      private Optional<Trees.TypeReference> type = Optional.absent();
      private Optional<Trees.TypeReference> containedType = Optional.absent();
      private @Nullable Trees.Identifier name;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.ValueDeclaration} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.ValueDeclaration instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Named} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Named instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.ValueDeclaration) {
          Trees.ValueDeclaration instance = (Trees.ValueDeclaration) object;
          Optional<Trees.TypeReference> typeOptional = instance.type();
          if (typeOptional.isPresent()) {
            type(typeOptional);
          }
          Optional<Trees.TypeReference> containedTypeOptional = instance.containedType();
          if (containedTypeOptional.isPresent()) {
            containedType(containedTypeOptional);
          }
        }
        if (object instanceof Trees.Named) {
          Trees.Named instance = (Trees.Named) object;
          name(instance.name());
        }
      }

      /**
       * Initializes the optional value {@link Trees.ValueDeclaration#type() type} to type.
       * @param type The value for type
       * @return {@code this} builder for chained invocation
       */
      public final Builder type(Trees.TypeReference type) {
        this.type = Optional.of(type);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.ValueDeclaration#type() type} to type.
       * @param type The value for type
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder type(Optional<? extends Trees.TypeReference> type) {
        this.type = (Optional<Trees.TypeReference>) type;
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.ValueDeclaration#containedType() containedType} to containedType.
       * @param containedType The value for containedType
       * @return {@code this} builder for chained invocation
       */
      public final Builder containedType(Trees.TypeReference containedType) {
        this.containedType = Optional.of(containedType);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.ValueDeclaration#containedType() containedType} to containedType.
       * @param containedType The value for containedType
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder containedType(Optional<? extends Trees.TypeReference> containedType) {
        this.containedType = (Optional<Trees.TypeReference>) containedType;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.ValueDeclaration#name() name} attribute.
       * @param name The value for name 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder name(Trees.Identifier name) {
        this.name = Preconditions.checkNotNull(name, "name");
        initBits &= ~INIT_BIT_NAME;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.ValueDeclaration ValueDeclaration}.
       * @return An immutable instance of ValueDeclaration
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.ValueDeclaration build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.ValueDeclaration(type, containedType, name);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
        return "Cannot build ValueDeclaration, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.IfEnd}.
   * <p>
   * Use the static factory method to get the default singleton instance:
   * {@code ImmutableTrees.IfEnd.of()}.
   */
  @Immutable
  public static final class IfEnd implements Trees.IfEnd {

    private IfEnd() {}

    /**
     * This instance is equal to all instances of {@code IfEnd} that have equal attribute values.
     * As instances of the {@code IfEnd} class are interned, the {@code equals} method is implemented
     * as an efficient reference equality check.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      return this == another;
    }

    /**
     * Returns a constant hash code value.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      return 2000076314;
    }

    /**
     * Prints the immutable value {@code IfEnd}.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "IfEnd{}";
    }

    private static final ImmutableTrees.IfEnd INSTANCE = new ImmutableTrees.IfEnd();

    /**
     * Returns the default immutable singleton value of {@code IfEnd}
     * @return An immutable instance of IfEnd
     */
    public static ImmutableTrees.IfEnd of() {
      return INSTANCE;
    }
  }

  /**
   * Immutable implementation of {@link Trees.ForIterationAccessExpression}.
   * <p>
   * Use the static factory method to create immutable instances:
   * {@code ImmutableTrees.ForIterationAccessExpression.of()}.
   */
  @Immutable
  public static final class ForIterationAccessExpression
      implements Trees.ForIterationAccessExpression {
    private final Trees.AccessExpression access;
    private final ImmutableList<Trees.Identifier> path;

    private ForIterationAccessExpression(Trees.AccessExpression access) {
      this.access = Preconditions.checkNotNull(access, "access");
      this.path = ImmutableList.of();
    }

    private ForIterationAccessExpression(
        Trees.AccessExpression access,
        ImmutableList<Trees.Identifier> path) {
      this.access = access;
      this.path = path;
    }

    /**
     * @return The value of the {@code access} attribute
     */
    @Override
    public Trees.AccessExpression access() {
      return access;
    }

    /**
     * @return The value of the {@code path} attribute
     */
    @Override
    public ImmutableList<Trees.Identifier> path() {
      return path;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.ForIterationAccessExpression#access() access} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for access
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.ForIterationAccessExpression withAccess(Trees.AccessExpression value) {
      if (this.access == value) return this;
      Trees.AccessExpression newValue = Preconditions.checkNotNull(value, "access");
      return new ImmutableTrees.ForIterationAccessExpression(newValue, this.path);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ForIterationAccessExpression#path() path}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ForIterationAccessExpression withPath(Trees.Identifier... elements) {
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ForIterationAccessExpression(this.access, newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link Trees.ForIterationAccessExpression#path() path}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of path elements to set
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.ForIterationAccessExpression withPath(Iterable<? extends Trees.Identifier> elements) {
      if (this.path == elements) return this;
      ImmutableList<Trees.Identifier> newValue = ImmutableList.copyOf(elements);
      return new ImmutableTrees.ForIterationAccessExpression(this.access, newValue);
    }

    /**
     * This instance is equal to all instances of {@code ForIterationAccessExpression} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.ForIterationAccessExpression
          && equalTo((ImmutableTrees.ForIterationAccessExpression) another);
    }

    private boolean equalTo(ImmutableTrees.ForIterationAccessExpression another) {
      return access.equals(another.access)
          && path.equals(another.path);
    }

    /**
     * Computes a hash code from attributes: {@code access}, {@code path}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + access.hashCode();
      h += (h << 5) + path.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code ForIterationAccessExpression} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("ForIterationAccessExpression")
          .omitNullValues()
          .add("access", access)
          .add("path", path)
          .toString();
    }

    /**
     * Construct a new immutable {@code ForIterationAccessExpression} instance.
     * @param access The value for the {@code access} attribute
     * @return An immutable ForIterationAccessExpression instance
     */
    public static ImmutableTrees.ForIterationAccessExpression of(Trees.AccessExpression access) {
      return new ImmutableTrees.ForIterationAccessExpression(access);
    }

    /**
     * Creates an immutable copy of a {@link Trees.ForIterationAccessExpression} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable ForIterationAccessExpression instance
     */
    public static ImmutableTrees.ForIterationAccessExpression copyOf(Trees.ForIterationAccessExpression instance) {
      if (instance instanceof ImmutableTrees.ForIterationAccessExpression) {
        return (ImmutableTrees.ForIterationAccessExpression) instance;
      }
      return ImmutableTrees.ForIterationAccessExpression.of(instance.access())
          .withPath(instance.path());
    }
  }

  /**
   * Immutable implementation of {@link Trees.TransformGenerator}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.TransformGenerator.builder()}.
   */
  @Immutable
  public static final class TransformGenerator implements Trees.TransformGenerator {
    private final Trees.Expression transform;
    private final Trees.ValueDeclaration varDeclaration;
    private final Optional<Trees.Expression> condition;
    private final Trees.ValueDeclaration declaration;
    private final Trees.Expression from;

    private TransformGenerator(
        Trees.Expression transform,
        Trees.ValueDeclaration varDeclaration,
        Optional<Trees.Expression> condition,
        Trees.ValueDeclaration declaration,
        Trees.Expression from) {
      this.transform = transform;
      this.varDeclaration = varDeclaration;
      this.condition = condition;
      this.declaration = declaration;
      this.from = from;
    }

    /**
     * @return The value of the {@code transform} attribute
     */
    @Override
    public Trees.Expression transform() {
      return transform;
    }

    /**
     * @return The value of the {@code varDeclaration} attribute
     */
    @Override
    public Trees.ValueDeclaration varDeclaration() {
      return varDeclaration;
    }

    /**
     * @return The value of the {@code condition} attribute
     */
    @Override
    public Optional<Trees.Expression> condition() {
      return condition;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public Trees.ValueDeclaration declaration() {
      return declaration;
    }

    /**
     * @return The value of the {@code from} attribute
     */
    @Override
    public Trees.Expression from() {
      return from;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TransformGenerator#transform() transform} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for transform
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TransformGenerator withTransform(Trees.Expression value) {
      if (this.transform == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "transform");
      return new ImmutableTrees.TransformGenerator(newValue, this.varDeclaration, this.condition, this.declaration, this.from);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TransformGenerator#varDeclaration() varDeclaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for varDeclaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TransformGenerator withVarDeclaration(Trees.ValueDeclaration value) {
      if (this.varDeclaration == value) return this;
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value, "varDeclaration");
      return new ImmutableTrees.TransformGenerator(this.transform, newValue, this.condition, this.declaration, this.from);
    }

    /**
     * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Trees.TransformGenerator#condition() condition} attribute.
     * @param value The value for condition
     * @return A modified copy of {@code this} object
     */
    public final ImmutableTrees.TransformGenerator withCondition(Trees.Expression value) {
      Optional<Trees.Expression> newValue = Optional.of(value);
      if (this.condition.isPresent() && this.condition.get() == value) return this;
      return new ImmutableTrees.TransformGenerator(this.transform, this.varDeclaration, newValue, this.declaration, this.from);
    }

    /**
     * Copy the current immutable object by setting an optional value for the {@link Trees.TransformGenerator#condition() condition} attribute.
     * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
     * @param optional A value for condition
     * @return A modified copy of {@code this} object
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    public final ImmutableTrees.TransformGenerator withCondition(Optional<? extends Trees.Expression> optional) {
      Optional<Trees.Expression> value = (Optional<Trees.Expression>) optional;
      if (!this.condition.isPresent() && !value.isPresent()) return this;
      if (this.condition.isPresent() && value.isPresent() && this.condition.get() == value.get()) return this;
      return new ImmutableTrees.TransformGenerator(this.transform, this.varDeclaration, value, this.declaration, this.from);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TransformGenerator#declaration() declaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for declaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TransformGenerator withDeclaration(Trees.ValueDeclaration value) {
      if (this.declaration == value) return this;
      Trees.ValueDeclaration newValue = Preconditions.checkNotNull(value, "declaration");
      return new ImmutableTrees.TransformGenerator(this.transform, this.varDeclaration, this.condition, newValue, this.from);
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.TransformGenerator#from() from} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for from
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.TransformGenerator withFrom(Trees.Expression value) {
      if (this.from == value) return this;
      Trees.Expression newValue = Preconditions.checkNotNull(value, "from");
      return new ImmutableTrees.TransformGenerator(this.transform, this.varDeclaration, this.condition, this.declaration, newValue);
    }

    /**
     * This instance is equal to all instances of {@code TransformGenerator} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.TransformGenerator
          && equalTo((ImmutableTrees.TransformGenerator) another);
    }

    private boolean equalTo(ImmutableTrees.TransformGenerator another) {
      return transform.equals(another.transform)
          && varDeclaration.equals(another.varDeclaration)
          && condition.equals(another.condition)
          && declaration.equals(another.declaration)
          && from.equals(another.from);
    }

    /**
     * Computes a hash code from attributes: {@code transform}, {@code varDeclaration}, {@code condition}, {@code declaration}, {@code from}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + transform.hashCode();
      h += (h << 5) + varDeclaration.hashCode();
      h += (h << 5) + condition.hashCode();
      h += (h << 5) + declaration.hashCode();
      h += (h << 5) + from.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code TransformGenerator} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("TransformGenerator")
          .omitNullValues()
          .add("transform", transform)
          .add("varDeclaration", varDeclaration)
          .add("condition", condition.orNull())
          .add("declaration", declaration)
          .add("from", from)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.TransformGenerator} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable TransformGenerator instance
     */
    public static ImmutableTrees.TransformGenerator copyOf(Trees.TransformGenerator instance) {
      if (instance instanceof ImmutableTrees.TransformGenerator) {
        return (ImmutableTrees.TransformGenerator) instance;
      }
      return ImmutableTrees.TransformGenerator.builder()
          .transform(instance.transform())
          .varDeclaration(instance.varDeclaration())
          .condition(instance.condition())
          .declaration(instance.declaration())
          .from(instance.from())
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.TransformGenerator TransformGenerator}.
     * @return A new TransformGenerator builder
     */
    public static ImmutableTrees.TransformGenerator.Builder builder() {
      return new ImmutableTrees.TransformGenerator.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.TransformGenerator TransformGenerator}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_TRANSFORM = 0x1L;
      private static final long INIT_BIT_VAR_DECLARATION = 0x2L;
      private static final long INIT_BIT_DECLARATION = 0x4L;
      private static final long INIT_BIT_FROM = 0x8L;
      private long initBits = 0xfL;

      private @Nullable Trees.Expression transform;
      private @Nullable Trees.ValueDeclaration varDeclaration;
      private Optional<Trees.Expression> condition = Optional.absent();
      private @Nullable Trees.ValueDeclaration declaration;
      private @Nullable Trees.Expression from;

      private Builder() {
      }

      /**
       * Initializes the value for the {@link Trees.TransformGenerator#transform() transform} attribute.
       * @param transform The value for transform 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder transform(Trees.Expression transform) {
        this.transform = Preconditions.checkNotNull(transform, "transform");
        initBits &= ~INIT_BIT_TRANSFORM;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TransformGenerator#varDeclaration() varDeclaration} attribute.
       * @param varDeclaration The value for varDeclaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder varDeclaration(Trees.ValueDeclaration varDeclaration) {
        this.varDeclaration = Preconditions.checkNotNull(varDeclaration, "varDeclaration");
        initBits &= ~INIT_BIT_VAR_DECLARATION;
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.TransformGenerator#condition() condition} to condition.
       * @param condition The value for condition
       * @return {@code this} builder for chained invocation
       */
      public final Builder condition(Trees.Expression condition) {
        this.condition = Optional.of(condition);
        return this;
      }

      /**
       * Initializes the optional value {@link Trees.TransformGenerator#condition() condition} to condition.
       * @param condition The value for condition
       * @return {@code this} builder for use in a chained invocation
       */
      @SuppressWarnings("unchecked") // safe covariant cast
      public final Builder condition(Optional<? extends Trees.Expression> condition) {
        this.condition = (Optional<Trees.Expression>) condition;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TransformGenerator#declaration() declaration} attribute.
       * @param declaration The value for declaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Trees.ValueDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration, "declaration");
        initBits &= ~INIT_BIT_DECLARATION;
        return this;
      }

      /**
       * Initializes the value for the {@link Trees.TransformGenerator#from() from} attribute.
       * @param from The value for from 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Expression from) {
        this.from = Preconditions.checkNotNull(from, "from");
        initBits &= ~INIT_BIT_FROM;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.TransformGenerator TransformGenerator}.
       * @return An immutable instance of TransformGenerator
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.TransformGenerator build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.TransformGenerator(transform, varDeclaration, condition, declaration, from);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_TRANSFORM) != 0) attributes.add("transform");
        if ((initBits & INIT_BIT_VAR_DECLARATION) != 0) attributes.add("varDeclaration");
        if ((initBits & INIT_BIT_DECLARATION) != 0) attributes.add("declaration");
        if ((initBits & INIT_BIT_FROM) != 0) attributes.add("from");
        return "Cannot build TransformGenerator, some of required attributes are not set " + attributes;
      }
    }
  }

  /**
   * Immutable implementation of {@link Trees.Let}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code ImmutableTrees.Let.builder()}.
   */
  @Immutable
  public static final class Let implements Trees.Let {
    private final Trees.InvokableDeclaration declaration;

    private Let(Trees.InvokableDeclaration declaration) {
      this.declaration = declaration;
    }

    /**
     * @return The value of the {@code declaration} attribute
     */
    @Override
    public Trees.InvokableDeclaration declaration() {
      return declaration;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link Trees.Let#declaration() declaration} attribute.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for declaration
     * @return A modified copy of the {@code this} object
     */
    public final ImmutableTrees.Let withDeclaration(Trees.InvokableDeclaration value) {
      if (this.declaration == value) return this;
      Trees.InvokableDeclaration newValue = Preconditions.checkNotNull(value, "declaration");
      return new ImmutableTrees.Let(newValue);
    }

    /**
     * This instance is equal to all instances of {@code Let} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof ImmutableTrees.Let
          && equalTo((ImmutableTrees.Let) another);
    }

    private boolean equalTo(ImmutableTrees.Let another) {
      return declaration.equals(another.declaration);
    }

    /**
     * Computes a hash code from attributes: {@code declaration}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      int h = 5381;
      h += (h << 5) + declaration.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code Let} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("Let")
          .omitNullValues()
          .add("declaration", declaration)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link Trees.Let} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable Let instance
     */
    public static ImmutableTrees.Let copyOf(Trees.Let instance) {
      if (instance instanceof ImmutableTrees.Let) {
        return (ImmutableTrees.Let) instance;
      }
      return ImmutableTrees.Let.builder()
          .from(instance)
          .build();
    }

    /**
     * Creates a builder for {@link ImmutableTrees.Let Let}.
     * @return A new Let builder
     */
    public static ImmutableTrees.Let.Builder builder() {
      return new ImmutableTrees.Let.Builder();
    }

    /**
     * Builds instances of type {@link ImmutableTrees.Let Let}.
     * Initialize attributes and then invoke the {@link #build()} method to create an
     * immutable instance.
     * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
     * but instead used immediately to create instances.</em>
     */
    @NotThreadSafe
    public static final class Builder {
      private static final long INIT_BIT_DECLARATION = 0x1L;
      private long initBits = 0x1L;

      private @Nullable Trees.InvokableDeclaration declaration;

      private Builder() {
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.InvokableStatement} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.InvokableStatement instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      /**
       * Fill a builder with attribute values from the provided {@code org.immutables.generator.processor.Trees.Let} instance.
       * @param instance The instance from which to copy values
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder from(Trees.Let instance) {
        Preconditions.checkNotNull(instance, "instance");
        from((Object) instance);
        return this;
      }

      private void from(Object object) {
        if (object instanceof Trees.InvokableStatement) {
          Trees.InvokableStatement instance = (Trees.InvokableStatement) object;
          declaration(instance.declaration());
        }
      }

      /**
       * Initializes the value for the {@link Trees.Let#declaration() declaration} attribute.
       * @param declaration The value for declaration 
       * @return {@code this} builder for use in a chained invocation
       */
      public final Builder declaration(Trees.InvokableDeclaration declaration) {
        this.declaration = Preconditions.checkNotNull(declaration, "declaration");
        initBits &= ~INIT_BIT_DECLARATION;
        return this;
      }

      /**
       * Builds a new {@link ImmutableTrees.Let Let}.
       * @return An immutable instance of Let
       * @throws java.lang.IllegalStateException if any required attributes are missing
       */
      public ImmutableTrees.Let build() {
        if (initBits != 0) {
          throw new IllegalStateException(formatRequiredAttributesMessage());
        }
        return new ImmutableTrees.Let(declaration);
      }

      private String formatRequiredAttributesMessage() {
        List<String> attributes = Lists.newArrayList();
        if ((initBits & INIT_BIT_DECLARATION) != 0) attributes.add("declaration");
        return "Cannot build Let, some of required attributes are not set " + attributes;
      }
    }
  }
}
