/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import org.immutables.criteria.elasticsearch.JsonConverter;

class DefaultConverter<T>
implements JsonConverter<T> {
    private final ObjectMapper mapper;
    private final JavaType javaType;

    private DefaultConverter(ObjectMapper mapper, JavaType javaType) {
        this.mapper = mapper;
        this.javaType = javaType;
    }

    @Override
    public T convert(JsonNode node) {
        return (T)this.mapper.convertValue((Object)node, this.javaType);
    }

    static <T> JsonConverter<T> of(ObjectMapper mapper, Class<T> type) {
        return new DefaultConverter<T>(mapper, mapper.getTypeFactory().constructType(type));
    }

    static <T> JsonConverter<T> of(ObjectMapper mapper, Type type) {
        return new DefaultConverter<T>(mapper, mapper.getTypeFactory().constructType(type));
    }
}

