/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import org.immutables.check.Checkers;
import org.immutables.criteria.elasticsearch.Version;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class VersionTest {
    VersionTest() {
    }

    @Test
    void version() {
        Checkers.check((Object)Version.of((String)"1.2.3").major).is((Object)1);
        Checkers.check((Object)Version.of((String)"2.2.3").major).is((Object)2);
        Checkers.check((Object)Version.of((String)"7").major).is((Object)7);
        Checkers.check((Object)Version.of((String)"7.1").major).is((Object)7);
        Checkers.check((Object)Version.of((String)"7.1.2").major).is((Object)7);
        Checkers.check((Object)Version.of((String)"7.1-pre").major).is((Object)7);
        Checkers.check((Object)Version.of((String)"3-beta").major).is((Object)3);
        Checkers.check((Object)Version.of((String)"200-ea").major).is((Object)200);
        Checkers.check((Object)Version.of((String)"2014.12.12").major).is((Object)2014);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((String)"aa"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((String)"a.b"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((String)"."));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((String)".."));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Version.of((String)".2"));
    }
}

