/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Collections;
import java.util.function.Predicate;
import org.immutables.criteria.Criterias;
import org.immutables.criteria.Criterion;
import org.immutables.criteria.backend.KeyExtractor;
import org.immutables.criteria.backend.PathNaming;
import org.immutables.criteria.elasticsearch.AggregateQueryBuilder;
import org.immutables.criteria.elasticsearch.Elasticsearch;
import org.immutables.criteria.elasticsearch.JsonChecker;
import org.immutables.criteria.elasticsearch.Mapping;
import org.immutables.criteria.elasticsearch.PersonModel;
import org.immutables.criteria.expression.Collation;
import org.immutables.criteria.expression.Expression;
import org.immutables.criteria.expression.ImmutableQuery;
import org.immutables.criteria.expression.Path;
import org.immutables.criteria.expression.Query;
import org.immutables.criteria.matcher.Aggregation;
import org.immutables.criteria.matcher.Matchers;
import org.immutables.criteria.matcher.Projection;
import org.immutables.criteria.personmodel.Person;
import org.immutables.criteria.personmodel.PersonCriteria;
import org.junit.jupiter.api.Test;

class AggregateQueryBuilderTest {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).registerModule((Module)new GuavaModule()).registerModule((Module)new Jdk8Module());
    private final Mapping mapping = Mapping.ofElastic(PersonModel.MAPPING);
    private final PathNaming pathNaming = PathNaming.defaultNaming();
    private final Predicate<Path> idPredicate = Elasticsearch.idPredicate((KeyExtractor.KeyMetadata)KeyExtractor.defaultFactory().create(Person.class).metadata());

    AggregateQueryBuilderTest() {
    }

    @Test
    void agg1() {
        PersonCriteria person = PersonCriteria.person;
        ImmutableQuery query = Query.of(Person.class).addGroupBy(new Expression[]{Matchers.toExpression((Projection)person.nickName)}).addCollations(Collections.singleton(Collation.of((Expression)Matchers.toExpression((Projection)person.nickName)))).addProjections(new Expression[]{Matchers.toExpression((Projection)person.nickName), Matchers.toExpression((Aggregation)person.age.sum()), Matchers.toExpression((Aggregation)person.dateOfBirth.max())}).withFilter((Expression)Criterias.toQuery((Criterion)((Criterion)person.age.atLeast((Comparable)Integer.valueOf(30)))).filter().get()).withLimit(11L);
        AggregateQueryBuilder builder = new AggregateQueryBuilder((Query)query, MAPPER, this.mapping, this.pathNaming, this.idPredicate);
        ObjectNode json = builder.jsonQuery();
        JsonChecker.of((JsonNode)json).is("{'_source':false,", "size:0,", "'stored_fields':'_none_',", "'query.constant_score.filter.range.age.gte' : 30,", "aggregations:{expr0:{terms:{field:'nickName',missing:'__MISSING__',size:11, order:{'_key':'asc'}},", "aggregations:{expr1:{sum:{field:'age'}},expr2:{max:{field:'dateOfBirth'}}}}}}");
    }
}

