/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.reindex.ReindexPlugin;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.painless.PainlessPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;

class EmbeddedElasticsearchNode
implements Closeable {
    private final Node node;
    private volatile boolean isStarted;

    private EmbeddedElasticsearchNode(Node node) {
        this.node = Objects.requireNonNull(node, "node");
    }

    private static EmbeddedElasticsearchNode create(Settings settings) {
        LocalNode node = new LocalNode(settings, Arrays.asList(Netty4Plugin.class, PainlessPlugin.class, ReindexPlugin.class));
        return new EmbeddedElasticsearchNode(node);
    }

    static synchronized EmbeddedElasticsearchNode create() {
        File home = Files.createTempDir();
        home.deleteOnExit();
        Settings settings = Settings.builder().put("node.name", "embedded-test-elastic").put("path.home", home.getAbsolutePath()).put("http.type", "netty4").put("transport.tcp.port", 0).put("http.port", 0).put("network.host", "localhost").build();
        return EmbeddedElasticsearchNode.create(settings);
    }

    void start() {
        Preconditions.checkState((!this.isStarted ? 1 : 0) != 0, (Object)"already started");
        try {
            this.node.start();
            this.isStarted = true;
        }
        catch (NodeValidationException e) {
            throw new RuntimeException(e);
        }
    }

    TransportAddress httpAddress() {
        Preconditions.checkState((boolean)this.isStarted, (Object)"node was not started");
        NodesInfoResponse response = (NodesInfoResponse)this.node.client().admin().cluster().prepareNodesInfo(new String[0]).execute().actionGet();
        if (response.getNodes().size() != 1) {
            throw new IllegalStateException("Expected single node but got " + response.getNodes().size());
        }
        NodeInfo node = (NodeInfo)response.getNodes().get(0);
        return node.getHttp().address().boundAddresses()[0];
    }

    @Override
    public void close() throws IOException {
        this.node.close();
        for (String name : Arrays.asList("path.data", "path.home")) {
            String path = this.node.settings().get(name);
            if (path == null) continue;
            EmbeddedElasticsearchNode.deleteRecursively(new File(path));
        }
    }

    private static void deleteRecursively(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                EmbeddedElasticsearchNode.deleteRecursively(f);
            }
        }
        path.delete();
    }

    private static class LocalNode
    extends Node {
        private LocalNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment((Settings)settings, Collections.emptyMap(), null, () -> "default_node_name"), classpathPlugins, false);
        }
    }
}

