/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import org.elasticsearch.client.RestClient;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.WithSessionCallback;
import org.immutables.criteria.elasticsearch.ElasticExtension;
import org.immutables.criteria.elasticsearch.ElasticPersonTest;
import org.immutables.criteria.elasticsearch.ElasticsearchBackend;
import org.immutables.criteria.elasticsearch.ElasticsearchSetup;
import org.immutables.criteria.elasticsearch.IndexOps;
import org.immutables.criteria.elasticsearch.IndexResolver;
import org.immutables.criteria.elasticsearch.Mappings;
import org.immutables.criteria.typemodel.BigDecimalTemplate;
import org.immutables.criteria.typemodel.BooleanLogicTemplate;
import org.immutables.criteria.typemodel.BooleanTemplate;
import org.immutables.criteria.typemodel.CountTemplate;
import org.immutables.criteria.typemodel.DateTemplate;
import org.immutables.criteria.typemodel.DeleteByKeyTemplate;
import org.immutables.criteria.typemodel.DoubleTemplate;
import org.immutables.criteria.typemodel.EnumTemplate;
import org.immutables.criteria.typemodel.GetByKeyTemplate;
import org.immutables.criteria.typemodel.InstantTemplate;
import org.immutables.criteria.typemodel.IntegerTemplate;
import org.immutables.criteria.typemodel.LocalDateTemplate;
import org.immutables.criteria.typemodel.LocalDateTimeTemplate;
import org.immutables.criteria.typemodel.LongTemplate;
import org.immutables.criteria.typemodel.StringTemplate;
import org.immutables.criteria.typemodel.WriteTemplate;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ElasticExtension.class})
class ElasticIntegrationTests {
    private final Backend backend;
    private final ObjectMapper mapper = ElasticPersonTest.MAPPER;

    ElasticIntegrationTests(RestClient restClient) {
        ElasticsearchBackend backend = new ElasticsearchBackend((ElasticsearchSetup)ElasticsearchSetup.builder((RestClient)restClient).objectMapper(this.mapper).build());
        Consumer<Class> onOpen = entity -> {
            String name = IndexResolver.defaultResolver().resolve(entity);
            IndexOps ops = new IndexOps(restClient, this.mapper, name);
            if (!((Boolean)ops.exists().blockingGet()).booleanValue()) {
                ops.create(Mappings.of(entity)).blockingAwait();
            }
        };
        this.backend = WithSessionCallback.wrap((Backend)backend, onOpen);
    }

    @Nested
    class WriteTest
    extends WriteTemplate {
        private WriteTest() {
            super(ElasticIntegrationTests.this.backend);
        }

        @Disabled
        protected void insert() {
        }

        @Disabled
        protected void update() {
        }

        @Disabled
        protected void upsert() {
        }
    }

    @Nested
    class DeleteByKey
    extends DeleteByKeyTemplate {
        private DeleteByKey() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class GetByKey
    extends GetByKeyTemplate {
        private GetByKey() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class Count
    extends CountTemplate {
        private Count() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class DateTest
    extends DateTemplate {
        private DateTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class BigDecimalTest
    extends BigDecimalTemplate {
        private BigDecimalTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class IntegerTest
    extends IntegerTemplate {
        private IntegerTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class DoubleTest
    extends DoubleTemplate {
        private DoubleTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class EnumTest
    extends EnumTemplate {
        private EnumTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class LongTest
    extends LongTemplate {
        private LongTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class InstantTest
    extends InstantTemplate {
        private InstantTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class LocalDateTimeTest
    extends LocalDateTimeTemplate {
        private LocalDateTimeTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class LocalDateTest
    extends LocalDateTemplate {
        private LocalDateTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class BooleanTest
    extends BooleanTemplate {
        private BooleanTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class BooleanLogicTest
    extends BooleanLogicTemplate {
        private BooleanLogicTest() {
            super(ElasticIntegrationTests.this.backend);
        }
    }

    @Nested
    class StringTest
    extends StringTemplate {
        private StringTest() {
            super(ElasticIntegrationTests.this.backend);
        }

        @Disabled(value="Does not yet work in Elastic")
        protected void upperLowerCase() {
        }
    }
}

