/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.immutables.criteria.Criterion;
import org.immutables.criteria.backend.Backend;
import org.immutables.criteria.backend.WriteResult;
import org.immutables.criteria.elasticsearch.ElasticModel;
import org.immutables.criteria.repository.Repository;
import org.immutables.criteria.repository.Updater;
import org.immutables.criteria.repository.sync.SyncReadable;
import org.immutables.criteria.repository.sync.SyncReader;
import org.immutables.criteria.repository.sync.SyncRepository;
import org.immutables.criteria.repository.sync.SyncWritable;

@ThreadSafe
public class ElasticModelRepository
implements Repository<ElasticModel>,
SyncRepository.Readable<ElasticModel>,
SyncRepository.Writable<ElasticModel> {
    private final Backend backend;
    private final SyncReadable<ElasticModel> readable;
    private final SyncWritable<ElasticModel> writable;

    public ElasticModelRepository(Backend backend) {
        this.backend = Objects.requireNonNull(backend, "backend");
        Backend.Session session = backend.open(ElasticModel.class);
        this.readable = new SyncReadable(session);
        this.writable = new SyncWritable(session);
    }

    public SyncReader<ElasticModel> find(Criterion<ElasticModel> arg0) {
        return this.readable.find(arg0);
    }

    public SyncReader<ElasticModel> findAll() {
        return this.readable.findAll();
    }

    public WriteResult insert(ElasticModel doc) {
        return (WriteResult)this.writable.insert((Object)doc);
    }

    public WriteResult insertAll(Iterable<? extends ElasticModel> arg0) {
        return this.writable.insertAll(arg0);
    }

    public WriteResult delete(Criterion<ElasticModel> arg0) {
        return this.writable.delete(arg0);
    }

    public WriteResult upsert(ElasticModel doc) {
        return (WriteResult)this.writable.upsert((Object)doc);
    }

    public WriteResult upsertAll(Iterable<? extends ElasticModel> arg0) {
        return this.writable.upsertAll(arg0);
    }

    public WriteResult update(ElasticModel doc) {
        return (WriteResult)this.writable.update((Object)doc);
    }

    public WriteResult updateAll(Iterable<? extends ElasticModel> arg0) {
        return this.writable.updateAll(arg0);
    }

    public Updater<ElasticModel, WriteResult> update(Criterion<ElasticModel> arg0) {
        return this.writable.update(arg0);
    }
}

