/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.criteria.elasticsearch;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.transport.TransportAddress;
import org.immutables.criteria.elasticsearch.EmbeddedElasticsearchNode;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class ElasticExtension
implements ParameterResolver,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ElasticExtension.class});
    private static final String KEY = "elastic";

    ElasticExtension() {
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == RestClient.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return ElasticExtension.getOrCreate(extensionContext).restClient();
    }

    private static ElasticResource getOrCreate(ExtensionContext context) {
        return (ElasticResource)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)KEY, key -> new ElasticResource(EmbeddedElasticsearchNode.create()), ElasticResource.class);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        ElasticResource resource = (ElasticResource)context.getStore(NAMESPACE).get((Object)KEY, ElasticResource.class);
        if (resource != null) {
            resource.clear();
        }
    }

    private static class ElasticResource
    implements ExtensionContext.Store.CloseableResource {
        private final EmbeddedElasticsearchNode node;
        private final Closer closer;
        private final RestClient client;

        private ElasticResource(EmbeddedElasticsearchNode node) {
            this.node = Objects.requireNonNull(node, "node");
            this.closer = Closer.create();
            this.closer.register((Closeable)node);
            node.start();
            this.client = RestClient.builder((HttpHost[])new HttpHost[]{this.httpHost()}).build();
            this.closer.register((Closeable)this.client);
        }

        public void close() throws Exception {
            this.closer.close();
        }

        void clear() throws IOException {
            Request request = new Request("GET", "/_cat/indices/?h=index");
            String context = EntityUtils.toString((HttpEntity)this.restClient().performRequest(request).getEntity());
            for (String index : context.split("\\n")) {
                this.restClient().performRequest(new Request("DELETE", "/" + index));
            }
        }

        RestClient restClient() {
            return this.client;
        }

        private HttpHost httpHost() {
            TransportAddress address = this.node.httpAddress();
            return new HttpHost(address.getAddress(), address.getPort());
        }
    }
}

